/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Sets;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class Filter {
    public static <T> Inner<T> create() {
        return new Inner();
    }

    public static class Inner<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final Map<String, SerializableFunction<?, Boolean>> fieldNameFilters = Maps.newHashMap();
        private final Map<Integer, SerializableFunction<?, Boolean>> fieldIdFilters = Maps.newHashMap();
        private final Map<List<String>, SerializableFunction<Row, Boolean>> fieldNamesFilters = Maps.newHashMap();
        private final Map<List<Integer>, SerializableFunction<Row, Boolean>> fieldIdsFilters = Maps.newHashMap();

        public Inner<T> whereFieldName(String fieldName, SerializableFunction<?, Boolean> predicate) {
            this.fieldNameFilters.put(fieldName, predicate);
            return this;
        }

        public Inner<T> whereFieldId(int fieldId, SerializableFunction<?, Boolean> predicate) {
            this.fieldIdFilters.put(fieldId, predicate);
            return this;
        }

        public Inner<T> whereFieldNames(List<String> fieldNames, SerializableFunction<Row, Boolean> predicate) {
            this.fieldNamesFilters.put(fieldNames, predicate);
            return this;
        }

        public Inner<T> whereFieldIds(List<Integer> fieldIds, SerializableFunction<Row, Boolean> predicate) {
            this.fieldIdsFilters.put(fieldIds, predicate);
            return this;
        }

        @Override
        public PCollection<T> expand(PCollection<T> input) {
            Schema schema = input.getSchema();
            for (String fieldName : Sets.union(this.fieldNameFilters.keySet(), this.fieldNamesFilters.keySet().stream().flatMap(Collection::stream).collect(Collectors.toSet()))) {
                schema.getField(fieldName);
            }
            Iterator iterator = Sets.union(this.fieldIdFilters.keySet(), this.fieldIdsFilters.keySet().stream().flatMap(Collection::stream).collect(Collectors.toSet())).iterator();
            while (iterator.hasNext()) {
                int fieldIndex = (Integer)iterator.next();
                if (fieldIndex < schema.getFieldCount() && fieldIndex >= 0) continue;
                throw new IllegalArgumentException("Field index " + fieldIndex + " does not exist in the schema.");
            }
            return (PCollection)input.apply(ParDo.of(new DoFn<T, T>(){

                @DoFn.ProcessElement
                public void process(@DoFn.Element Row row, DoFn.OutputReceiver<Row> o) {
                    for (Map.Entry entry : fieldNameFilters.entrySet()) {
                        if (((Boolean)((SerializableFunction)entry.getValue()).apply(row.getValue((String)entry.getKey()))).booleanValue()) continue;
                        return;
                    }
                    for (Map.Entry entry : fieldIdFilters.entrySet()) {
                        if (((Boolean)((SerializableFunction)entry.getValue()).apply(row.getValue((Integer)entry.getKey()))).booleanValue()) continue;
                        return;
                    }
                    for (SerializableFunction predicate : fieldNamesFilters.values()) {
                        if (((Boolean)predicate.apply(row)).booleanValue()) continue;
                        return;
                    }
                    for (SerializableFunction predicate : fieldIdsFilters.values()) {
                        if (((Boolean)predicate.apply(row)).booleanValue()) continue;
                        return;
                    }
                    o.output(row);
                }
            }));
        }
    }
}

