/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.transforms.SchemaAggregateFn;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class Group {
    public static <T> Global<T> globally() {
        return new Global();
    }

    public static <T> ByFields<T> byFieldNames(String ... fieldNames) {
        return new ByFields(FieldAccessDescriptor.withFieldNames(fieldNames));
    }

    public static <T> ByFields<T> byFieldNames(Iterable<String> fieldNames) {
        return new ByFields(FieldAccessDescriptor.withFieldNames(fieldNames));
    }

    public static <T> ByFields<T> byFieldIds(Integer ... fieldIds) {
        return new ByFields(FieldAccessDescriptor.withFieldIds(fieldIds));
    }

    public static <T> ByFields<T> byFieldIds(Iterable<Integer> fieldIds) {
        return new ByFields(FieldAccessDescriptor.withFieldIds(fieldIds));
    }

    public static <T> ByFields<T> byFieldAccessDescriptor(FieldAccessDescriptor fieldAccess) {
        return new ByFields(fieldAccess);
    }

    public static class CombineFieldsByFields<InputT>
    extends PTransform<PCollection<InputT>, PCollection<KV<Row, Row>>> {
        private final ByFields<InputT> byFields;
        private final SchemaAggregateFn.Inner<InputT> schemaAggregateFn;

        CombineFieldsByFields(ByFields<InputT> byFields, SchemaAggregateFn.Inner<InputT> schemaAggregateFn) {
            this.byFields = byFields;
            this.schemaAggregateFn = schemaAggregateFn;
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsByFields<InputT>(this.byFields, this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsByFields<InputT>(this.byFields, this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsByFields<InputT>(this.byFields, this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsByFields<InputT>(this.byFields, this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsByFields<InputT>(this.byFields, this.schemaAggregateFn.aggregateFields(fieldsToAggregate, fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsByFields<InputT>(this.byFields, this.schemaAggregateFn.aggregateFields(fieldsToAggregate, fn, outputField));
        }

        @Override
        public PCollection<KV<Row, Row>> expand(PCollection<InputT> input) {
            SchemaAggregateFn.Inner<InputT> fn = this.schemaAggregateFn.withSchema(input.getSchema(), input.getToRowFunction());
            return (PCollection)((PCollection)input.apply(this.byFields)).apply(Combine.groupedValues(fn));
        }
    }

    public static class CombineByFields<InputT, OutputT>
    extends PTransform<PCollection<InputT>, PCollection<KV<Row, OutputT>>> {
        private final ByFields<InputT> byFields;
        private final Combine.CombineFn<InputT, ?, OutputT> combineFn;

        CombineByFields(ByFields<InputT> byFields, Combine.CombineFn<InputT, ?, OutputT> combineFn) {
            this.byFields = byFields;
            this.combineFn = combineFn;
        }

        @Override
        public PCollection<KV<Row, OutputT>> expand(PCollection<InputT> input) {
            return (PCollection)((PCollection)input.apply(this.byFields)).apply(Combine.groupedValues(this.combineFn));
        }
    }

    public static class ByFields<InputT>
    extends PTransform<PCollection<InputT>, PCollection<KV<Row, Iterable<InputT>>>> {
        private final FieldAccessDescriptor fieldAccessDescriptor;
        @Nullable
        private Schema keySchema = null;

        private ByFields(FieldAccessDescriptor fieldAccessDescriptor) {
            this.fieldAccessDescriptor = fieldAccessDescriptor;
        }

        Schema getKeySchema() {
            return this.keySchema;
        }

        public <OutputT> CombineByFields<InputT, OutputT> aggregate(Combine.CombineFn<InputT, ?, OutputT> combineFn) {
            return new CombineByFields<InputT, OutputT>(this, combineFn);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsByFields(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsByFields(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsByFields(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsByFields(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsByFields(this, SchemaAggregateFn.create().aggregateFields(fieldsToAggregate, fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsByFields(this, SchemaAggregateFn.create().aggregateFields(fieldsToAggregate, fn, outputField));
        }

        @Override
        public PCollection<KV<Row, Iterable<InputT>>> expand(PCollection<InputT> input) {
            final Schema schema = input.getSchema();
            final FieldAccessDescriptor resolved = this.fieldAccessDescriptor.resolve(schema);
            this.keySchema = SelectHelpers.getOutputSchema(schema, resolved);
            return (PCollection)((PCollection)input.apply("Group by fields", ParDo.of(new DoFn<InputT, KV<Row, InputT>>(){

                @DoFn.ProcessElement
                public void process(@DoFn.Element InputT element, @DoFn.Element Row row, DoFn.OutputReceiver<KV<Row, InputT>> o) {
                    o.output(KV.of(SelectHelpers.selectRow(row, resolved, schema, keySchema), element));
                }
            }))).setCoder(KvCoder.of(SchemaCoder.of(this.keySchema), input.getCoder())).apply(GroupByKey.create());
        }
    }

    public static class CombineFieldsGlobally<InputT>
    extends PTransform<PCollection<InputT>, PCollection<Row>> {
        private final SchemaAggregateFn.Inner<InputT> schemaAggregateFn;

        CombineFieldsGlobally(SchemaAggregateFn.Inner<InputT> schemaAggregateFn) {
            this.schemaAggregateFn = schemaAggregateFn;
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(FieldAccessDescriptor fieldAccessDescriptor, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(fieldAccessDescriptor, fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(FieldAccessDescriptor fieldAccessDescriptor, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(fieldAccessDescriptor, fn, outputField));
        }

        @Override
        public PCollection<Row> expand(PCollection<InputT> input) {
            SchemaAggregateFn.Inner<InputT> fn = this.schemaAggregateFn.withSchema(input.getSchema(), input.getToRowFunction());
            return ((PCollection)input.apply(Combine.globally(fn))).setRowSchema(fn.getOutputSchema());
        }
    }

    public static class CombineGlobally<InputT, OutputT>
    extends PTransform<PCollection<InputT>, PCollection<OutputT>> {
        final Combine.CombineFn<InputT, ?, OutputT> combineFn;

        CombineGlobally(Combine.CombineFn<InputT, ?, OutputT> combineFn) {
            this.combineFn = combineFn;
        }

        @Override
        public PCollection<OutputT> expand(PCollection<InputT> input) {
            return (PCollection)input.apply(Combine.globally(this.combineFn));
        }
    }

    public static class Global<InputT>
    extends PTransform<PCollection<InputT>, PCollection<Iterable<InputT>>> {
        public <OutputT> CombineGlobally<InputT, OutputT> aggregate(Combine.CombineFn<InputT, ?, OutputT> combineFn) {
            return new CombineGlobally<InputT, OutputT>(combineFn);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(int inputFielId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFielId), fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(fieldsToAggregate, fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(fieldsToAggregate, fn, outputField));
        }

        @Override
        public PCollection<Iterable<InputT>> expand(PCollection<InputT> input) {
            return (PCollection)((PCollection)((PCollection)input.apply(WithKeys.of((Void)null))).apply(GroupByKey.create())).apply(Values.create());
        }
    }
}

