/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.FieldTypeDescriptors;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.transforms.AutoValue_SchemaAggregateFn_Inner;
import org.apache.beam.sdk.schemas.transforms.Unnest;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFns;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;

@Experimental(value=Experimental.Kind.SCHEMAS)
class SchemaAggregateFn {
    SchemaAggregateFn() {
    }

    static <T> Inner<T> create() {
        return new AutoValue_SchemaAggregateFn_Inner.Builder().setFieldAggregations(Lists.newArrayList()).build();
    }

    @AutoValue
    static abstract class Inner<T>
    extends Combine.CombineFn<T, Object[], Row> {
        Inner() {
        }

        abstract Builder<T> toBuilder();

        @Nullable
        abstract Schema getInputSchema();

        @Nullable
        abstract Schema getOutputSchema();

        @Nullable
        abstract CombineFns.ComposedCombineFn<T> getComposedCombineFn();

        abstract List<FieldAggregation> getFieldAggregations();

        Inner<T> withSchema(Schema inputSchema, SerializableFunction<T, Row> toRowFunction) {
            List<FieldAggregation> fieldAggregations = this.getFieldAggregations().stream().map(f -> f.resolve(inputSchema)).collect(Collectors.toList());
            CombineFns.ComposedCombineFn<Object> composedCombineFn = null;
            for (int i = 0; i < fieldAggregations.size(); ++i) {
                Coder extractOutputCoder;
                SimpleFunction extractFunction;
                FieldAggregation fieldAggregation = (FieldAggregation)fieldAggregations.get(i);
                if (fieldAggregation.unnestedInputSubSchema.getFieldCount() == 1) {
                    extractFunction = new ExtractSingleFieldFunction(fieldAggregation, toRowFunction);
                    extractOutputCoder = RowCoder.coderForFieldType(fieldAggregation.unnestedInputSubSchema.getField(0).getType());
                } else {
                    extractFunction = new ExtractFieldsFunction(fieldAggregation, toRowFunction);
                    extractOutputCoder = RowCoder.of(fieldAggregation.inputSubSchema);
                }
                composedCombineFn = i == 0 ? CombineFns.compose().with(extractFunction, extractOutputCoder, fieldAggregation.fn, fieldAggregation.combineTag) : composedCombineFn.with(extractFunction, extractOutputCoder, fieldAggregation.fn, fieldAggregation.combineTag);
            }
            return this.toBuilder().setInputSchema(inputSchema).setComposedCombineFn(composedCombineFn).setFieldAggregations(fieldAggregations).build();
        }

        <CombineInputT, AccumT, CombineOutputT> Inner<T> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(fieldsToAggregate, fn, Schema.Field.of(outputFieldName, FieldTypeDescriptors.fieldTypeForJavaType(fn.getOutputType())));
        }

        <CombineInputT, AccumT, CombineOutputT> Inner<T> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            List<FieldAggregation> fieldAggregations = this.getFieldAggregations();
            TupleTag<Object> combineTag = new TupleTag<Object>(Integer.toString(fieldAggregations.size()));
            FieldAggregation<CombineInputT, AccumT, CombineOutputT> fieldAggregation = new FieldAggregation<CombineInputT, AccumT, CombineOutputT>(fieldsToAggregate, outputField, fn, combineTag);
            fieldAggregations.add(fieldAggregation);
            return this.toBuilder().setOutputSchema(this.getOutputSchema(fieldAggregations)).setFieldAggregations(fieldAggregations).build();
        }

        private Schema getOutputSchema(List<FieldAggregation> fieldAggregations) {
            Schema.Builder outputSchema = Schema.builder();
            for (FieldAggregation aggregation : fieldAggregations) {
                outputSchema.addField(aggregation.outputField);
            }
            return outputSchema.build();
        }

        @Override
        public Object[] createAccumulator() {
            return this.getComposedCombineFn().createAccumulator();
        }

        @Override
        public Object[] addInput(Object[] accumulator, T input) {
            return this.getComposedCombineFn().addInput(accumulator, input);
        }

        @Override
        public Object[] mergeAccumulators(Iterable<Object[]> accumulator) {
            return this.getComposedCombineFn().mergeAccumulators(accumulator);
        }

        @Override
        public Coder<Object[]> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) throws CannotProvideCoderException {
            return this.getComposedCombineFn().getAccumulatorCoder(registry, inputCoder);
        }

        @Override
        public Coder<Row> getDefaultOutputCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return SchemaCoder.of(this.getOutputSchema(), SerializableFunctions.identity(), SerializableFunctions.identity());
        }

        @Override
        public Row extractOutput(Object[] accumulator) {
            CombineFns.CoCombineResult coCombineResult = this.getComposedCombineFn().extractOutput(accumulator);
            Row.Builder output = Row.withSchema(this.getOutputSchema());
            for (FieldAggregation fieldAggregation : this.getFieldAggregations()) {
                Object aggregate = coCombineResult.get(fieldAggregation.combineTag);
                output.addValue(aggregate);
            }
            return output.build();
        }

        private static class ExtractFieldsFunction<T>
        extends SimpleFunction<T, Row> {
            private FieldAggregation fieldAggregation;
            private SerializableFunction<T, Row> toRowFunction;

            private ExtractFieldsFunction(FieldAggregation fieldAggregation, SerializableFunction<T, Row> toRowFunction) {
                this.fieldAggregation = fieldAggregation;
                this.toRowFunction = toRowFunction;
            }

            @Override
            public Row apply(T input) {
                Row row = this.toRowFunction.apply(input);
                return SelectHelpers.selectRow(row, this.fieldAggregation.fieldsToAggregate, row.getSchema(), this.fieldAggregation.inputSubSchema);
            }
        }

        private static class ExtractSingleFieldFunction<InputT, OutputT>
        extends SimpleFunction<InputT, OutputT> {
            private final FieldAggregation fieldAggregation;
            private final SerializableFunction<InputT, Row> toRowFunction;

            private ExtractSingleFieldFunction(FieldAggregation fieldAggregation, SerializableFunction<InputT, Row> toRowFunction) {
                this.fieldAggregation = fieldAggregation;
                this.toRowFunction = toRowFunction;
            }

            @Override
            public OutputT apply(InputT input) {
                Row row = this.toRowFunction.apply(input);
                Row selected = SelectHelpers.selectRow(row, this.fieldAggregation.fieldsToAggregate, row.getSchema(), this.fieldAggregation.inputSubSchema);
                if (this.fieldAggregation.needsUnnesting) {
                    selected = Unnest.unnestRow(selected, this.fieldAggregation.unnestedInputSubSchema);
                }
                return (OutputT)selected.getValue(0);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setInputSchema(@Nullable Schema var1);

            abstract Builder<T> setOutputSchema(@Nullable Schema var1);

            abstract Builder<T> setComposedCombineFn(@Nullable CombineFns.ComposedCombineFn<T> var1);

            abstract Builder<T> setFieldAggregations(List<FieldAggregation> var1);

            abstract Inner<T> build();
        }

        static class FieldAggregation<FieldT, AccumT, OutputT>
        implements Serializable {
            FieldAccessDescriptor fieldsToAggregate;
            private final Schema.Field outputField;
            private final Combine.CombineFn<FieldT, AccumT, OutputT> fn;
            private final TupleTag<Object> combineTag;
            @Nullable
            private final Schema inputSubSchema;
            @Nullable
            private final Schema unnestedInputSubSchema;
            private final Schema aggregationSchema;
            private final boolean needsUnnesting;

            FieldAggregation(FieldAccessDescriptor fieldsToAggregate, Schema.Field outputField, Combine.CombineFn<FieldT, AccumT, OutputT> fn, TupleTag<Object> combineTag) {
                this(fieldsToAggregate, outputField, fn, combineTag, Schema.builder().addField(outputField).build(), null);
            }

            FieldAggregation(FieldAccessDescriptor fieldsToAggregate, Schema.Field outputField, Combine.CombineFn<FieldT, AccumT, OutputT> fn, TupleTag<Object> combineTag, Schema aggregationSchema, @Nullable Schema inputSchema) {
                if (inputSchema != null) {
                    this.fieldsToAggregate = fieldsToAggregate.resolve(inputSchema);
                    this.inputSubSchema = SelectHelpers.getOutputSchema(inputSchema, this.fieldsToAggregate);
                    this.unnestedInputSubSchema = Unnest.getUnnestedSchema(this.inputSubSchema);
                    this.needsUnnesting = !inputSchema.equals(this.unnestedInputSubSchema);
                } else {
                    this.fieldsToAggregate = fieldsToAggregate;
                    this.inputSubSchema = null;
                    this.unnestedInputSubSchema = null;
                    this.needsUnnesting = false;
                }
                this.outputField = outputField;
                this.fn = fn;
                this.combineTag = combineTag;
                this.aggregationSchema = aggregationSchema;
            }

            FieldAggregation<FieldT, AccumT, OutputT> resolve(Schema schema) {
                return new FieldAggregation<FieldT, AccumT, OutputT>(this.fieldsToAggregate, this.outputField, this.fn, this.combineTag, this.aggregationSchema, schema);
            }
        }
    }
}

