/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class Select<T>
extends PTransform<PCollection<T>, PCollection<Row>> {
    private final FieldAccessDescriptor fieldAccessDescriptor;

    private Select(FieldAccessDescriptor fieldAccessDescriptor) {
        this.fieldAccessDescriptor = fieldAccessDescriptor;
    }

    public static <T> Select<T> fieldIds(Integer ... ids) {
        return new Select<T>(FieldAccessDescriptor.withFieldIds(ids));
    }

    public static <T> Select<T> fieldNames(String ... names) {
        return new Select<T>(FieldAccessDescriptor.withFieldNames(names));
    }

    public static <T> Select<T> fieldAccess(FieldAccessDescriptor fieldAccessDescriptor) {
        return new Select<T>(fieldAccessDescriptor);
    }

    @Override
    public PCollection<Row> expand(PCollection<T> input) {
        final Schema inputSchema = input.getSchema();
        final FieldAccessDescriptor resolved = this.fieldAccessDescriptor.resolve(inputSchema);
        final Schema outputSchema = SelectHelpers.getOutputSchema(inputSchema, resolved);
        return ((PCollection)input.apply(ParDo.of(new DoFn<T, Row>(){
            @DoFn.FieldAccess(value="selectFields")
            final FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptor.withAllFields();

            @DoFn.ProcessElement
            public void process(@DoFn.FieldAccess(value="selectFields") @DoFn.Element Row row, DoFn.OutputReceiver<Row> r) {
                r.output(SelectHelpers.selectRow(row, resolved, inputSchema, outputSchema));
            }
        }))).setRowSchema(outputSchema);
    }
}

