/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.AutoValue_Unnest_Inner;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class Unnest {
    public static final SerializableFunction<List<String>, String> CONCAT_FIELD_NAMES = l -> String.join((CharSequence)"_", l);
    public static final SerializableFunction<List<String>, String> KEEP_NESTED_NAME = l -> (String)l.get(l.size() - 1);

    public static <T> Inner<T> create() {
        return new AutoValue_Unnest_Inner.Builder().setFieldNameFunction(CONCAT_FIELD_NAMES).build();
    }

    static Schema getUnnestedSchema(Schema schema) {
        ArrayList<String> nameComponents = Lists.newArrayList();
        return Unnest.getUnnestedSchema(schema, nameComponents, CONCAT_FIELD_NAMES);
    }

    static Schema getUnnestedSchema(Schema schema, SerializableFunction<List<String>, String> fn) {
        ArrayList<String> nameComponents = Lists.newArrayList();
        return Unnest.getUnnestedSchema(schema, nameComponents, fn);
    }

    private static Schema getUnnestedSchema(Schema schema, List<String> nameComponents, SerializableFunction<List<String>, String> fn) {
        Schema.Builder builder = Schema.builder();
        for (Schema.Field field : schema.getFields()) {
            nameComponents.add(field.getName());
            if (field.getType().getTypeName().isCompositeType()) {
                Schema nestedSchema = Unnest.getUnnestedSchema(field.getType().getRowSchema(), nameComponents, fn);
                for (Schema.Field nestedField : nestedSchema.getFields()) {
                    builder.addField(nestedField);
                }
            } else {
                String name = fn.apply(nameComponents);
                Schema.Field newField = field.toBuilder().setName(name).build();
                builder.addField(newField);
            }
            nameComponents.remove(nameComponents.size() - 1);
        }
        return builder.build();
    }

    static Row unnestRow(Row input, Schema unnestedSchema) {
        Row.Builder builder = Row.withSchema(unnestedSchema);
        Unnest.unnestRow(input, builder);
        return builder.build();
    }

    private static void unnestRow(Row input, Row.Builder output) {
        for (int i = 0; i < input.getSchema().getFieldCount(); ++i) {
            Schema.Field field = input.getSchema().getField(i);
            if (field.getType().getTypeName().isCompositeType()) {
                Unnest.unnestRow(input.getRow(i), output);
                continue;
            }
            output.addValue(input.getValue(i));
        }
    }

    @AutoValue
    public static abstract class Inner<T>
    extends PTransform<PCollection<T>, PCollection<Row>> {
        abstract Builder<T> toBuilder();

        abstract SerializableFunction<List<String>, String> getFieldNameFunction();

        public Inner<T> withFieldNameFunction(SerializableFunction<List<String>, String> fn) {
            return this.toBuilder().setFieldNameFunction(fn).build();
        }

        @Override
        public PCollection<Row> expand(PCollection<T> input) {
            Schema inputSchema = input.getSchema();
            final Schema outputSchema = Unnest.getUnnestedSchema(inputSchema, this.getFieldNameFunction());
            return ((PCollection)input.apply(ParDo.of(new DoFn<T, Row>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element Row row, DoFn.OutputReceiver<Row> o) {
                    o.output(Unnest.unnestRow(row, outputSchema));
                }
            }))).setRowSchema(outputSchema);
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setFieldNameFunction(SerializableFunction<List<String>, String> var1);

            abstract Inner<T> build();
        }
    }
}

