/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.avro.specific.SpecificRecord;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.ByteBuddy;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.MethodCall;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;

class AvroByteBuddyUtils {
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy();
    private static final Map<ReflectUtils.ClassWithSchema, SchemaUserTypeCreator> CACHED_CREATORS = Maps.newConcurrentMap();

    AvroByteBuddyUtils() {
    }

    static <T extends SpecificRecord> SchemaUserTypeCreator getCreator(Class<T> clazz, Schema schema) {
        return CACHED_CREATORS.computeIfAbsent(new ReflectUtils.ClassWithSchema(clazz, schema), c -> AvroByteBuddyUtils.createCreator(clazz, schema));
    }

    private static <T> SchemaUserTypeCreator createCreator(Class<T> clazz, Schema schema) {
        Constructor<?>[] constructors;
        Constructor<?> baseConstructor = null;
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != schema.getFieldCount()) continue;
            baseConstructor = constructor;
        }
        if (baseConstructor == null) {
            throw new RuntimeException("No matching constructor found for class " + clazz);
        }
        MethodCall construct = MethodCall.construct(baseConstructor);
        for (int i = 0; i < baseConstructor.getParameterTypes().length; ++i) {
            Class<?> baseType = baseConstructor.getParameterTypes()[i];
            construct = construct.with(AvroByteBuddyUtils.readAndConvertParameter(baseType, i), baseType);
        }
        try {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition<SchemaUserTypeCreator> builder = BYTE_BUDDY.with(new ByteBuddyUtils.InjectPackageStrategy(clazz)).subclass(SchemaUserTypeCreator.class).method(ElementMatchers.named("create")).intercept(construct);
            return (SchemaUserTypeCreator)builder.make().load(ReflectHelpers.findClassLoader(clazz.getClassLoader()), ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a getter for class " + clazz + " with schema " + schema);
        }
    }

    private static StackManipulation readAndConvertParameter(Class<?> constructorParameterType, int index) {
        ByteBuddyUtils.ConvertType convertType = new ByteBuddyUtils.ConvertType(true);
        TypeDescription.ForLoadedType convertedType = new TypeDescription.ForLoadedType((Class)convertType.convert(TypeDescriptor.of(constructorParameterType)));
        StackManipulation.Compound readParameter = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(1), IntegerConstant.forValue(index), ArrayAccess.REFERENCE.load(), TypeCasting.to(convertedType));
        return (StackManipulation)new ByteBuddyUtils.ConvertValueForSetter(readParameter).convert(TypeDescriptor.of(constructorParameterType));
    }
}

