/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;

public class SelectHelpers {
    public static Schema getOutputSchema(Schema inputSchema, FieldAccessDescriptor fieldAccessDescriptor) {
        if (fieldAccessDescriptor.getAllFields()) {
            return inputSchema;
        }
        Schema.Builder builder = new Schema.Builder();
        Iterator<Object> iterator = fieldAccessDescriptor.fieldIdsAccessed().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            builder.addField(inputSchema.getField(n));
        }
        for (Map.Entry entry : fieldAccessDescriptor.getNestedFieldsAccessed().entrySet()) {
            FieldAccessDescriptor.FieldDescriptor fieldDescriptor = (FieldAccessDescriptor.FieldDescriptor)entry.getKey();
            Schema.Field field = inputSchema.getField(Preconditions.checkNotNull(fieldDescriptor.getFieldId()));
            Schema.FieldType outputType = SelectHelpers.getOutputSchemaHelper(field.getType(), (FieldAccessDescriptor)entry.getValue(), fieldDescriptor.getQualifiers(), 0);
            builder.addField(field.getName(), outputType);
        }
        return builder.build();
    }

    private static Schema.FieldType getOutputSchemaHelper(Schema.FieldType inputFieldType, FieldAccessDescriptor fieldAccessDescriptor, List<FieldAccessDescriptor.FieldDescriptor.Qualifier> qualifiers, int qualifierPosition) {
        if (qualifierPosition >= qualifiers.size()) {
            Preconditions.checkArgument(inputFieldType.getTypeName().isCompositeType());
            return Schema.FieldType.row(SelectHelpers.getOutputSchema(inputFieldType.getRowSchema(), fieldAccessDescriptor)).withNullable(inputFieldType.getNullable());
        }
        FieldAccessDescriptor.FieldDescriptor.Qualifier qualifier = qualifiers.get(qualifierPosition);
        switch (qualifier.getKind()) {
            case LIST: {
                Preconditions.checkArgument(qualifier.getList().equals((Object)FieldAccessDescriptor.FieldDescriptor.ListQualifier.ALL));
                Schema.FieldType componentType = Preconditions.checkNotNull(inputFieldType.getCollectionElementType());
                Schema.FieldType outputComponent = SelectHelpers.getOutputSchemaHelper(componentType, fieldAccessDescriptor, qualifiers, qualifierPosition + 1).withNullable(componentType.getNullable());
                return Schema.FieldType.array(outputComponent).withNullable(inputFieldType.getNullable());
            }
            case MAP: {
                Preconditions.checkArgument(qualifier.getMap().equals((Object)FieldAccessDescriptor.FieldDescriptor.MapQualifier.ALL));
                Schema.FieldType keyType = Preconditions.checkNotNull(inputFieldType.getMapKeyType());
                Schema.FieldType valueType = Preconditions.checkNotNull(inputFieldType.getMapValueType());
                Schema.FieldType outputValueType = SelectHelpers.getOutputSchemaHelper(valueType, fieldAccessDescriptor, qualifiers, qualifierPosition + 1).withNullable(valueType.getNullable());
                return Schema.FieldType.map(keyType, outputValueType).withNullable(inputFieldType.getNullable());
            }
        }
        throw new RuntimeException("unexpected");
    }

    public static Row selectRow(Row input, FieldAccessDescriptor fieldAccessDescriptor, Schema inputSchema, Schema outputSchema) {
        if (fieldAccessDescriptor.getAllFields()) {
            return input;
        }
        Row.Builder output = Row.withSchema(outputSchema);
        Iterator<Object> iterator = fieldAccessDescriptor.fieldIdsAccessed().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            output.addValue(input.getValue(n));
        }
        for (Map.Entry entry : fieldAccessDescriptor.getNestedFieldsAccessed().entrySet()) {
            FieldAccessDescriptor.FieldDescriptor field = (FieldAccessDescriptor.FieldDescriptor)entry.getKey();
            String fieldName = inputSchema.nameOf(Preconditions.checkNotNull(field.getFieldId()));
            Schema.FieldType nestedInputType = inputSchema.getField(field.getFieldId()).getType();
            Schema.FieldType nestedOutputType = outputSchema.getField(fieldName).getType();
            Object value = SelectHelpers.selectRowHelper(field.getQualifiers(), 0, input.getValue(fieldName), (FieldAccessDescriptor)entry.getValue(), nestedInputType, nestedOutputType);
            output.addValue(value);
        }
        return output.build();
    }

    private static Object selectRowHelper(List<FieldAccessDescriptor.FieldDescriptor.Qualifier> qualifiers, int qualifierPosition, Object value, FieldAccessDescriptor fieldAccessDescriptor, Schema.FieldType inputType, Schema.FieldType outputType) {
        if (qualifierPosition >= qualifiers.size()) {
            Row row = (Row)value;
            return SelectHelpers.selectRow(row, fieldAccessDescriptor, inputType.getRowSchema(), outputType.getRowSchema());
        }
        if (fieldAccessDescriptor.getAllFields()) {
            return value;
        }
        FieldAccessDescriptor.FieldDescriptor.Qualifier qualifier = qualifiers.get(qualifierPosition);
        switch (qualifier.getKind()) {
            case LIST: {
                Schema.FieldType nestedInputType = Preconditions.checkNotNull(inputType.getCollectionElementType());
                Schema.FieldType nestedOutputType = Preconditions.checkNotNull(outputType.getCollectionElementType());
                List list = (List)value;
                ArrayList<Object> selectedList = Lists.newArrayListWithCapacity(list.size());
                for (Object o : list) {
                    Object selected = SelectHelpers.selectRowHelper(qualifiers, qualifierPosition + 1, o, fieldAccessDescriptor, nestedInputType, nestedOutputType);
                    selectedList.add(selected);
                }
                return selectedList;
            }
            case MAP: {
                Schema.FieldType nestedInputType = Preconditions.checkNotNull(inputType.getMapValueType());
                Schema.FieldType nestedOutputType = Preconditions.checkNotNull(outputType.getMapValueType());
                Map map = (Map)value;
                HashMap selectedMap = Maps.newHashMapWithExpectedSize(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    Object selected = SelectHelpers.selectRowHelper(qualifiers, qualifierPosition + 1, entry.getValue(), fieldAccessDescriptor, nestedInputType, nestedOutputType);
                    selectedMap.put(entry.getKey(), selected);
                }
                return selectedMap;
            }
        }
        throw new RuntimeException("Unexpected type " + (Object)((Object)qualifier.getKind()));
    }
}

