/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.NumberedShardedFile;
import org.apache.beam.sdk.util.ShardedFile;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v20_0.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v20_0.com.google.common.hash.Hashing;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChecksumMatcher
extends TypeSafeMatcher<PipelineResult>
implements SerializableMatcher<PipelineResult> {
    private static final Logger LOG = LoggerFactory.getLogger(FileChecksumMatcher.class);
    static final int MAX_READ_RETRIES = 4;
    static final Duration DEFAULT_SLEEP_DURATION = Duration.standardSeconds(10L);
    static final FluentBackoff BACK_OFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(DEFAULT_SLEEP_DURATION).withMaxRetries(4);
    private static final Pattern DEFAULT_SHARD_TEMPLATE = Pattern.compile("(?x) \\S* (?<shardnum> \\d+) -of- (?<numshards> \\d+)");
    private final String expectedChecksum;
    private final ShardedFile shardedFile;
    @Nullable
    private String actualChecksum;

    public FileChecksumMatcher(String checksum, String filePath) {
        this(checksum, filePath, DEFAULT_SHARD_TEMPLATE);
    }

    public FileChecksumMatcher(String checksum, String filePath, Pattern shardTemplate) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(checksum), "Expected valid checksum, but received %s", (Object)checksum);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(filePath), "Expected valid file path, but received %s", (Object)filePath);
        Preconditions.checkNotNull(shardTemplate, "Expected non-null shard pattern. Please call the other constructor to use default pattern: %s", (Object)DEFAULT_SHARD_TEMPLATE);
        this.expectedChecksum = checksum;
        this.shardedFile = new NumberedShardedFile(filePath, shardTemplate);
    }

    public FileChecksumMatcher(String expectedChecksum, ShardedFile shardedFile) {
        this.expectedChecksum = expectedChecksum;
        this.shardedFile = shardedFile;
    }

    public boolean matchesSafely(PipelineResult pipelineResult) {
        return this.getActualChecksum().equals(this.expectedChecksum);
    }

    private String getActualChecksum() {
        if (this.actualChecksum == null) {
            List<String> outputs;
            try {
                outputs = this.shardedFile.readFilesWithRetries(Sleeper.DEFAULT, BACK_OFF_FACTORY.backoff());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to read from: %s", this.shardedFile), e);
            }
            this.actualChecksum = FileChecksumMatcher.computeHash(outputs);
            LOG.debug("Generated checksum: {}", (Object)this.actualChecksum);
        }
        return this.actualChecksum;
    }

    private static String computeHash(@Nonnull List<String> strs) {
        if (strs.isEmpty()) {
            return Hashing.sha1().hashString("", StandardCharsets.UTF_8).toString();
        }
        ArrayList<HashCode> hashCodes = new ArrayList<HashCode>();
        for (String str : strs) {
            hashCodes.add(Hashing.sha1().hashString(str, StandardCharsets.UTF_8));
        }
        return Hashing.combineUnordered(hashCodes).toString();
    }

    public void describeTo(Description description) {
        description.appendText("Expected checksum is (").appendText(this.expectedChecksum).appendText(")");
    }

    public void describeMismatchSafely(PipelineResult pResult, Description description) {
        description.appendText("was (").appendText(this.getActualChecksum()).appendText(")");
    }
}

