/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.util.ArrayList;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.ValueInSingleWindow;

final class PaneExtractors {
    private PaneExtractors() {
    }

    static <T> SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> onlyPane(PAssert.PAssertionSite site) {
        return new ExtractOnlyPane(site);
    }

    static <T> SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> onTimePane() {
        return new ExtractOnTimePane();
    }

    static <T> SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> finalPane() {
        return new ExtractFinalPane();
    }

    static <T> SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> nonLatePanes() {
        return new ExtractNonLatePanes();
    }

    static <T> SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> earlyPanes() {
        return new ExtractEarlyPanes();
    }

    static <T> SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> allPanes() {
        return new ExtractAllPanes();
    }

    private static class ExtractEarlyPanes<T>
    extends SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> {
        private ExtractEarlyPanes() {
        }

        @Override
        public Iterable<T> apply(Iterable<ValueInSingleWindow<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (ValueInSingleWindow<T> value : input) {
                if (value.getPane().getTiming() != PaneInfo.Timing.EARLY) continue;
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractNonLatePanes<T>
    extends SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> {
        private ExtractNonLatePanes() {
        }

        @Override
        public Iterable<T> apply(Iterable<ValueInSingleWindow<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (ValueInSingleWindow<T> value : input) {
                if (value.getPane().getTiming() == PaneInfo.Timing.LATE) continue;
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractAllPanes<T>
    extends SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> {
        private ExtractAllPanes() {
        }

        @Override
        public Iterable<T> apply(Iterable<ValueInSingleWindow<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (ValueInSingleWindow<T> value : input) {
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractFinalPane<T>
    extends SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> {
        private ExtractFinalPane() {
        }

        @Override
        public Iterable<T> apply(Iterable<ValueInSingleWindow<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (ValueInSingleWindow<T> value : input) {
                if (!value.getPane().isLast()) continue;
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractOnTimePane<T>
    extends SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> {
        private ExtractOnTimePane() {
        }

        @Override
        public Iterable<T> apply(Iterable<ValueInSingleWindow<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (ValueInSingleWindow<T> value : input) {
                if (!value.getPane().getTiming().equals((Object)PaneInfo.Timing.ON_TIME)) continue;
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractOnlyPane<T>
    extends SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> {
        private final PAssert.PAssertionSite site;

        private ExtractOnlyPane(PAssert.PAssertionSite site) {
            this.site = site;
        }

        @Override
        public Iterable<T> apply(Iterable<ValueInSingleWindow<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (ValueInSingleWindow<T> value : input) {
                if (!value.getPane().isFirst() || !value.getPane().isLast()) {
                    throw this.site.wrap(String.format("Expected elements to be produced by a trigger that fires at most once, but got a value %s in a pane that is %s.", value, value.getPane().isFirst() ? "not the last pane" : "not the first pane"));
                }
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }
}

