/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.testing.AutoValue_TestStream_ElementEvent;
import org.apache.beam.sdk.testing.AutoValue_TestStream_ProcessingTimeEvent;
import org.apache.beam.sdk.testing.AutoValue_TestStream_WatermarkEvent;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableCollection;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.joda.time.Duration;
import org.joda.time.Instant;

public final class TestStream<T>
extends PTransform<PBegin, PCollection<T>> {
    private final List<Event<T>> events;
    private final Coder<T> coder;

    public static <T> Builder<T> create(Coder<T> coder) {
        return new Builder(coder);
    }

    public static <T> Builder<T> create(Schema schema, SerializableFunction<T, Row> toRowFunction, SerializableFunction<Row, T> fromRowFunction) {
        return TestStream.create(SchemaCoder.of(schema, toRowFunction, fromRowFunction));
    }

    private TestStream(Coder<T> coder, List<Event<T>> events) {
        this.coder = coder;
        this.events = Preconditions.checkNotNull(events);
    }

    @Override
    public PCollection<T> expand(PBegin input) {
        return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.UNBOUNDED, this.coder);
    }

    public Coder<T> getValueCoder() {
        return this.coder;
    }

    public List<Event<T>> getEvents() {
        return this.events;
    }

    @Internal
    public static <T> TestStream<T> fromRawEvents(Coder<T> coder, List<Event<T>> events) {
        return new TestStream<T>(coder, events);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TestStream)) {
            return false;
        }
        TestStream that = (TestStream)other;
        return this.getValueCoder().equals(that.getValueCoder()) && this.getEvents().equals(that.getEvents());
    }

    public int hashCode() {
        return Objects.hash(TestStream.class, this.getValueCoder(), this.getEvents());
    }

    @AutoValue
    public static abstract class ProcessingTimeEvent<T>
    implements Event<T> {
        public abstract Duration getProcessingTimeAdvance();

        @Internal
        public static <T> Event<T> advanceBy(Duration amount) {
            return new AutoValue_TestStream_ProcessingTimeEvent(EventType.PROCESSING_TIME, amount);
        }
    }

    @AutoValue
    public static abstract class WatermarkEvent<T>
    implements Event<T> {
        public abstract Instant getWatermark();

        @Internal
        public static <T> Event<T> advanceTo(Instant newWatermark) {
            return new AutoValue_TestStream_WatermarkEvent(EventType.WATERMARK, newWatermark);
        }
    }

    @AutoValue
    public static abstract class ElementEvent<T>
    implements Event<T> {
        public abstract Iterable<TimestampedValue<T>> getElements();

        @SafeVarargs
        static <T> Event<T> add(TimestampedValue<T> element, TimestampedValue<T> ... elements) {
            return ElementEvent.add(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(element)).add(elements)).build());
        }

        @Internal
        public static <T> Event<T> add(Iterable<TimestampedValue<T>> elements) {
            return new AutoValue_TestStream_ElementEvent<T>(EventType.ELEMENT, elements);
        }
    }

    public static enum EventType {
        ELEMENT,
        WATERMARK,
        PROCESSING_TIME;

    }

    public static interface Event<T> {
        public EventType getType();
    }

    public static class Builder<T> {
        private final Coder<T> coder;
        private final ImmutableList<Event<T>> events;
        private final Instant currentWatermark;

        private Builder(Coder<T> coder) {
            this(coder, ImmutableList.of(), BoundedWindow.TIMESTAMP_MIN_VALUE);
        }

        private Builder(Coder<T> coder, ImmutableList<Event<T>> events, Instant currentWatermark) {
            this.coder = coder;
            this.events = events;
            this.currentWatermark = currentWatermark;
        }

        @SafeVarargs
        public final Builder<T> addElements(T element, T ... elements) {
            TimestampedValue<T> firstElement = TimestampedValue.of(element, this.currentWatermark);
            TimestampedValue[] remainingElements = new TimestampedValue[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                remainingElements[i] = TimestampedValue.of(elements[i], this.currentWatermark);
            }
            return this.addElements(firstElement, remainingElements);
        }

        @SafeVarargs
        public final Builder<T> addElements(TimestampedValue<T> element, TimestampedValue<T> ... elements) {
            Preconditions.checkArgument(element.getTimestamp().isBefore(BoundedWindow.TIMESTAMP_MAX_VALUE), "Elements must have timestamps before %s. Got: %s", (Object)BoundedWindow.TIMESTAMP_MAX_VALUE, (Object)element.getTimestamp());
            for (TimestampedValue<T> multiElement : elements) {
                Preconditions.checkArgument(multiElement.getTimestamp().isBefore(BoundedWindow.TIMESTAMP_MAX_VALUE), "Elements must have timestamps before %s. Got: %s", (Object)BoundedWindow.TIMESTAMP_MAX_VALUE, (Object)multiElement.getTimestamp());
            }
            ImmutableCollection newEvents = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.events)).add(ElementEvent.add(element, elements))).build();
            return new Builder<T>(this.coder, newEvents, this.currentWatermark);
        }

        public Builder<T> advanceWatermarkTo(Instant newWatermark) {
            Preconditions.checkArgument(!newWatermark.isBefore(this.currentWatermark), "The watermark must monotonically advance");
            Preconditions.checkArgument(newWatermark.isBefore(BoundedWindow.TIMESTAMP_MAX_VALUE), "The Watermark cannot progress beyond the maximum. Got: %s. Maximum: %s", (Object)newWatermark, (Object)BoundedWindow.TIMESTAMP_MAX_VALUE);
            ImmutableCollection newEvents = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.events)).add(WatermarkEvent.advanceTo(newWatermark))).build();
            return new Builder<T>(this.coder, newEvents, newWatermark);
        }

        public Builder<T> advanceProcessingTime(Duration amount) {
            Preconditions.checkArgument(amount.getMillis() > 0L, "Must advance the processing time by a positive amount. Got: ", (Object)amount);
            ImmutableCollection newEvents = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.events)).add(ProcessingTimeEvent.advanceBy(amount))).build();
            return new Builder<T>(this.coder, newEvents, this.currentWatermark);
        }

        public TestStream<T> advanceWatermarkToInfinity() {
            ImmutableCollection newEvents = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.events)).add(WatermarkEvent.advanceTo(BoundedWindow.TIMESTAMP_MAX_VALUE))).build();
            return new TestStream(this.coder, (List)((Object)newEvents));
        }
    }
}

