/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.CollectionCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.OffsetBasedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.joda.time.Instant;

public class Create<T> {
    public static <T> Values<T> of(Iterable<T> elems) {
        return new Values(elems, Optional.absent(), Optional.absent());
    }

    @SafeVarargs
    public static <T> Values<T> of(@Nullable T elem, T ... elems) {
        ArrayList<T> input = new ArrayList<T>(elems.length + 1);
        input.add(elem);
        input.addAll(Arrays.asList(elems));
        return Create.of(input);
    }

    public static Values<Row> empty(Schema schema) {
        return new Values<Row>(new ArrayList(), Optional.of(SchemaCoder.of(schema, SerializableFunctions.identity(), SerializableFunctions.identity())), Optional.absent());
    }

    public static <T> Values<T> empty(Coder<T> coder) {
        return new Values(new ArrayList(), Optional.of(coder), Optional.absent());
    }

    public static <T> Values<T> empty(TypeDescriptor<T> type) {
        return new Values(new ArrayList(), Optional.absent(), Optional.of(type));
    }

    public static <K, V> Values<KV<K, V>> of(Map<K, V> elems) {
        ArrayList<KV<K, V>> kvs = new ArrayList<KV<K, V>>(elems.size());
        for (Map.Entry<K, V> entry : elems.entrySet()) {
            kvs.add(KV.of(entry.getKey(), entry.getValue()));
        }
        return Create.of(kvs);
    }

    public static <T> OfValueProvider<T> ofProvider(ValueProvider<T> provider, Coder<T> coder) {
        return new OfValueProvider(provider, coder);
    }

    public static <T> TimestampedValues<T> timestamped(Iterable<TimestampedValue<T>> elems) {
        return new TimestampedValues(elems, Optional.absent(), Optional.absent());
    }

    @SafeVarargs
    public static <T> TimestampedValues<T> timestamped(TimestampedValue<T> elem, TimestampedValue<T> ... elems) {
        return Create.timestamped(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(elem)).add(elems)).build());
    }

    public static <T> TimestampedValues<T> timestamped(Iterable<T> values, Iterable<Long> timestamps) {
        ArrayList<TimestampedValue<T>> elems = new ArrayList<TimestampedValue<T>>();
        Iterator<T> valueIter = values.iterator();
        Iterator<Long> timestampIter = timestamps.iterator();
        while (valueIter.hasNext() && timestampIter.hasNext()) {
            elems.add(TimestampedValue.of(valueIter.next(), new Instant(timestampIter.next())));
        }
        Preconditions.checkArgument(!valueIter.hasNext() && !timestampIter.hasNext(), "Expect sizes of values and timestamps are same.");
        return Create.timestamped(elems);
    }

    private static <T> Coder<T> getDefaultCreateCoder(CoderRegistry coderRegistry, SchemaRegistry schemaRegistry, Iterable<T> elems) throws CannotProvideCoderException {
        Preconditions.checkArgument(!Iterables.isEmpty(elems), "Can not determine a default Coder for a 'Create' PTransform that has no elements.  Either add elements, call Create.empty(Coder), Create.empty(TypeDescriptor), or call 'withCoder(Coder)' or 'withType(TypeDescriptor)' on the PTransform.");
        Class elementClazz = Void.class;
        for (T elem : elems) {
            if (elem == null) continue;
            Class<?> clazz = elem.getClass();
            if (elementClazz.equals(Void.class)) {
                elementClazz = clazz;
                continue;
            }
            if (elementClazz.equals(clazz)) continue;
            throw new CannotProvideCoderException(String.format("Cannot provide coder for %s: The elements are not all of the same class.", Create.class.getSimpleName()));
        }
        TypeDescriptor<Void> typeDescriptor = TypeDescriptor.of(elementClazz);
        if (elementClazz.getTypeParameters().length == 0) {
            try {
                SchemaCoder<Void> coder = SchemaCoder.of(schemaRegistry.getSchema(typeDescriptor), schemaRegistry.getToRowFunction(typeDescriptor), schemaRegistry.getFromRowFunction(typeDescriptor));
                return coder;
            }
            catch (NoSuchSchemaException coder) {
                try {
                    Coder<Void> coder2 = coderRegistry.getCoder(typeDescriptor);
                    return coder2;
                }
                catch (CannotProvideCoderException cannotProvideCoderException) {
                    // empty catch block
                }
            }
        }
        return Create.inferCoderFromObjects(coderRegistry, schemaRegistry, elems);
    }

    private static Coder<?> inferCoderFromObjects(CoderRegistry coderRegistry, SchemaRegistry schemaRegistry, Iterable<?> elems) throws CannotProvideCoderException {
        Optional<Object> coder = Optional.absent();
        for (Object elem : elems) {
            Coder<?> c = Create.inferCoderFromObject(coderRegistry, schemaRegistry, elem);
            if (!coder.isPresent()) {
                coder = Optional.of(c);
                continue;
            }
            if (Objects.equals(c, coder.get())) continue;
            throw new CannotProvideCoderException("Cannot provide coder for elements of " + Create.class.getSimpleName() + ": For their common class, no coder could be provided. Based on their values, they do not all default to the same Coder.");
        }
        if (coder.isPresent()) {
            return (Coder)coder.get();
        }
        throw new CannotProvideCoderException("Cannot provide coder for elements of " + Create.class.getSimpleName() + ": For their common class, no coder could be provided. Based on their values, no coder could be inferred.");
    }

    private static Coder<?> inferCoderFromObject(CoderRegistry coderRegistry, SchemaRegistry schemaRegistry, Object o) throws CannotProvideCoderException {
        if (o == null) {
            return VoidCoder.of();
        }
        try {
            return SchemaCoder.of(schemaRegistry.getSchema(o.getClass()), schemaRegistry.getToRowFunction(o.getClass()), schemaRegistry.getFromRowFunction(o.getClass()));
        }
        catch (NoSuchSchemaException noSuchSchemaException) {
            if (o instanceof TimestampedValue) {
                return TimestampedValue.TimestampedValueCoder.of(Create.inferCoderFromObject(coderRegistry, schemaRegistry, ((TimestampedValue)o).getValue()));
            }
            if (o instanceof List) {
                return ListCoder.of(Create.inferCoderFromObjects(coderRegistry, schemaRegistry, (Iterable)o));
            }
            if (o instanceof Set) {
                return SetCoder.of(Create.inferCoderFromObjects(coderRegistry, schemaRegistry, (Iterable)o));
            }
            if (o instanceof Collection) {
                return CollectionCoder.of(Create.inferCoderFromObjects(coderRegistry, schemaRegistry, (Iterable)o));
            }
            if (o instanceof Iterable) {
                return IterableCoder.of(Create.inferCoderFromObjects(coderRegistry, schemaRegistry, (Iterable)o));
            }
            if (o instanceof Map) {
                return MapCoder.of(Create.inferCoderFromObjects(coderRegistry, schemaRegistry, ((Map)o).keySet()), Create.inferCoderFromObjects(coderRegistry, schemaRegistry, ((Map)o).entrySet()));
            }
            if (o instanceof KV) {
                return KvCoder.of(Create.inferCoderFromObject(coderRegistry, schemaRegistry, ((KV)o).getKey()), Create.inferCoderFromObject(coderRegistry, schemaRegistry, ((KV)o).getValue()));
            }
            return coderRegistry.getCoder(o.getClass());
        }
    }

    public static class TimestampedValues<T>
    extends PTransform<PBegin, PCollection<T>> {
        private final transient Iterable<TimestampedValue<T>> timestampedElements;
        private final transient Optional<Coder<T>> elementCoder;
        private final transient Optional<TypeDescriptor<T>> typeDescriptor;

        public TimestampedValues<T> withCoder(Coder<T> coder) {
            return new TimestampedValues<T>(this.timestampedElements, Optional.of(coder), this.typeDescriptor);
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        public TimestampedValues<T> withSchema(Schema schema, SerializableFunction<T, Row> toRowFunction, SerializableFunction<Row, T> fromRowFunction) {
            return this.withCoder(SchemaCoder.of(schema, toRowFunction, fromRowFunction));
        }

        public TimestampedValues<T> withType(TypeDescriptor<T> type) {
            return new TimestampedValues<T>(this.timestampedElements, this.elementCoder, Optional.of(type));
        }

        @Override
        public PCollection<T> expand(PBegin input) {
            try {
                Coder<T> coder = null;
                CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
                SchemaRegistry schemaRegistry = input.getPipeline().getSchemaRegistry();
                if (this.elementCoder.isPresent()) {
                    coder = this.elementCoder.get();
                } else if (this.typeDescriptor.isPresent()) {
                    try {
                        coder = SchemaCoder.of(schemaRegistry.getSchema(this.typeDescriptor.get()), schemaRegistry.getToRowFunction(this.typeDescriptor.get()), schemaRegistry.getFromRowFunction(this.typeDescriptor.get()));
                    }
                    catch (NoSuchSchemaException noSuchSchemaException) {
                        // empty catch block
                    }
                    if (coder == null) {
                        coder = coderRegistry.getCoder(this.typeDescriptor.get());
                    }
                } else {
                    Iterable rawElements = Iterables.transform(this.timestampedElements, TimestampedValue::getValue);
                    coder = Create.getDefaultCreateCoder(coderRegistry, schemaRegistry, rawElements);
                }
                PCollection intermediate = (PCollection)Pipeline.applyTransform(input, Create.of(this.timestampedElements).withCoder(TimestampedValue.TimestampedValueCoder.of(coder)));
                PCollection output = (PCollection)intermediate.apply(ParDo.of(new ConvertTimestamps()));
                output.setCoder(coder);
                return output;
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalArgumentException("Unable to infer a coder and no Coder was specified. Please set a coder by invoking CreateTimestamped.withCoder() explicitly.", e);
            }
        }

        private TimestampedValues(Iterable<TimestampedValue<T>> timestampedElements, Optional<Coder<T>> elementCoder, Optional<TypeDescriptor<T>> typeDescriptor) {
            this.timestampedElements = timestampedElements;
            this.elementCoder = elementCoder;
            this.typeDescriptor = typeDescriptor;
        }

        private static class ConvertTimestamps<T>
        extends DoFn<TimestampedValue<T>, T> {
            private ConvertTimestamps() {
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element TimestampedValue<T> element, DoFn.OutputReceiver<T> r) {
                r.outputWithTimestamp(element.getValue(), element.getTimestamp());
            }
        }
    }

    public static class OfValueProvider<T>
    extends PTransform<PBegin, PCollection<T>> {
        private final ValueProvider<T> provider;
        private final Coder<T> coder;

        private OfValueProvider(ValueProvider<T> provider, Coder<T> coder) {
            this.provider = Preconditions.checkNotNull(provider, "provider");
            this.coder = Preconditions.checkNotNull(coder, "coder");
        }

        @Override
        public PCollection<T> expand(PBegin input) {
            if (this.provider.isAccessible()) {
                Values<Object> values = Create.of(this.provider.get(), new Object[0]);
                return (PCollection)input.apply(values.withCoder(this.coder));
            }
            return ((PCollection)((PCollection)input.apply(Create.of(null, new Void[0]))).apply(MapElements.via(new SimpleFunction<Void, T>(){

                @Override
                public T apply(Void input) {
                    return provider.get();
                }
            }))).setCoder(this.coder);
        }
    }

    public static class Values<T>
    extends PTransform<PBegin, PCollection<T>> {
        private final transient Iterable<T> elems;
        private final transient Optional<Coder<T>> coder;
        private final transient Optional<TypeDescriptor<T>> typeDescriptor;

        public Values<T> withCoder(Coder<T> coder) {
            return new Values<T>(this.elems, Optional.of(coder), this.typeDescriptor);
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        public Values<T> withSchema(Schema schema, SerializableFunction<T, Row> toRowFunction, SerializableFunction<Row, T> fromRowFunction) {
            return this.withCoder(SchemaCoder.of(schema, toRowFunction, fromRowFunction));
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        public Values<T> withRowSchema(Schema schema) {
            return this.withCoder(SchemaCoder.of(schema, SerializableFunctions.identity(), SerializableFunctions.identity()));
        }

        public Values<T> withType(TypeDescriptor<T> type) {
            return new Values<T>(this.elems, this.coder, Optional.of(type));
        }

        public Iterable<T> getElements() {
            return this.elems;
        }

        @Override
        public PCollection<T> expand(PBegin input) {
            Coder<T> coder;
            block8: {
                try {
                    CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
                    SchemaRegistry schemaRegistry = input.getPipeline().getSchemaRegistry();
                    Coder<T> coder2 = coder = this.coder.isPresent() ? this.coder.get() : null;
                    if (coder != null) break block8;
                    if (this.typeDescriptor.isPresent()) {
                        try {
                            coder = SchemaCoder.of(schemaRegistry.getSchema(this.typeDescriptor.get()), schemaRegistry.getToRowFunction(this.typeDescriptor.get()), schemaRegistry.getFromRowFunction(this.typeDescriptor.get()));
                        }
                        catch (NoSuchSchemaException noSuchSchemaException) {
                            // empty catch block
                        }
                        if (coder == null) {
                            coder = coderRegistry.getCoder(this.typeDescriptor.get());
                        }
                        break block8;
                    }
                    coder = Create.getDefaultCreateCoder(coderRegistry, schemaRegistry, this.elems);
                }
                catch (CannotProvideCoderException e) {
                    throw new IllegalArgumentException("Unable to infer a coder and no Coder was specified. Please set a coder by invoking Create.withCoder() explicitly  or a schema by invoking Create.withSchema().", e);
                }
            }
            try {
                CreateSource<T> source = CreateSource.fromIterable(this.elems, coder);
                return (PCollection)input.getPipeline().apply(Read.from(source));
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to apply Create %s using Coder %s.", this, coder), e);
            }
        }

        private Values(Iterable<T> elems, Optional<Coder<T>> coder, Optional<TypeDescriptor<T>> typeDescriptor) {
            this.elems = elems;
            this.coder = coder;
            this.typeDescriptor = typeDescriptor;
        }

        private static class BytesReader<T>
        extends OffsetBasedSource.OffsetBasedReader<T> {
            private int index = -1;
            @Nullable
            private Optional<T> next;

            public BytesReader(CreateSource<T> source) {
                super(source);
            }

            @Override
            @Nullable
            public T getCurrent() throws NoSuchElementException {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                return this.next.orNull();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            protected long getCurrentOffset() {
                return this.index;
            }

            @Override
            protected boolean startImpl() throws IOException {
                return this.advanceImpl();
            }

            @Override
            public synchronized CreateSource<T> getCurrentSource() {
                return (CreateSource)super.getCurrentSource();
            }

            @Override
            protected boolean advanceImpl() throws IOException {
                OffsetBasedSource source = this.getCurrentSource();
                if (this.index + 1 >= ((CreateSource)source).allElementsBytes.size()) {
                    this.next = null;
                    return false;
                }
                ++this.index;
                this.next = Optional.fromNullable(CoderUtils.decodeFromByteArray(((CreateSource)source).coder, (byte[])((CreateSource)source).allElementsBytes.get(this.index)));
                return true;
            }
        }

        @VisibleForTesting
        static class CreateSource<T>
        extends OffsetBasedSource<T> {
            private final List<byte[]> allElementsBytes;
            private final long totalSize;
            private final Coder<T> coder;

            public static <T> CreateSource<T> fromIterable(Iterable<T> elements, Coder<T> elemCoder) throws CoderException, IOException {
                ImmutableList.Builder allElementsBytes = ImmutableList.builder();
                long totalSize = 0L;
                for (T element : elements) {
                    byte[] bytes = CoderUtils.encodeToByteArray(elemCoder, element);
                    allElementsBytes.add((Object)bytes);
                    totalSize += (long)bytes.length;
                }
                return new CreateSource<T>((List<byte[]>)((Object)allElementsBytes.build()), totalSize, elemCoder);
            }

            private CreateSource(List<byte[]> elementBytes, long totalSize, Coder<T> coder) {
                super(0L, elementBytes.size(), 1L);
                this.allElementsBytes = ImmutableList.copyOf(elementBytes);
                this.totalSize = totalSize;
                this.coder = coder;
            }

            @Override
            public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
                return this.totalSize;
            }

            @Override
            public BoundedSource.BoundedReader<T> createReader(PipelineOptions options) throws IOException {
                return new BytesReader(this);
            }

            @Override
            public Coder<T> getOutputCoder() {
                return this.coder;
            }

            @Override
            public long getMaxEndOffset(PipelineOptions options) throws Exception {
                return this.allElementsBytes.size();
            }

            @Override
            public OffsetBasedSource<T> createSourceForSubrange(long start, long end) {
                List<byte[]> primaryElems = this.allElementsBytes.subList((int)start, (int)end);
                long primarySizeEstimate = (long)((double)(this.totalSize * (long)primaryElems.size()) / (double)this.allElementsBytes.size());
                return new CreateSource<T>(primaryElems, primarySizeEstimate, this.coder);
            }

            @Override
            public long getBytesPerOffset() {
                if (this.allElementsBytes.isEmpty()) {
                    return 1L;
                }
                return Math.max(1L, this.totalSize / (long)this.allElementsBytes.size());
            }
        }
    }
}

