/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;

public class Partition<T>
extends PTransform<PCollection<T>, PCollectionList<T>> {
    private final transient PartitionDoFn<T> partitionDoFn;

    public static <T> Partition<T> of(int numPartitions, PartitionFn<? super T> partitionFn) {
        return new Partition<T>(new PartitionDoFn<T>(numPartitions, partitionFn));
    }

    @Override
    public PCollectionList<T> expand(PCollection<T> in) {
        TupleTagList outputTags = this.partitionDoFn.getOutputTags();
        PCollectionTuple outputs = (PCollectionTuple)((Object)in.apply(ParDo.of(this.partitionDoFn).withOutputTags(new TupleTag<Void>(){}, outputTags)));
        PCollectionList<?> pcs = PCollectionList.empty(in.getPipeline());
        Coder<T> coder = in.getCoder();
        Iterator<TupleTag<?>> iterator = outputTags.getAll().iterator();
        while (iterator.hasNext()) {
            TupleTag<?> outputTag;
            TupleTag<?> typedOutputTag = outputTag = iterator.next();
            pcs = pcs.and(outputs.get(typedOutputTag).setCoder(coder));
        }
        return pcs;
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.include("partitionFn", this.partitionDoFn);
    }

    private Partition(PartitionDoFn<T> partitionDoFn) {
        this.partitionDoFn = partitionDoFn;
    }

    private static class PartitionDoFn<X>
    extends DoFn<X, Void> {
        private final int numPartitions;
        private final PartitionFn<? super X> partitionFn;
        private final TupleTagList outputTags;

        public PartitionDoFn(int numPartitions, PartitionFn<? super X> partitionFn) {
            if (numPartitions <= 0) {
                throw new IllegalArgumentException("numPartitions must be > 0");
            }
            this.numPartitions = numPartitions;
            this.partitionFn = partitionFn;
            TupleTagList buildOutputTags = TupleTagList.empty();
            for (int partition = 0; partition < numPartitions; ++partition) {
                buildOutputTags = buildOutputTags.and(new TupleTag());
            }
            this.outputTags = buildOutputTags;
        }

        public TupleTagList getOutputTags() {
            return this.outputTags;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element X input, DoFn.MultiOutputReceiver r) {
            int partition = this.partitionFn.partitionFor(input, this.numPartitions);
            if (0 > partition || partition >= this.numPartitions) {
                throw new IndexOutOfBoundsException("Partition function returned out of bounds index: " + partition + " not in [0.." + this.numPartitions + ")");
            }
            TupleTag<?> typedTag = this.outputTags.get(partition);
            r.get(typedTag).output(input);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("numPartitions", this.numPartitions).withLabel("Partition Count")).add(DisplayData.item("partitionFn", this.partitionFn.getClass()).withLabel("Partition Function"));
        }
    }

    public static interface PartitionFn<T>
    extends Serializable {
        public int partitionFor(T var1, int var2);
    }
}

