/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import com.google.auto.value.AutoValue;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_BundleMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_FieldAccessDeclaration;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_GetInitialRestrictionMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_GetRestrictionCoderMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_LifecycleMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_NewTrackerMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_OnTimerMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_OnWindowExpirationMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_ElementParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_FinishBundleContextParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_OnTimerContextParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_OutputReceiverParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_PaneInfoParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_PipelineOptionsParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_ProcessContextParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_RestrictionTrackerParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_SchemaElementParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_StartBundleContextParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_StateParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_TaggedOutputReceiverParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_TimeDomainParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_TimerParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_TimestampParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_WindowParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_ProcessElementMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_SplitRestrictionMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_StateDeclaration;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_TimerDeclaration;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Predicates;

@AutoValue
public abstract class DoFnSignature {
    public abstract Class<? extends DoFn<?, ?>> fnClass();

    public abstract PCollection.IsBounded isBoundedPerElement();

    public abstract ProcessElementMethod processElement();

    public abstract Map<String, StateDeclaration> stateDeclarations();

    @Nullable
    public abstract BundleMethod startBundle();

    @Nullable
    public abstract BundleMethod finishBundle();

    @Nullable
    public abstract LifecycleMethod setup();

    @Nullable
    public abstract LifecycleMethod teardown();

    @Nullable
    public abstract OnWindowExpirationMethod onWindowExpiration();

    public abstract Map<String, TimerDeclaration> timerDeclarations();

    @Nullable
    public abstract Map<String, FieldAccessDeclaration> fieldAccessDeclarations();

    @Nullable
    public abstract GetInitialRestrictionMethod getInitialRestriction();

    @Nullable
    public abstract SplitRestrictionMethod splitRestriction();

    @Nullable
    public abstract GetRestrictionCoderMethod getRestrictionCoder();

    @Nullable
    public abstract NewTrackerMethod newTracker();

    @Nullable
    public abstract Map<String, OnTimerMethod> onTimerMethods();

    @Deprecated
    public boolean isStateful() {
        return this.stateDeclarations().size() > 0;
    }

    public boolean usesState() {
        return this.stateDeclarations().size() > 0;
    }

    public boolean usesTimers() {
        return this.timerDeclarations().size() > 0;
    }

    static Builder builder() {
        return new AutoValue_DoFnSignature.Builder();
    }

    @AutoValue
    public static abstract class GetRestrictionCoderMethod
    implements DoFnMethod {
        @Override
        public abstract Method targetMethod();

        public abstract TypeDescriptor<?> coderT();

        static GetRestrictionCoderMethod create(Method targetMethod, TypeDescriptor<?> coderT) {
            return new AutoValue_DoFnSignature_GetRestrictionCoderMethod(targetMethod, coderT);
        }
    }

    @AutoValue
    public static abstract class NewTrackerMethod
    implements DoFnMethod {
        @Override
        public abstract Method targetMethod();

        public abstract TypeDescriptor<?> restrictionT();

        public abstract TypeDescriptor<?> trackerT();

        static NewTrackerMethod create(Method targetMethod, TypeDescriptor<?> restrictionT, TypeDescriptor<?> trackerT) {
            return new AutoValue_DoFnSignature_NewTrackerMethod(targetMethod, restrictionT, trackerT);
        }
    }

    @AutoValue
    public static abstract class SplitRestrictionMethod
    implements DoFnMethod {
        @Override
        public abstract Method targetMethod();

        public abstract TypeDescriptor<?> restrictionT();

        static SplitRestrictionMethod create(Method targetMethod, TypeDescriptor<?> restrictionT) {
            return new AutoValue_DoFnSignature_SplitRestrictionMethod(targetMethod, restrictionT);
        }
    }

    @AutoValue
    public static abstract class GetInitialRestrictionMethod
    implements DoFnMethod {
        @Override
        public abstract Method targetMethod();

        public abstract TypeDescriptor<?> restrictionT();

        static GetInitialRestrictionMethod create(Method targetMethod, TypeDescriptor<?> restrictionT) {
            return new AutoValue_DoFnSignature_GetInitialRestrictionMethod(targetMethod, restrictionT);
        }
    }

    @AutoValue
    public static abstract class LifecycleMethod
    implements DoFnMethod {
        @Override
        public abstract Method targetMethod();

        static LifecycleMethod create(Method targetMethod) {
            return new AutoValue_DoFnSignature_LifecycleMethod(targetMethod);
        }
    }

    @AutoValue
    public static abstract class FieldAccessDeclaration {
        public abstract String id();

        public abstract Field field();

        static FieldAccessDeclaration create(String id, Field field) {
            field.setAccessible(true);
            return new AutoValue_DoFnSignature_FieldAccessDeclaration(id, field);
        }
    }

    @AutoValue
    public static abstract class StateDeclaration {
        public abstract String id();

        public abstract Field field();

        public abstract TypeDescriptor<? extends State> stateType();

        static StateDeclaration create(String id, Field field, TypeDescriptor<? extends State> stateType) {
            field.setAccessible(true);
            return new AutoValue_DoFnSignature_StateDeclaration(id, field, stateType);
        }
    }

    @AutoValue
    public static abstract class BundleMethod
    implements DoFnMethod {
        @Override
        public abstract Method targetMethod();

        static BundleMethod create(Method targetMethod) {
            return new AutoValue_DoFnSignature_BundleMethod(targetMethod);
        }
    }

    @AutoValue
    public static abstract class TimerDeclaration {
        public abstract String id();

        public abstract Field field();

        static TimerDeclaration create(String id, Field field) {
            return new AutoValue_DoFnSignature_TimerDeclaration(id, field);
        }
    }

    @AutoValue
    public static abstract class OnWindowExpirationMethod
    implements MethodWithExtraParameters {
        @Override
        public abstract Method targetMethod();

        public abstract boolean requiresStableInput();

        @Override
        @Nullable
        public abstract TypeDescriptor<? extends BoundedWindow> windowT();

        @Override
        public abstract List<Parameter> extraParameters();

        static OnWindowExpirationMethod create(Method targetMethod, boolean requiresStableInput, TypeDescriptor<? extends BoundedWindow> windowT, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_OnWindowExpirationMethod(targetMethod, requiresStableInput, windowT, Collections.unmodifiableList(extraParameters));
        }
    }

    @AutoValue
    public static abstract class OnTimerMethod
    implements MethodWithExtraParameters {
        public abstract String id();

        @Override
        public abstract Method targetMethod();

        public abstract boolean requiresStableInput();

        @Override
        @Nullable
        public abstract TypeDescriptor<? extends BoundedWindow> windowT();

        @Override
        public abstract List<Parameter> extraParameters();

        static OnTimerMethod create(Method targetMethod, String id, boolean requiresStableInput, TypeDescriptor<? extends BoundedWindow> windowT, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_OnTimerMethod(id, targetMethod, requiresStableInput, windowT, Collections.unmodifiableList(extraParameters));
        }
    }

    @AutoValue
    public static abstract class ProcessElementMethod
    implements MethodWithExtraParameters {
        @Override
        public abstract Method targetMethod();

        @Override
        public abstract List<Parameter> extraParameters();

        public abstract boolean requiresStableInput();

        @Nullable
        public abstract TypeDescriptor<?> trackerT();

        @Override
        @Nullable
        public abstract TypeDescriptor<? extends BoundedWindow> windowT();

        public abstract boolean hasReturnValue();

        static ProcessElementMethod create(Method targetMethod, List<Parameter> extraParameters, boolean requiresStableInput, TypeDescriptor<?> trackerT, @Nullable TypeDescriptor<? extends BoundedWindow> windowT, boolean hasReturnValue) {
            return new AutoValue_DoFnSignature_ProcessElementMethod(targetMethod, Collections.unmodifiableList(extraParameters), requiresStableInput, trackerT, windowT, hasReturnValue);
        }

        public boolean observesWindow() {
            return this.extraParameters().stream().anyMatch(Predicates.or(Predicates.instanceOf(Parameter.WindowParameter.class), Predicates.instanceOf(Parameter.TimerParameter.class), Predicates.instanceOf(Parameter.StateParameter.class))::apply);
        }

        @Nullable
        public Parameter.SchemaElementParameter getSchemaElementParameter() {
            Optional<Parameter> parameter = this.extraParameters().stream().filter(Predicates.instanceOf(Parameter.SchemaElementParameter.class)::apply).findFirst();
            return parameter.isPresent() ? (Parameter.SchemaElementParameter)parameter.get() : null;
        }

        @Nullable
        public Parameter.OutputReceiverParameter getMainOutputReceiver() {
            Optional<Parameter> parameter = this.extraParameters().stream().filter(Predicates.instanceOf(Parameter.OutputReceiverParameter.class)::apply).findFirst();
            return parameter.isPresent() ? (Parameter.OutputReceiverParameter)parameter.get() : null;
        }

        public boolean isSplittable() {
            return this.extraParameters().stream().anyMatch(Predicates.instanceOf(Parameter.RestrictionTrackerParameter.class)::apply);
        }
    }

    public static abstract class Parameter {
        private static final StartBundleContextParameter START_BUNDLE_CONTEXT_PARAMETER = new AutoValue_DoFnSignature_Parameter_StartBundleContextParameter();
        private static final FinishBundleContextParameter FINISH_BUNDLE_CONTEXT_PARAMETER = new AutoValue_DoFnSignature_Parameter_FinishBundleContextParameter();
        private static final ProcessContextParameter PROCESS_CONTEXT_PARAMETER = new AutoValue_DoFnSignature_Parameter_ProcessContextParameter();
        private static final OnTimerContextParameter ON_TIMER_CONTEXT_PARAMETER = new AutoValue_DoFnSignature_Parameter_OnTimerContextParameter();
        private static final TimestampParameter TIMESTAMP_PARAMETER = new AutoValue_DoFnSignature_Parameter_TimestampParameter();
        private static final PaneInfoParameter PANE_INFO_PARAMETER = new AutoValue_DoFnSignature_Parameter_PaneInfoParameter();
        private static final TimeDomainParameter TIME_DOMAIN_PARAMETER = new AutoValue_DoFnSignature_Parameter_TimeDomainParameter();
        private static final TaggedOutputReceiverParameter TAGGED_OUTPUT_RECEIVER_PARAMETER = new AutoValue_DoFnSignature_Parameter_TaggedOutputReceiverParameter();

        private Parameter() {
        }

        public <ResultT> ResultT match(Cases<ResultT> cases) {
            if (this instanceof StartBundleContextParameter) {
                return cases.dispatch((StartBundleContextParameter)this);
            }
            if (this instanceof FinishBundleContextParameter) {
                return cases.dispatch((FinishBundleContextParameter)this);
            }
            if (this instanceof ProcessContextParameter) {
                return cases.dispatch((ProcessContextParameter)this);
            }
            if (this instanceof OnTimerContextParameter) {
                return cases.dispatch((OnTimerContextParameter)this);
            }
            if (this instanceof WindowParameter) {
                return cases.dispatch((WindowParameter)this);
            }
            if (this instanceof PaneInfoParameter) {
                return cases.dispatch((PaneInfoParameter)this);
            }
            if (this instanceof RestrictionTrackerParameter) {
                return cases.dispatch((RestrictionTrackerParameter)this);
            }
            if (this instanceof StateParameter) {
                return cases.dispatch((StateParameter)this);
            }
            if (this instanceof TimerParameter) {
                return cases.dispatch((TimerParameter)this);
            }
            if (this instanceof PipelineOptionsParameter) {
                return cases.dispatch((PipelineOptionsParameter)this);
            }
            if (this instanceof ElementParameter) {
                return cases.dispatch((ElementParameter)this);
            }
            if (this instanceof SchemaElementParameter) {
                return cases.dispatch((SchemaElementParameter)this);
            }
            if (this instanceof TimestampParameter) {
                return cases.dispatch((TimestampParameter)this);
            }
            if (this instanceof OutputReceiverParameter) {
                return cases.dispatch((OutputReceiverParameter)this);
            }
            if (this instanceof TaggedOutputReceiverParameter) {
                return cases.dispatch((TaggedOutputReceiverParameter)this);
            }
            if (this instanceof TimeDomainParameter) {
                return cases.dispatch((TimeDomainParameter)this);
            }
            throw new IllegalStateException(String.format("Attempt to case match on unknown %s subclass %s", Parameter.class.getCanonicalName(), this.getClass().getCanonicalName()));
        }

        public static ProcessContextParameter processContext() {
            return PROCESS_CONTEXT_PARAMETER;
        }

        public static ElementParameter elementParameter(TypeDescriptor<?> elementT) {
            return new AutoValue_DoFnSignature_Parameter_ElementParameter(elementT);
        }

        public static SchemaElementParameter schemaElementParameter(TypeDescriptor<?> elementT, @Nullable String fieldAccessId) {
            return new AutoValue_DoFnSignature_Parameter_SchemaElementParameter(elementT, fieldAccessId);
        }

        public static TimestampParameter timestampParameter() {
            return TIMESTAMP_PARAMETER;
        }

        public static TimeDomainParameter timeDomainParameter() {
            return TIME_DOMAIN_PARAMETER;
        }

        public static OutputReceiverParameter outputReceiverParameter(boolean rowReceiver) {
            return new AutoValue_DoFnSignature_Parameter_OutputReceiverParameter(rowReceiver);
        }

        public static TaggedOutputReceiverParameter taggedOutputReceiverParameter() {
            return TAGGED_OUTPUT_RECEIVER_PARAMETER;
        }

        public static OnTimerContextParameter onTimerContext() {
            return ON_TIMER_CONTEXT_PARAMETER;
        }

        public static PaneInfoParameter paneInfoParameter() {
            return PANE_INFO_PARAMETER;
        }

        public static WindowParameter boundedWindow(TypeDescriptor<? extends BoundedWindow> windowT) {
            return new AutoValue_DoFnSignature_Parameter_WindowParameter(windowT);
        }

        public static PipelineOptionsParameter pipelineOptions() {
            return new AutoValue_DoFnSignature_Parameter_PipelineOptionsParameter();
        }

        public static RestrictionTrackerParameter restrictionTracker(TypeDescriptor<?> trackerT) {
            return new AutoValue_DoFnSignature_Parameter_RestrictionTrackerParameter(trackerT);
        }

        public static StateParameter stateParameter(StateDeclaration decl) {
            return new AutoValue_DoFnSignature_Parameter_StateParameter(decl);
        }

        public static TimerParameter timerParameter(TimerDeclaration decl) {
            return new AutoValue_DoFnSignature_Parameter_TimerParameter(decl);
        }

        @AutoValue
        public static abstract class TimerParameter
        extends Parameter {
            TimerParameter() {
            }

            public abstract TimerDeclaration referent();
        }

        @AutoValue
        public static abstract class StateParameter
        extends Parameter {
            StateParameter() {
            }

            public abstract StateDeclaration referent();
        }

        @AutoValue
        public static abstract class RestrictionTrackerParameter
        extends Parameter {
            RestrictionTrackerParameter() {
            }

            public abstract TypeDescriptor<?> trackerT();
        }

        @AutoValue
        public static abstract class PaneInfoParameter
        extends Parameter {
            PaneInfoParameter() {
            }
        }

        @AutoValue
        public static abstract class WindowParameter
        extends Parameter {
            WindowParameter() {
            }

            public abstract TypeDescriptor<? extends BoundedWindow> windowT();
        }

        @AutoValue
        public static abstract class OnTimerContextParameter
        extends Parameter {
            OnTimerContextParameter() {
            }
        }

        @AutoValue
        public static abstract class TaggedOutputReceiverParameter
        extends Parameter {
            TaggedOutputReceiverParameter() {
            }
        }

        @AutoValue
        public static abstract class OutputReceiverParameter
        extends Parameter {
            OutputReceiverParameter() {
            }

            public abstract boolean isRowReceiver();
        }

        @AutoValue
        public static abstract class TimeDomainParameter
        extends Parameter {
            TimeDomainParameter() {
            }
        }

        @AutoValue
        public static abstract class TimestampParameter
        extends Parameter {
            TimestampParameter() {
            }
        }

        @AutoValue
        public static abstract class SchemaElementParameter
        extends Parameter {
            SchemaElementParameter() {
            }

            public abstract TypeDescriptor<?> elementT();

            @Nullable
            public abstract String fieldAccessString();
        }

        @AutoValue
        public static abstract class ElementParameter
        extends Parameter {
            ElementParameter() {
            }

            public abstract TypeDescriptor<?> elementT();
        }

        @AutoValue
        public static abstract class ProcessContextParameter
        extends Parameter {
            ProcessContextParameter() {
            }
        }

        @AutoValue
        public static abstract class FinishBundleContextParameter
        extends Parameter {
            FinishBundleContextParameter() {
            }
        }

        @AutoValue
        public static abstract class StartBundleContextParameter
        extends Parameter {
            StartBundleContextParameter() {
            }
        }

        @AutoValue
        public static abstract class PipelineOptionsParameter
        extends Parameter {
            PipelineOptionsParameter() {
            }
        }

        public static interface Cases<ResultT> {
            public ResultT dispatch(StartBundleContextParameter var1);

            public ResultT dispatch(FinishBundleContextParameter var1);

            public ResultT dispatch(ProcessContextParameter var1);

            public ResultT dispatch(ElementParameter var1);

            public ResultT dispatch(SchemaElementParameter var1);

            public ResultT dispatch(TimestampParameter var1);

            public ResultT dispatch(TimeDomainParameter var1);

            public ResultT dispatch(OutputReceiverParameter var1);

            public ResultT dispatch(TaggedOutputReceiverParameter var1);

            public ResultT dispatch(OnTimerContextParameter var1);

            public ResultT dispatch(WindowParameter var1);

            public ResultT dispatch(PaneInfoParameter var1);

            public ResultT dispatch(RestrictionTrackerParameter var1);

            public ResultT dispatch(StateParameter var1);

            public ResultT dispatch(TimerParameter var1);

            public ResultT dispatch(PipelineOptionsParameter var1);

            public static abstract class WithDefault<ResultT>
            implements Cases<ResultT> {
                protected abstract ResultT dispatchDefault(Parameter var1);

                @Override
                public ResultT dispatch(StartBundleContextParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(FinishBundleContextParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(ProcessContextParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(ElementParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(SchemaElementParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(TaggedOutputReceiverParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(OutputReceiverParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(TimestampParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(TimeDomainParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(OnTimerContextParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(WindowParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(PaneInfoParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(RestrictionTrackerParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(StateParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(TimerParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(PipelineOptionsParameter p) {
                    return this.dispatchDefault(p);
                }
            }
        }
    }

    public static interface MethodWithExtraParameters
    extends DoFnMethod {
        public List<Parameter> extraParameters();

        @Nullable
        public TypeDescriptor<? extends BoundedWindow> windowT();
    }

    public static interface DoFnMethod {
        public Method targetMethod();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setFnClass(Class<? extends DoFn<?, ?>> var1);

        abstract Builder setIsBoundedPerElement(PCollection.IsBounded var1);

        abstract Builder setProcessElement(ProcessElementMethod var1);

        abstract Builder setStartBundle(BundleMethod var1);

        abstract Builder setFinishBundle(BundleMethod var1);

        abstract Builder setSetup(LifecycleMethod var1);

        abstract Builder setTeardown(LifecycleMethod var1);

        abstract Builder setOnWindowExpiration(OnWindowExpirationMethod var1);

        abstract Builder setGetInitialRestriction(GetInitialRestrictionMethod var1);

        abstract Builder setSplitRestriction(SplitRestrictionMethod var1);

        abstract Builder setGetRestrictionCoder(GetRestrictionCoderMethod var1);

        abstract Builder setNewTracker(NewTrackerMethod var1);

        abstract Builder setStateDeclarations(Map<String, StateDeclaration> var1);

        abstract Builder setTimerDeclarations(Map<String, TimerDeclaration> var1);

        abstract Builder setFieldAccessDeclarations(Map<String, FieldAccessDeclaration> var1);

        abstract Builder setOnTimerMethods(Map<String, OnTimerMethod> var1);

        abstract DoFnSignature build();
    }
}

