/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import com.google.auto.value.AutoValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignatures_ParameterDescription;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.splittabledofn.HasDefaultTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;
import org.joda.time.Instant;

public class DoFnSignatures {
    private static final Map<Class<?>, DoFnSignature> signatureCache = new LinkedHashMap();
    private static final ImmutableList<Class<? extends DoFnSignature.Parameter>> ALLOWED_NON_SPLITTABLE_PROCESS_ELEMENT_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.ProcessContextParameter.class, DoFnSignature.Parameter.ElementParameter.class, DoFnSignature.Parameter.SchemaElementParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.OutputReceiverParameter.class, DoFnSignature.Parameter.TaggedOutputReceiverParameter.class, DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.PaneInfoParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class, DoFnSignature.Parameter.TimerParameter.class, DoFnSignature.Parameter.StateParameter.class);
    private static final ImmutableList<Class<? extends DoFnSignature.Parameter>> ALLOWED_SPLITTABLE_PROCESS_ELEMENT_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.PipelineOptionsParameter.class, DoFnSignature.Parameter.ElementParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.OutputReceiverParameter.class, DoFnSignature.Parameter.TaggedOutputReceiverParameter.class, DoFnSignature.Parameter.ProcessContextParameter.class, DoFnSignature.Parameter.RestrictionTrackerParameter.class);
    private static final ImmutableList<Class<? extends DoFnSignature.Parameter>> ALLOWED_ON_TIMER_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.OnTimerContextParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.TimeDomainParameter.class, DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class, DoFnSignature.Parameter.OutputReceiverParameter.class, DoFnSignature.Parameter.TaggedOutputReceiverParameter.class, DoFnSignature.Parameter.TimerParameter.class, DoFnSignature.Parameter.StateParameter.class);
    private static final Collection<Class<? extends DoFnSignature.Parameter>> ALLOWED_ON_WINDOW_EXPIRATION_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class, DoFnSignature.Parameter.OutputReceiverParameter.class, DoFnSignature.Parameter.TaggedOutputReceiverParameter.class, DoFnSignature.Parameter.StateParameter.class);
    private static final MemberGetter<Method> GET_METHODS = Class::getDeclaredMethods;
    private static final MemberGetter<Field> GET_FIELDS = Class::getDeclaredFields;

    private DoFnSignatures() {
    }

    public static <FnT extends DoFn<?, ?>> DoFnSignature signatureForDoFn(FnT fn) {
        return DoFnSignatures.getSignature(fn.getClass());
    }

    public static synchronized <FnT extends DoFn<?, ?>> DoFnSignature getSignature(Class<FnT> fn) {
        return signatureCache.computeIfAbsent(fn, k -> DoFnSignatures.parseSignature(fn));
    }

    private static DoFnSignature parseSignature(Class<? extends DoFn<?, ?>> fnClass) {
        DoFnSignature.Builder signatureBuilder = DoFnSignature.builder();
        ErrorReporter errors = new ErrorReporter(null, fnClass.getName());
        errors.checkArgument(DoFn.class.isAssignableFrom(fnClass), "Must be subtype of DoFn", new Object[0]);
        signatureBuilder.setFnClass(fnClass);
        TypeDescriptor<DoFn<?, ?>> fnT = TypeDescriptor.of(fnClass);
        TypeDescriptor<?> inputT = null;
        TypeDescriptor<?> outputT = null;
        for (TypeDescriptor supertype : fnT.getTypes()) {
            if (!supertype.getRawType().equals(DoFn.class)) continue;
            Type[] args = ((ParameterizedType)supertype.getType()).getActualTypeArguments();
            inputT = TypeDescriptor.of(args[0]);
            outputT = TypeDescriptor.of(args[1]);
        }
        errors.checkNotNull(inputT, "Unable to determine input type", new Object[0]);
        FnAnalysisContext fnContext = FnAnalysisContext.create();
        fnContext.addStateDeclarations(DoFnSignatures.analyzeStateDeclarations(errors, fnClass).values());
        fnContext.addTimerDeclarations(DoFnSignatures.analyzeTimerDeclarations(errors, fnClass).values());
        fnContext.addFieldAccessDeclarations(DoFnSignatures.analyzeFieldAccessDeclaration(errors, fnClass).values());
        Method processElementMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.ProcessElement.class, fnClass, true);
        Method startBundleMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.StartBundle.class, fnClass, false);
        Method finishBundleMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.FinishBundle.class, fnClass, false);
        Method setupMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.Setup.class, fnClass, false);
        Method teardownMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.Teardown.class, fnClass, false);
        Method onWindowExpirationMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.OnWindowExpiration.class, fnClass, false);
        Method getInitialRestrictionMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.GetInitialRestriction.class, fnClass, false);
        Method splitRestrictionMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.SplitRestriction.class, fnClass, false);
        Method getRestrictionCoderMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.GetRestrictionCoder.class, fnClass, false);
        Method newTrackerMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.NewTracker.class, fnClass, false);
        Collection<Method> onTimerMethods = DoFnSignatures.declaredMethodsWithAnnotation(DoFn.OnTimer.class, fnClass, DoFn.class);
        HashMap<String, DoFnSignature.OnTimerMethod> onTimerMethodMap = Maps.newHashMapWithExpectedSize(onTimerMethods.size());
        for (Method onTimerMethod : onTimerMethods) {
            String id = onTimerMethod.getAnnotation(DoFn.OnTimer.class).value();
            errors.checkArgument(fnContext.getTimerDeclarations().containsKey(id), "Callback %s is for undeclared timer %s", onTimerMethod, id);
            DoFnSignature.TimerDeclaration timerDecl = fnContext.getTimerDeclarations().get(id);
            errors.checkArgument(timerDecl.field().getDeclaringClass().equals(onTimerMethod.getDeclaringClass()), "Callback %s is for timer %s declared in a different class %s. Timer callbacks must be declared in the same lexical scope as their timer", onTimerMethod, id, timerDecl.field().getDeclaringClass().getCanonicalName());
            onTimerMethodMap.put(id, DoFnSignatures.analyzeOnTimerMethod(errors, fnT, onTimerMethod, id, inputT, outputT, fnContext));
        }
        signatureBuilder.setOnTimerMethods(onTimerMethodMap);
        for (DoFnSignature.TimerDeclaration decl : fnContext.getTimerDeclarations().values()) {
            errors.checkArgument(onTimerMethodMap.containsKey(decl.id()), "No callback registered via %s for timer %s", DoFn.OnTimer.class.getSimpleName(), decl.id());
        }
        ErrorReporter processElementErrors = errors.forMethod(DoFn.ProcessElement.class, processElementMethod);
        DoFnSignature.ProcessElementMethod processElement = DoFnSignatures.analyzeProcessElementMethod(processElementErrors, fnT, processElementMethod, inputT, outputT, fnContext);
        signatureBuilder.setProcessElement(processElement);
        if (startBundleMethod != null) {
            ErrorReporter startBundleErrors = errors.forMethod(DoFn.StartBundle.class, startBundleMethod);
            signatureBuilder.setStartBundle(DoFnSignatures.analyzeStartBundleMethod(startBundleErrors, fnT, startBundleMethod, inputT, outputT));
        }
        if (finishBundleMethod != null) {
            ErrorReporter finishBundleErrors = errors.forMethod(DoFn.FinishBundle.class, finishBundleMethod);
            signatureBuilder.setFinishBundle(DoFnSignatures.analyzeFinishBundleMethod(finishBundleErrors, fnT, finishBundleMethod, inputT, outputT));
        }
        if (setupMethod != null) {
            signatureBuilder.setSetup(DoFnSignatures.analyzeLifecycleMethod(errors.forMethod(DoFn.Setup.class, setupMethod), setupMethod));
        }
        if (teardownMethod != null) {
            signatureBuilder.setTeardown(DoFnSignatures.analyzeLifecycleMethod(errors.forMethod(DoFn.Teardown.class, teardownMethod), teardownMethod));
        }
        if (onWindowExpirationMethod != null) {
            signatureBuilder.setOnWindowExpiration(DoFnSignatures.analyzeOnWindowExpirationMethod(errors, fnT, onWindowExpirationMethod, inputT, outputT, fnContext));
        }
        if (getInitialRestrictionMethod != null) {
            ErrorReporter getInitialRestrictionErrors = errors.forMethod(DoFn.GetInitialRestriction.class, getInitialRestrictionMethod);
            signatureBuilder.setGetInitialRestriction(DoFnSignatures.analyzeGetInitialRestrictionMethod(getInitialRestrictionErrors, fnT, getInitialRestrictionMethod, inputT));
        }
        if (splitRestrictionMethod != null) {
            ErrorReporter splitRestrictionErrors = errors.forMethod(DoFn.SplitRestriction.class, splitRestrictionMethod);
            signatureBuilder.setSplitRestriction(DoFnSignatures.analyzeSplitRestrictionMethod(splitRestrictionErrors, fnT, splitRestrictionMethod, inputT));
        }
        if (getRestrictionCoderMethod != null) {
            ErrorReporter getRestrictionCoderErrors = errors.forMethod(DoFn.GetRestrictionCoder.class, getRestrictionCoderMethod);
            signatureBuilder.setGetRestrictionCoder(DoFnSignatures.analyzeGetRestrictionCoderMethod(getRestrictionCoderErrors, fnT, getRestrictionCoderMethod));
        }
        if (newTrackerMethod != null) {
            ErrorReporter newTrackerErrors = errors.forMethod(DoFn.NewTracker.class, newTrackerMethod);
            signatureBuilder.setNewTracker(DoFnSignatures.analyzeNewTrackerMethod(newTrackerErrors, fnT, newTrackerMethod));
        }
        signatureBuilder.setIsBoundedPerElement(DoFnSignatures.inferBoundedness(fnT, processElement, errors));
        signatureBuilder.setStateDeclarations(fnContext.getStateDeclarations());
        signatureBuilder.setTimerDeclarations(fnContext.getTimerDeclarations());
        signatureBuilder.setFieldAccessDeclarations(fnContext.getFieldAccessDeclarations());
        DoFnSignature signature = signatureBuilder.build();
        if (processElement.isSplittable()) {
            DoFnSignatures.verifySplittableMethods(signature, errors);
        } else {
            DoFnSignatures.verifyUnsplittableMethods(errors, signature);
        }
        return signature;
    }

    private static PCollection.IsBounded inferBoundedness(TypeDescriptor<? extends DoFn> fnT, DoFnSignature.ProcessElementMethod processElement, ErrorReporter errors) {
        PCollection.IsBounded isBounded = null;
        for (TypeDescriptor supertype : fnT.getTypes()) {
            if (!supertype.getRawType().isAnnotationPresent(DoFn.BoundedPerElement.class) && !supertype.getRawType().isAnnotationPresent(DoFn.UnboundedPerElement.class)) continue;
            errors.checkArgument(isBounded == null, "Both @%s and @%s specified", DoFn.BoundedPerElement.class.getSimpleName(), DoFn.UnboundedPerElement.class.getSimpleName());
            isBounded = supertype.getRawType().isAnnotationPresent(DoFn.BoundedPerElement.class) ? PCollection.IsBounded.BOUNDED : PCollection.IsBounded.UNBOUNDED;
        }
        if (processElement.isSplittable()) {
            if (isBounded == null) {
                isBounded = processElement.hasReturnValue() ? PCollection.IsBounded.UNBOUNDED : PCollection.IsBounded.BOUNDED;
            }
        } else {
            errors.checkArgument(isBounded == null, "Non-splittable, but annotated as @" + (isBounded == PCollection.IsBounded.BOUNDED ? DoFn.BoundedPerElement.class.getSimpleName() : DoFn.UnboundedPerElement.class.getSimpleName()), new Object[0]);
            Preconditions.checkState(!processElement.hasReturnValue(), "Should have been inferred splittable");
            isBounded = PCollection.IsBounded.BOUNDED;
        }
        return isBounded;
    }

    private static void verifySplittableMethods(DoFnSignature signature, ErrorReporter errors) {
        TypeDescriptor<?> restrictionT;
        ErrorReporter getInitialRestrictionErrors;
        String originOfTrackerT;
        TypeDescriptor<?> trackerT;
        DoFnSignature.ProcessElementMethod processElement = signature.processElement();
        DoFnSignature.GetInitialRestrictionMethod getInitialRestriction = signature.getInitialRestriction();
        DoFnSignature.NewTrackerMethod newTracker = signature.newTracker();
        DoFnSignature.GetRestrictionCoderMethod getRestrictionCoder = signature.getRestrictionCoder();
        DoFnSignature.SplitRestrictionMethod splitRestriction = signature.splitRestriction();
        ErrorReporter processElementErrors = errors.forMethod(DoFn.ProcessElement.class, processElement.targetMethod());
        ArrayList<String> missingRequiredMethods = new ArrayList<String>();
        if (getInitialRestriction == null) {
            missingRequiredMethods.add("@" + DoFn.GetInitialRestriction.class.getSimpleName());
        }
        if (newTracker == null) {
            if (getInitialRestriction != null && getInitialRestriction.restrictionT().isSubtypeOf(TypeDescriptor.of(HasDefaultTracker.class))) {
                trackerT = getInitialRestriction.restrictionT().resolveType(HasDefaultTracker.class.getTypeParameters()[1]);
                originOfTrackerT = String.format("restriction type %s of @%s method %s", DoFnSignatures.formatType(getInitialRestriction.restrictionT()), DoFn.GetInitialRestriction.class.getSimpleName(), DoFnSignatures.format(getInitialRestriction.targetMethod()));
            } else {
                missingRequiredMethods.add("@" + DoFn.NewTracker.class.getSimpleName());
                trackerT = null;
                originOfTrackerT = null;
            }
        } else {
            trackerT = newTracker.trackerT();
            originOfTrackerT = String.format("%s method %s", DoFn.NewTracker.class.getSimpleName(), DoFnSignatures.format(newTracker.targetMethod()));
            getInitialRestrictionErrors = errors.forMethod(DoFn.GetInitialRestriction.class, getInitialRestriction.targetMethod());
            restrictionT = getInitialRestriction.restrictionT();
            getInitialRestrictionErrors.checkArgument(restrictionT.equals(newTracker.restrictionT()), "Uses restriction type %s, but @%s method %s uses restriction type %s", DoFnSignatures.formatType(restrictionT), DoFn.NewTracker.class.getSimpleName(), DoFnSignatures.format(newTracker.targetMethod()), DoFnSignatures.formatType(newTracker.restrictionT()));
        }
        if (!missingRequiredMethods.isEmpty()) {
            processElementErrors.throwIllegalArgument("Splittable, but does not define the following required methods: %s", missingRequiredMethods);
        }
        getInitialRestrictionErrors = errors.forMethod(DoFn.GetInitialRestriction.class, getInitialRestriction.targetMethod());
        restrictionT = getInitialRestriction.restrictionT();
        processElementErrors.checkArgument(processElement.trackerT().equals(trackerT), "Has tracker type %s, but the DoFn's tracker type was inferred as %s from %s", DoFnSignatures.formatType(processElement.trackerT()), trackerT, originOfTrackerT);
        if (getRestrictionCoder != null) {
            getInitialRestrictionErrors.checkArgument(getRestrictionCoder.coderT().isSubtypeOf(DoFnSignatures.coderTypeOf(restrictionT)), "Uses restriction type %s, but @%s method %s returns %s which is not a subtype of %s", DoFnSignatures.formatType(restrictionT), DoFn.GetRestrictionCoder.class.getSimpleName(), DoFnSignatures.format(getRestrictionCoder.targetMethod()), DoFnSignatures.formatType(getRestrictionCoder.coderT()), DoFnSignatures.formatType(DoFnSignatures.coderTypeOf(restrictionT)));
        }
        if (splitRestriction != null) {
            getInitialRestrictionErrors.checkArgument(splitRestriction.restrictionT().equals(restrictionT), "Uses restriction type %s, but @%s method %s uses restriction type %s", DoFnSignatures.formatType(restrictionT), DoFn.SplitRestriction.class.getSimpleName(), DoFnSignatures.format(splitRestriction.targetMethod()), DoFnSignatures.formatType(splitRestriction.restrictionT()));
        }
    }

    private static void verifyUnsplittableMethods(ErrorReporter errors, DoFnSignature signature) {
        ArrayList<String> forbiddenMethods = new ArrayList<String>();
        if (signature.getInitialRestriction() != null) {
            forbiddenMethods.add("@" + DoFn.GetInitialRestriction.class.getSimpleName());
        }
        if (signature.splitRestriction() != null) {
            forbiddenMethods.add("@" + DoFn.SplitRestriction.class.getSimpleName());
        }
        if (signature.newTracker() != null) {
            forbiddenMethods.add("@" + DoFn.NewTracker.class.getSimpleName());
        }
        if (signature.getRestrictionCoder() != null) {
            forbiddenMethods.add("@" + DoFn.GetRestrictionCoder.class.getSimpleName());
        }
        errors.checkArgument(forbiddenMethods.isEmpty(), "Non-splittable, but defines methods: %s", forbiddenMethods);
    }

    private static <InputT, OutputT> TypeDescriptor<DoFn.ProcessContext> doFnProcessContextTypeOf(TypeDescriptor<InputT> inputT, TypeDescriptor<OutputT> outputT) {
        return new TypeDescriptor<DoFn.ProcessContext>(){}.where(new TypeParameter<InputT>(){}, inputT).where(new TypeParameter<OutputT>(){}, outputT);
    }

    private static <InputT, OutputT> TypeDescriptor<DoFn.StartBundleContext> doFnStartBundleContextTypeOf(TypeDescriptor<InputT> inputT, TypeDescriptor<OutputT> outputT) {
        return new TypeDescriptor<DoFn.StartBundleContext>(){}.where(new TypeParameter<InputT>(){}, inputT).where(new TypeParameter<OutputT>(){}, outputT);
    }

    private static <InputT, OutputT> TypeDescriptor<DoFn.FinishBundleContext> doFnFinishBundleContextTypeOf(TypeDescriptor<InputT> inputT, TypeDescriptor<OutputT> outputT) {
        return new TypeDescriptor<DoFn.FinishBundleContext>(){}.where(new TypeParameter<InputT>(){}, inputT).where(new TypeParameter<OutputT>(){}, outputT);
    }

    private static <InputT, OutputT> TypeDescriptor<DoFn.OnTimerContext> doFnOnTimerContextTypeOf(TypeDescriptor<InputT> inputT, TypeDescriptor<OutputT> outputT) {
        return new TypeDescriptor<DoFn.OnTimerContext>(){}.where(new TypeParameter<InputT>(){}, inputT).where(new TypeParameter<OutputT>(){}, outputT);
    }

    @VisibleForTesting
    static DoFnSignature.OnTimerMethod analyzeOnTimerMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnClass, Method m, String timerId, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, FnAnalysisContext fnContext) {
        errors.checkArgument(Void.TYPE.equals(m.getReturnType()), "Must return void", new Object[0]);
        Type[] params = m.getGenericParameterTypes();
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        boolean requiresStableInput = m.isAnnotationPresent(DoFn.RequiresStableInput.class);
        TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnClass, m);
        ArrayList<DoFnSignature.Parameter> extraParameters = new ArrayList<DoFnSignature.Parameter>();
        ErrorReporter onTimerErrors = errors.forMethod(DoFn.OnTimer.class, m);
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter parameter = DoFnSignatures.analyzeExtraParameter(onTimerErrors, fnContext, methodContext, fnClass, ParameterDescription.of(m, i, fnClass.resolveType(params[i]), Arrays.asList(m.getParameterAnnotations()[i])), inputT, outputT);
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_ON_TIMER_PARAMETERS);
            extraParameters.add(parameter);
        }
        return DoFnSignature.OnTimerMethod.create(m, timerId, requiresStableInput, windowT, extraParameters);
    }

    @VisibleForTesting
    static DoFnSignature.OnWindowExpirationMethod analyzeOnWindowExpirationMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnClass, Method m, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, FnAnalysisContext fnContext) {
        errors.checkArgument(Void.TYPE.equals(m.getReturnType()), "Must return void", new Object[0]);
        Type[] params = m.getGenericParameterTypes();
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        boolean requiresStableInput = m.isAnnotationPresent(DoFn.RequiresStableInput.class);
        TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnClass, m);
        ArrayList<DoFnSignature.Parameter> extraParameters = new ArrayList<DoFnSignature.Parameter>();
        ErrorReporter onWindowExpirationErrors = errors.forMethod(DoFn.OnWindowExpiration.class, m);
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter parameter = DoFnSignatures.analyzeExtraParameter(onWindowExpirationErrors, fnContext, methodContext, fnClass, ParameterDescription.of(m, i, fnClass.resolveType(params[i]), Arrays.asList(m.getParameterAnnotations()[i])), inputT, outputT);
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_ON_WINDOW_EXPIRATION_PARAMETERS);
            extraParameters.add(parameter);
        }
        return DoFnSignature.OnWindowExpirationMethod.create(m, requiresStableInput, windowT, extraParameters);
    }

    @VisibleForTesting
    static DoFnSignature.ProcessElementMethod analyzeProcessElementMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnClass, Method m, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, FnAnalysisContext fnContext) {
        errors.checkArgument(Void.TYPE.equals(m.getReturnType()) || DoFn.ProcessContinuation.class.equals(m.getReturnType()), "Must return void or %s", DoFn.ProcessContinuation.class.getSimpleName());
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        boolean requiresStableInput = m.isAnnotationPresent(DoFn.RequiresStableInput.class);
        Type[] params = m.getGenericParameterTypes();
        TypeDescriptor<?> trackerT = DoFnSignatures.getTrackerType(fnClass, m);
        TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnClass, m);
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter extraParam = DoFnSignatures.analyzeExtraParameter(errors.forMethod(DoFn.ProcessElement.class, m), fnContext, methodContext, fnClass, ParameterDescription.of(m, i, fnClass.resolveType(params[i]), Arrays.asList(m.getParameterAnnotations()[i])), inputT, outputT);
            methodContext.addParameter(extraParam);
        }
        if (methodContext.hasRestrictionTrackerParameter()) {
            for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
                DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_SPLITTABLE_PROCESS_ELEMENT_PARAMETERS);
            }
        } else {
            for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
                DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_NON_SPLITTABLE_PROCESS_ELEMENT_PARAMETERS);
            }
        }
        return DoFnSignature.ProcessElementMethod.create(m, methodContext.getExtraParameters(), requiresStableInput, trackerT, windowT, DoFn.ProcessContinuation.class.equals(m.getReturnType()));
    }

    private static void checkParameterOneOf(ErrorReporter errors, DoFnSignature.Parameter parameter, Collection<Class<? extends DoFnSignature.Parameter>> allowedParameterClasses) {
        for (Class<? extends DoFnSignature.Parameter> paramClass : allowedParameterClasses) {
            if (!paramClass.isAssignableFrom(parameter.getClass())) continue;
            return;
        }
        errors.throwIllegalArgument("Illegal parameter type: %s", parameter);
    }

    private static DoFnSignature.Parameter analyzeExtraParameter(ErrorReporter methodErrors, FnAnalysisContext fnContext, MethodAnalysisContext methodContext, TypeDescriptor<? extends DoFn<?, ?>> fnClass, ParameterDescription param, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT) {
        TypeDescriptor<DoFn.ProcessContext> expectedProcessContextT = DoFnSignatures.doFnProcessContextTypeOf(inputT, outputT);
        TypeDescriptor<DoFn.OnTimerContext> expectedOnTimerContextT = DoFnSignatures.doFnOnTimerContextTypeOf(inputT, outputT);
        TypeDescriptor<?> paramT = param.getType();
        Class<?> rawType = paramT.getRawType();
        ErrorReporter paramErrors = methodErrors.forParameter(param);
        if (DoFnSignatures.hasElementAnnotation(param.getAnnotations())) {
            if (paramT.equals(inputT)) {
                return DoFnSignature.Parameter.elementParameter(paramT);
            }
            String fieldAccessString = DoFnSignatures.getFieldAccessId(param.getAnnotations());
            return DoFnSignature.Parameter.schemaElementParameter(paramT, fieldAccessString);
        }
        if (DoFnSignatures.hasTimestampAnnotation(param.getAnnotations())) {
            methodErrors.checkArgument(rawType.equals(Instant.class), "@Timestamp argument must have type org.joda.time.Instant.", new Object[0]);
            return DoFnSignature.Parameter.timestampParameter();
        }
        if (rawType.equals(TimeDomain.class)) {
            return DoFnSignature.Parameter.timeDomainParameter();
        }
        if (rawType.equals(PaneInfo.class)) {
            return DoFnSignature.Parameter.paneInfoParameter();
        }
        if (rawType.equals(DoFn.ProcessContext.class)) {
            paramErrors.checkArgument(paramT.equals(expectedProcessContextT), "ProcessContext argument must have type %s", DoFnSignatures.formatType(expectedProcessContextT));
            return DoFnSignature.Parameter.processContext();
        }
        if (rawType.equals(DoFn.OnTimerContext.class)) {
            paramErrors.checkArgument(paramT.equals(expectedOnTimerContextT), "OnTimerContext argument must have type %s", DoFnSignatures.formatType(expectedOnTimerContextT));
            return DoFnSignature.Parameter.onTimerContext();
        }
        if (BoundedWindow.class.isAssignableFrom(rawType)) {
            methodErrors.checkArgument(!methodContext.hasWindowParameter(), "Multiple %s parameters", BoundedWindow.class.getSimpleName());
            return DoFnSignature.Parameter.boundedWindow(paramT);
        }
        if (rawType.equals(DoFn.OutputReceiver.class)) {
            boolean schemaRowReceiver;
            boolean bl = schemaRowReceiver = paramT.equals(DoFnSignatures.outputReceiverTypeOf(TypeDescriptor.of(Row.class))) && !outputT.equals(TypeDescriptor.of(Row.class));
            if (!schemaRowReceiver) {
                TypeDescriptor<DoFn.OutputReceiver<?>> expectedReceiverT = DoFnSignatures.outputReceiverTypeOf(outputT);
                paramErrors.checkArgument(paramT.equals(expectedReceiverT), "OutputReceiver should be parameterized by %s", outputT);
            }
            return DoFnSignature.Parameter.outputReceiverParameter(schemaRowReceiver);
        }
        if (rawType.equals(DoFn.MultiOutputReceiver.class)) {
            return DoFnSignature.Parameter.taggedOutputReceiverParameter();
        }
        if (PipelineOptions.class.equals(rawType)) {
            methodErrors.checkArgument(!methodContext.hasPipelineOptionsParamter(), "Multiple %s parameters", PipelineOptions.class.getSimpleName());
            return DoFnSignature.Parameter.pipelineOptions();
        }
        if (RestrictionTracker.class.isAssignableFrom(rawType)) {
            methodErrors.checkArgument(!methodContext.hasRestrictionTrackerParameter(), "Multiple %s parameters", RestrictionTracker.class.getSimpleName());
            return DoFnSignature.Parameter.restrictionTracker(paramT);
        }
        if (rawType.equals(Timer.class)) {
            String id = DoFnSignatures.getTimerId(param.getAnnotations());
            paramErrors.checkArgument(id != null, "%s missing %s annotation", Timer.class.getSimpleName(), DoFn.TimerId.class.getSimpleName());
            paramErrors.checkArgument(!methodContext.getTimerParameters().containsKey(id), "duplicate %s: \"%s\"", DoFn.TimerId.class.getSimpleName(), id);
            DoFnSignature.TimerDeclaration timerDecl = fnContext.getTimerDeclarations().get(id);
            paramErrors.checkArgument(timerDecl != null, "reference to undeclared %s: \"%s\"", DoFn.TimerId.class.getSimpleName(), id);
            paramErrors.checkArgument(timerDecl.field().getDeclaringClass().equals(param.getMethod().getDeclaringClass()), "%s %s declared in a different class %s. Timers may be referenced only in the lexical scope where they are declared.", DoFn.TimerId.class.getSimpleName(), id, timerDecl.field().getDeclaringClass().getName());
            return DoFnSignature.Parameter.timerParameter(timerDecl);
        }
        if (State.class.isAssignableFrom(rawType)) {
            String id = DoFnSignatures.getStateId(param.getAnnotations());
            paramErrors.checkArgument(id != null, "missing %s annotation", DoFn.StateId.class.getSimpleName());
            paramErrors.checkArgument(!methodContext.getStateParameters().containsKey(id), "duplicate %s: \"%s\"", DoFn.StateId.class.getSimpleName(), id);
            TypeDescriptor<?> stateType = param.getType();
            DoFnSignature.StateDeclaration stateDecl = fnContext.getStateDeclarations().get(id);
            paramErrors.checkArgument(stateDecl != null, "reference to undeclared %s: \"%s\"", DoFn.StateId.class.getSimpleName(), id);
            paramErrors.checkArgument(stateDecl.stateType().isSubtypeOf(stateType), "data type of reference to %s %s must be a supertype of %s", DoFn.StateId.class.getSimpleName(), id, DoFnSignatures.formatType(stateDecl.stateType()));
            paramErrors.checkArgument(stateDecl.field().getDeclaringClass().equals(param.getMethod().getDeclaringClass()), "%s %s declared in a different class %s. State may be referenced only in the class where it is declared.", DoFn.StateId.class.getSimpleName(), id, stateDecl.field().getDeclaringClass().getName());
            return DoFnSignature.Parameter.stateParameter(stateDecl);
        }
        List<String> allowedParamTypes = Arrays.asList(DoFnSignatures.formatType(new TypeDescriptor<BoundedWindow>(){}), DoFnSignatures.formatType(new TypeDescriptor<RestrictionTracker<?, ?>>(){}));
        paramErrors.throwIllegalArgument("%s is not a valid context parameter. Should be one of %s", DoFnSignatures.formatType(paramT), allowedParamTypes);
        return null;
    }

    @Nullable
    private static String getTimerId(List<Annotation> annotations) {
        DoFn.TimerId stateId = DoFnSignatures.findFirstOfType(annotations, DoFn.TimerId.class);
        return stateId != null ? stateId.value() : null;
    }

    @Nullable
    private static String getStateId(List<Annotation> annotations) {
        DoFn.StateId stateId = DoFnSignatures.findFirstOfType(annotations, DoFn.StateId.class);
        return stateId != null ? stateId.value() : null;
    }

    @Nullable
    private static String getFieldAccessId(List<Annotation> annotations) {
        DoFn.FieldAccess access = DoFnSignatures.findFirstOfType(annotations, DoFn.FieldAccess.class);
        return access != null ? access.value() : null;
    }

    @Nullable
    static <T> T findFirstOfType(List<Annotation> annotations, Class<T> clazz) {
        Optional<Annotation> annotation = annotations.stream().filter(a -> a.annotationType().equals(clazz)).findFirst();
        return (T)(annotation.isPresent() ? annotation.get() : null);
    }

    private static boolean hasElementAnnotation(List<Annotation> annotations) {
        return annotations.stream().anyMatch(a -> a.annotationType().equals(DoFn.Element.class));
    }

    private static boolean hasTimestampAnnotation(List<Annotation> annotations) {
        return annotations.stream().anyMatch(a -> a.annotationType().equals(DoFn.Timestamp.class));
    }

    @Nullable
    private static TypeDescriptor<?> getTrackerType(TypeDescriptor<?> fnClass, Method method) {
        Type[] params;
        for (Type param : params = method.getGenericParameterTypes()) {
            TypeDescriptor<?> paramT = fnClass.resolveType(param);
            if (!RestrictionTracker.class.isAssignableFrom(paramT.getRawType())) continue;
            return paramT;
        }
        return null;
    }

    @Nullable
    private static TypeDescriptor<? extends BoundedWindow> getWindowType(TypeDescriptor<?> fnClass, Method method) {
        Type[] params;
        for (Type param : params = method.getGenericParameterTypes()) {
            TypeDescriptor<?> paramT = fnClass.resolveType(param);
            if (!BoundedWindow.class.isAssignableFrom(paramT.getRawType())) continue;
            return paramT;
        }
        return null;
    }

    @VisibleForTesting
    static DoFnSignature.BundleMethod analyzeStartBundleMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnT, Method m, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT) {
        errors.checkArgument(Void.TYPE.equals(m.getReturnType()), "Must return void", new Object[0]);
        TypeDescriptor<DoFn.StartBundleContext> expectedContextT = DoFnSignatures.doFnStartBundleContextTypeOf(inputT, outputT);
        Type[] params = m.getGenericParameterTypes();
        errors.checkArgument(params.length == 0 || params.length == 1 && fnT.resolveType(params[0]).equals(expectedContextT), "Must take a single argument of type %s", DoFnSignatures.formatType(expectedContextT));
        return DoFnSignature.BundleMethod.create(m);
    }

    @VisibleForTesting
    static DoFnSignature.BundleMethod analyzeFinishBundleMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnT, Method m, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT) {
        errors.checkArgument(Void.TYPE.equals(m.getReturnType()), "Must return void", new Object[0]);
        TypeDescriptor<DoFn.FinishBundleContext> expectedContextT = DoFnSignatures.doFnFinishBundleContextTypeOf(inputT, outputT);
        Type[] params = m.getGenericParameterTypes();
        errors.checkArgument(params.length == 0 || params.length == 1 && fnT.resolveType(params[0]).equals(expectedContextT), "Must take a single argument of type %s", DoFnSignatures.formatType(expectedContextT));
        return DoFnSignature.BundleMethod.create(m);
    }

    private static DoFnSignature.LifecycleMethod analyzeLifecycleMethod(ErrorReporter errors, Method m) {
        errors.checkArgument(Void.TYPE.equals(m.getReturnType()), "Must return void", new Object[0]);
        errors.checkArgument(m.getGenericParameterTypes().length == 0, "Must take zero arguments", new Object[0]);
        return DoFnSignature.LifecycleMethod.create(m);
    }

    @VisibleForTesting
    static DoFnSignature.GetInitialRestrictionMethod analyzeGetInitialRestrictionMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn> fnT, Method m, TypeDescriptor<?> inputT) {
        Type[] params = m.getGenericParameterTypes();
        errors.checkArgument(params.length == 1 && fnT.resolveType(params[0]).equals(inputT), "Must take a single argument of type %s", DoFnSignatures.formatType(inputT));
        return DoFnSignature.GetInitialRestrictionMethod.create(m, fnT.resolveType(m.getGenericReturnType()));
    }

    private static <OutputT> TypeDescriptor<DoFn.OutputReceiver<OutputT>> outputReceiverTypeOf(TypeDescriptor<OutputT> outputT) {
        return new TypeDescriptor<DoFn.OutputReceiver<OutputT>>(){}.where(new TypeParameter<OutputT>(){}, outputT);
    }

    @VisibleForTesting
    static DoFnSignature.SplitRestrictionMethod analyzeSplitRestrictionMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn> fnT, Method m, TypeDescriptor<?> inputT) {
        errors.checkArgument(Void.TYPE.equals(m.getReturnType()), "Must return void", new Object[0]);
        Type[] params = m.getGenericParameterTypes();
        errors.checkArgument(params.length == 3, "Must have exactly 3 arguments", new Object[0]);
        errors.checkArgument(fnT.resolveType(params[0]).equals(inputT), "First argument must be the element type %s", DoFnSignatures.formatType(inputT));
        TypeDescriptor<?> restrictionT = fnT.resolveType(params[1]);
        TypeDescriptor<?> receiverT = fnT.resolveType(params[2]);
        TypeDescriptor<DoFn.OutputReceiver<?>> expectedReceiverT = DoFnSignatures.outputReceiverTypeOf(restrictionT);
        errors.checkArgument(receiverT.equals(expectedReceiverT), "Third argument must be %s, but is %s", DoFnSignatures.formatType(expectedReceiverT), DoFnSignatures.formatType(receiverT));
        return DoFnSignature.SplitRestrictionMethod.create(m, restrictionT);
    }

    private static ImmutableMap<String, DoFnSignature.TimerDeclaration> analyzeTimerDeclarations(ErrorReporter errors, Class<?> fnClazz) {
        HashMap<String, DoFnSignature.TimerDeclaration> declarations = new HashMap<String, DoFnSignature.TimerDeclaration>();
        for (Field field : DoFnSignatures.declaredFieldsWithAnnotation(DoFn.TimerId.class, fnClazz, DoFn.class)) {
            field.setAccessible(true);
            String id = field.getAnnotation(DoFn.TimerId.class).value();
            DoFnSignatures.validateTimerField(errors, declarations, id, field);
            declarations.put(id, DoFnSignature.TimerDeclaration.create(id, field));
        }
        return ImmutableMap.copyOf(declarations);
    }

    private static void validateTimerField(ErrorReporter errors, Map<String, DoFnSignature.TimerDeclaration> declarations, String id, Field field) {
        Class<?> timerSpecRawType;
        if (declarations.containsKey(id)) {
            errors.throwIllegalArgument("Duplicate %s \"%s\", used on both of [%s] and [%s]", DoFn.TimerId.class.getSimpleName(), id, field.toString(), declarations.get(id).field().toString());
        }
        if (!(timerSpecRawType = field.getType()).equals(TimerSpec.class)) {
            errors.throwIllegalArgument("%s annotation on non-%s field [%s]", DoFn.TimerId.class.getSimpleName(), TimerSpec.class.getSimpleName(), field.toString());
        }
        if (!Modifier.isFinal(field.getModifiers())) {
            errors.throwIllegalArgument("Non-final field %s annotated with %s. Timer declarations must be final.", field.toString(), DoFn.TimerId.class.getSimpleName());
        }
    }

    private static <T> TypeDescriptor<Coder<T>> coderTypeOf(TypeDescriptor<T> elementT) {
        return new TypeDescriptor<Coder<T>>(){}.where(new TypeParameter<T>(){}, elementT);
    }

    @VisibleForTesting
    static DoFnSignature.GetRestrictionCoderMethod analyzeGetRestrictionCoderMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn> fnT, Method m) {
        errors.checkArgument(m.getParameterTypes().length == 0, "Must have zero arguments", new Object[0]);
        TypeDescriptor<Coder> resT = fnT.resolveType(m.getGenericReturnType());
        errors.checkArgument(resT.isSubtypeOf(TypeDescriptor.of(Coder.class)), "Must return a Coder, but returns %s", DoFnSignatures.formatType(resT));
        return DoFnSignature.GetRestrictionCoderMethod.create(m, resT);
    }

    private static <RestrictionT> TypeDescriptor<RestrictionTracker<RestrictionT, ?>> restrictionTrackerTypeOf(TypeDescriptor<RestrictionT> restrictionT) {
        return new TypeDescriptor<RestrictionTracker<RestrictionT, ?>>(){}.where(new TypeParameter<RestrictionT>(){}, restrictionT);
    }

    @VisibleForTesting
    static DoFnSignature.NewTrackerMethod analyzeNewTrackerMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn> fnT, Method m) {
        Type[] params = m.getGenericParameterTypes();
        errors.checkArgument(params.length == 1, "Must have a single argument", new Object[0]);
        TypeDescriptor<?> restrictionT = fnT.resolveType(params[0]);
        TypeDescriptor<RestrictionTracker<?, ?>> trackerT = fnT.resolveType(m.getGenericReturnType());
        TypeDescriptor<RestrictionTracker<?, ?>> expectedTrackerT = DoFnSignatures.restrictionTrackerTypeOf(restrictionT);
        errors.checkArgument(trackerT.isSubtypeOf(expectedTrackerT), "Returns %s, but must return a subtype of %s", DoFnSignatures.formatType(trackerT), DoFnSignatures.formatType(expectedTrackerT));
        return DoFnSignature.NewTrackerMethod.create(m, restrictionT, trackerT);
    }

    private static Collection<Method> declaredMethodsWithAnnotation(Class<? extends Annotation> anno, Class<?> startClass, Class<?> stopClass) {
        return DoFnSignatures.declaredMembersWithAnnotation(anno, startClass, stopClass, GET_METHODS);
    }

    private static Collection<Field> declaredFieldsWithAnnotation(Class<? extends Annotation> anno, Class<?> startClass, Class<?> stopClass) {
        return DoFnSignatures.declaredMembersWithAnnotation(anno, startClass, stopClass, GET_FIELDS);
    }

    private static <MemberT extends AnnotatedElement> Collection<MemberT> declaredMembersWithAnnotation(Class<? extends Annotation> anno, Class<?> startClass, Class<?> stopClass, MemberGetter<MemberT> getter) {
        ArrayList<AnnotatedElement> matches = new ArrayList<AnnotatedElement>();
        LinkedHashSet interfaces = new LinkedHashSet();
        for (Class<?> clazz = startClass; clazz != null && !clazz.equals(stopClass); clazz = clazz.getSuperclass()) {
            for (AnnotatedElement member : (AnnotatedElement[])getter.getMembers(clazz)) {
                if (!member.isAnnotationPresent(anno)) continue;
                matches.add(member);
            }
            for (TypeDescriptor typeDescriptor : TypeDescriptor.of(clazz).getInterfaces()) {
                interfaces.add(typeDescriptor.getRawType());
            }
        }
        for (Class clazz : interfaces) {
            for (AnnotatedElement member : (AnnotatedElement[])getter.getMembers(clazz)) {
                if (!member.isAnnotationPresent(anno)) continue;
                matches.add(member);
            }
        }
        return matches;
    }

    private static Map<String, DoFnSignature.FieldAccessDeclaration> analyzeFieldAccessDeclaration(ErrorReporter errors, Class<?> fnClazz) {
        HashMap<String, DoFnSignature.FieldAccessDeclaration> fieldAccessDeclarations = new HashMap<String, DoFnSignature.FieldAccessDeclaration>();
        for (Field field : DoFnSignatures.declaredFieldsWithAnnotation(DoFn.FieldAccess.class, fnClazz, DoFn.class)) {
            field.setAccessible(true);
            DoFn.FieldAccess fieldAccessAnnotation = field.getAnnotation(DoFn.FieldAccess.class);
            if (!Modifier.isFinal(field.getModifiers())) {
                errors.throwIllegalArgument("Non-final field %s annotated with %s. Field access declarations must be final.", field.toString(), DoFn.FieldAccess.class.getSimpleName());
                continue;
            }
            Class<?> fieldAccessRawType = field.getType();
            if (!fieldAccessRawType.equals(FieldAccessDescriptor.class)) {
                errors.throwIllegalArgument("Field %s annotated with %s, but the value was not of type %s", field.toString(), DoFn.FieldAccess.class.getSimpleName(), FieldAccessDescriptor.class.getSimpleName());
            }
            fieldAccessDeclarations.put(fieldAccessAnnotation.value(), DoFnSignature.FieldAccessDeclaration.create(fieldAccessAnnotation.value(), field));
        }
        return fieldAccessDeclarations;
    }

    private static Map<String, DoFnSignature.StateDeclaration> analyzeStateDeclarations(ErrorReporter errors, Class<?> fnClazz) {
        HashMap<String, DoFnSignature.StateDeclaration> declarations = new HashMap<String, DoFnSignature.StateDeclaration>();
        for (Field field : DoFnSignatures.declaredFieldsWithAnnotation(DoFn.StateId.class, fnClazz, DoFn.class)) {
            field.setAccessible(true);
            String id = field.getAnnotation(DoFn.StateId.class).value();
            if (declarations.containsKey(id)) {
                errors.throwIllegalArgument("Duplicate %s \"%s\", used on both of [%s] and [%s]", DoFn.StateId.class.getSimpleName(), id, field.toString(), ((DoFnSignature.StateDeclaration)declarations.get(id)).field().toString());
                continue;
            }
            Class<?> stateSpecRawType = field.getType();
            if (!TypeDescriptor.of(stateSpecRawType).isSubtypeOf(TypeDescriptor.of(StateSpec.class))) {
                errors.throwIllegalArgument("%s annotation on non-%s field [%s] that has class %s", DoFn.StateId.class.getSimpleName(), StateSpec.class.getSimpleName(), field.toString(), stateSpecRawType.getName());
                continue;
            }
            if (!Modifier.isFinal(field.getModifiers())) {
                errors.throwIllegalArgument("Non-final field %s annotated with %s. State declarations must be final.", field.toString(), DoFn.StateId.class.getSimpleName());
                continue;
            }
            Type stateSpecType = field.getGenericType();
            TypeDescriptor<?> stateSpecSubclassTypeDescriptor = TypeDescriptor.of(stateSpecType);
            TypeDescriptor<StateSpec> stateSpecTypeDescriptor = stateSpecSubclassTypeDescriptor.getSupertype(StateSpec.class);
            Type unresolvedStateType = ((ParameterizedType)stateSpecTypeDescriptor.getType()).getActualTypeArguments()[0];
            TypeDescriptor<?> stateType = TypeDescriptor.of(fnClazz).resolveType(unresolvedStateType);
            declarations.put(id, DoFnSignature.StateDeclaration.create(id, field, stateType));
        }
        return ImmutableMap.copyOf(declarations);
    }

    @Nullable
    private static Method findAnnotatedMethod(ErrorReporter errors, Class<? extends Annotation> anno, Class<?> fnClazz, boolean required) {
        Collection<Method> matches = DoFnSignatures.declaredMethodsWithAnnotation(anno, fnClazz, DoFn.class);
        if (matches.isEmpty()) {
            errors.checkArgument(!required, "No method annotated with @%s found", anno.getSimpleName());
            return null;
        }
        Method first = matches.iterator().next();
        for (Method other : matches) {
            errors.checkArgument(first.getName().equals(other.getName()) && Arrays.equals(first.getParameterTypes(), other.getParameterTypes()), "Found multiple methods annotated with @%s. [%s] and [%s]", anno.getSimpleName(), DoFnSignatures.format(first), DoFnSignatures.format(other));
        }
        ErrorReporter methodErrors = errors.forMethod(anno, first);
        methodErrors.checkArgument((first.getModifiers() & 1) != 0, "Must be public", new Object[0]);
        methodErrors.checkArgument((first.getModifiers() & 8) == 0, "Must not be static", new Object[0]);
        return first;
    }

    private static String format(Method method) {
        return ReflectHelpers.METHOD_FORMATTER.apply(method);
    }

    private static String formatType(TypeDescriptor<?> t) {
        return ReflectHelpers.TYPE_SIMPLE_DESCRIPTION.apply(t.getType());
    }

    public static StateSpec<?> getStateSpecOrThrow(DoFnSignature.StateDeclaration stateDeclaration, DoFn<?, ?> target) {
        try {
            Object fieldValue = stateDeclaration.field().get(target);
            Preconditions.checkState(fieldValue instanceof StateSpec, "Malformed %s class %s: state declaration field %s does not have type %s.", (Object)DoFn.class.getSimpleName(), (Object)target.getClass().getName(), (Object)stateDeclaration.field().getName(), StateSpec.class);
            return (StateSpec)stateDeclaration.field().get(target);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException(String.format("Malformed %s class %s: state declaration field %s is not accessible.", DoFn.class.getSimpleName(), target.getClass().getName(), stateDeclaration.field().getName()));
        }
    }

    public static TimerSpec getTimerSpecOrThrow(DoFnSignature.TimerDeclaration timerDeclaration, DoFn<?, ?> target) {
        try {
            Object fieldValue = timerDeclaration.field().get(target);
            Preconditions.checkState(fieldValue instanceof TimerSpec, "Malformed %s class %s: timer declaration field %s does not have type %s.", (Object)DoFn.class.getSimpleName(), (Object)target.getClass().getName(), (Object)timerDeclaration.field().getName(), TimerSpec.class);
            return (TimerSpec)timerDeclaration.field().get(target);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException(String.format("Malformed %s class %s: timer declaration field %s is not accessible.", DoFn.class.getSimpleName(), target.getClass().getName(), timerDeclaration.field().getName()));
        }
    }

    static class ErrorReporter {
        private final String label;

        ErrorReporter(@Nullable ErrorReporter root, String label) {
            this.label = root == null ? label : String.format("%s, %s", root.label, label);
        }

        ErrorReporter forMethod(Class<? extends Annotation> annotation, Method method) {
            return new ErrorReporter(this, String.format("@%s %s", annotation.getSimpleName(), method == null ? "(absent)" : DoFnSignatures.format(method)));
        }

        ErrorReporter forParameter(ParameterDescription param) {
            return new ErrorReporter(this, String.format("parameter of type %s at index %s", DoFnSignatures.formatType(param.getType()), param.getIndex()));
        }

        void throwIllegalArgument(String message, Object ... args) {
            throw new IllegalArgumentException(this.label + ": " + String.format(message, args));
        }

        public void checkArgument(boolean condition, String message, Object ... args) {
            if (!condition) {
                this.throwIllegalArgument(message, args);
            }
        }

        public void checkNotNull(Object value, String message, Object ... args) {
            if (value == null) {
                this.throwIllegalArgument(message, args);
            }
        }
    }

    private static interface MemberGetter<MemberT> {
        public MemberT[] getMembers(Class<?> var1);
    }

    @AutoValue
    static abstract class ParameterDescription {
        ParameterDescription() {
        }

        public abstract Method getMethod();

        public abstract int getIndex();

        public abstract TypeDescriptor<?> getType();

        public abstract List<Annotation> getAnnotations();

        public static ParameterDescription of(Method method, int index, TypeDescriptor<?> type, List<Annotation> annotations) {
            return new AutoValue_DoFnSignatures_ParameterDescription(method, index, type, annotations);
        }

        public static ParameterDescription of(Method method, int index, TypeDescriptor<?> type, Annotation[] annotations) {
            return new AutoValue_DoFnSignatures_ParameterDescription(method, index, type, Arrays.asList(annotations));
        }
    }

    private static class MethodAnalysisContext {
        private final Map<String, DoFnSignature.Parameter.StateParameter> stateParameters = new HashMap<String, DoFnSignature.Parameter.StateParameter>();
        private final Map<String, DoFnSignature.Parameter.TimerParameter> timerParameters = new HashMap<String, DoFnSignature.Parameter.TimerParameter>();
        private final List<DoFnSignature.Parameter> extraParameters = new ArrayList<DoFnSignature.Parameter>();
        @Nullable
        private TypeDescriptor<? extends BoundedWindow> windowT;

        private MethodAnalysisContext() {
        }

        public boolean hasRestrictionTrackerParameter() {
            return this.extraParameters.stream().anyMatch(Predicates.instanceOf(DoFnSignature.Parameter.RestrictionTrackerParameter.class)::apply);
        }

        public boolean hasWindowParameter() {
            return this.extraParameters.stream().anyMatch(Predicates.instanceOf(DoFnSignature.Parameter.WindowParameter.class)::apply);
        }

        public boolean hasPipelineOptionsParamter() {
            return this.extraParameters.stream().anyMatch(Predicates.instanceOf(DoFnSignature.Parameter.PipelineOptionsParameter.class)::apply);
        }

        @Nullable
        public TypeDescriptor<? extends BoundedWindow> getWindowType() {
            return this.windowT;
        }

        public Map<String, DoFnSignature.Parameter.StateParameter> getStateParameters() {
            return Collections.unmodifiableMap(this.stateParameters);
        }

        public Map<String, DoFnSignature.Parameter.TimerParameter> getTimerParameters() {
            return Collections.unmodifiableMap(this.timerParameters);
        }

        public List<DoFnSignature.Parameter> getExtraParameters() {
            return Collections.unmodifiableList(this.extraParameters);
        }

        public void addParameter(DoFnSignature.Parameter param) {
            this.extraParameters.add(param);
            if (param instanceof DoFnSignature.Parameter.StateParameter) {
                DoFnSignature.Parameter.StateParameter stateParameter = (DoFnSignature.Parameter.StateParameter)param;
                this.stateParameters.put(stateParameter.referent().id(), stateParameter);
            }
            if (param instanceof DoFnSignature.Parameter.TimerParameter) {
                DoFnSignature.Parameter.TimerParameter timerParameter = (DoFnSignature.Parameter.TimerParameter)param;
                this.timerParameters.put(timerParameter.referent().id(), timerParameter);
            }
        }

        public static MethodAnalysisContext create() {
            return new MethodAnalysisContext();
        }
    }

    @VisibleForTesting
    static class FnAnalysisContext {
        private final Map<String, DoFnSignature.StateDeclaration> stateDeclarations = new HashMap<String, DoFnSignature.StateDeclaration>();
        private final Map<String, DoFnSignature.TimerDeclaration> timerDeclarations = new HashMap<String, DoFnSignature.TimerDeclaration>();
        private final Map<String, DoFnSignature.FieldAccessDeclaration> fieldAccessDeclarations = new HashMap<String, DoFnSignature.FieldAccessDeclaration>();

        private FnAnalysisContext() {
        }

        public static FnAnalysisContext create() {
            return new FnAnalysisContext();
        }

        public Map<String, DoFnSignature.StateDeclaration> getStateDeclarations() {
            return Collections.unmodifiableMap(this.stateDeclarations);
        }

        public Map<String, DoFnSignature.TimerDeclaration> getTimerDeclarations() {
            return Collections.unmodifiableMap(this.timerDeclarations);
        }

        @Nullable
        public Map<String, DoFnSignature.FieldAccessDeclaration> getFieldAccessDeclarations() {
            return this.fieldAccessDeclarations;
        }

        public void addStateDeclaration(DoFnSignature.StateDeclaration decl) {
            this.stateDeclarations.put(decl.id(), decl);
        }

        public void addStateDeclarations(Iterable<DoFnSignature.StateDeclaration> decls) {
            for (DoFnSignature.StateDeclaration decl : decls) {
                this.addStateDeclaration(decl);
            }
        }

        public void addTimerDeclaration(DoFnSignature.TimerDeclaration decl) {
            this.timerDeclarations.put(decl.id(), decl);
        }

        public void addTimerDeclarations(Iterable<DoFnSignature.TimerDeclaration> decls) {
            for (DoFnSignature.TimerDeclaration decl : decls) {
                this.addTimerDeclaration(decl);
            }
        }

        public void addFieldAccessDeclaration(DoFnSignature.FieldAccessDeclaration decl) {
            this.fieldAccessDeclarations.put(decl.id(), decl);
        }

        public void addFieldAccessDeclarations(Iterable<DoFnSignature.FieldAccessDeclaration> decls) {
            for (DoFnSignature.FieldAccessDeclaration decl : decls) {
                this.addFieldAccessDeclaration(decl);
            }
        }
    }
}

