/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.splittabledofn;

import java.math.BigDecimal;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.splittabledofn.Backlog;
import org.apache.beam.sdk.transforms.splittabledofn.Backlogs;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public class OffsetRangeTracker
extends RestrictionTracker<OffsetRange, Long>
implements Backlogs.HasBacklog {
    private OffsetRange range;
    @Nullable
    private Long lastClaimedOffset = null;
    @Nullable
    private Long lastAttemptedOffset = null;

    public OffsetRangeTracker(OffsetRange range) {
        this.range = Preconditions.checkNotNull(range);
    }

    @Override
    public synchronized OffsetRange currentRestriction() {
        return this.range;
    }

    @Override
    public synchronized OffsetRange checkpoint() {
        Preconditions.checkState(this.lastClaimedOffset != null, "Can't checkpoint before any offset was successfully claimed");
        OffsetRange res = new OffsetRange(this.lastClaimedOffset + 1L, this.range.getTo());
        this.range = new OffsetRange(this.range.getFrom(), this.lastClaimedOffset + 1L);
        return res;
    }

    @Override
    protected synchronized boolean tryClaimImpl(Long i) {
        Preconditions.checkArgument(this.lastAttemptedOffset == null || i > this.lastAttemptedOffset, "Trying to claim offset %s while last attempted was %s", (Object)i, (Object)this.lastAttemptedOffset);
        Preconditions.checkArgument(i >= this.range.getFrom(), "Trying to claim offset %s before start of the range %s", (Object)i, (Object)this.range);
        this.lastAttemptedOffset = i;
        if (i >= this.range.getTo()) {
            return false;
        }
        this.lastClaimedOffset = i;
        return true;
    }

    @Override
    public synchronized void checkDone() throws IllegalStateException {
        Preconditions.checkState(this.lastAttemptedOffset >= this.range.getTo() - 1L, "Last attempted offset was %s in range %s, claiming work in [%s, %s) was not attempted", (Object)this.lastAttemptedOffset, (Object)this.range, (Object)(this.lastAttemptedOffset + 1L), (Object)this.range.getTo());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("range", this.range).add("lastClaimedOffset", this.lastClaimedOffset).add("lastAttemptedOffset", this.lastAttemptedOffset).toString();
    }

    @Override
    public synchronized Backlog getBacklog() {
        if (this.lastAttemptedOffset == null) {
            return Backlog.of(BigDecimal.valueOf(this.range.getTo() - this.range.getFrom()));
        }
        return Backlog.of(BigDecimal.valueOf(Math.max(this.range.getTo() - this.lastAttemptedOffset, 0L)));
    }
}

