/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.splittabledofn;

import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public abstract class RestrictionTracker<RestrictionT, PositionT> {
    @Nullable
    private ClaimObserver<PositionT> claimObserver;

    @Internal
    public void setClaimObserver(ClaimObserver<PositionT> claimObserver) {
        Preconditions.checkNotNull(claimObserver, "claimObserver");
        Preconditions.checkState(this.claimObserver == null, "A claim observer has already been set");
        this.claimObserver = claimObserver;
    }

    public final boolean tryClaim(PositionT position) {
        if (this.tryClaimImpl(position)) {
            if (this.claimObserver != null) {
                this.claimObserver.onClaimed(position);
            }
            return true;
        }
        if (this.claimObserver != null) {
            this.claimObserver.onClaimFailed(position);
        }
        return false;
    }

    @Internal
    protected abstract boolean tryClaimImpl(PositionT var1);

    public abstract RestrictionT currentRestriction();

    public abstract RestrictionT checkpoint();

    public abstract void checkDone() throws IllegalStateException;

    @Internal
    public static interface ClaimObserver<PositionT> {
        public void onClaimed(PositionT var1);

        public void onClaimFailed(PositionT var1);
    }
}

