/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Never;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterWatermark {
    private static final String TO_STRING = "AfterWatermark.pastEndOfWindow()";

    private AfterWatermark() {
    }

    public static FromEndOfWindow pastEndOfWindow() {
        return new FromEndOfWindow();
    }

    public static class FromEndOfWindow
    extends Trigger.OnceTrigger {
        private FromEndOfWindow() {
            super(null);
        }

        public AfterWatermarkEarlyAndLate withEarlyFirings(Trigger.OnceTrigger earlyFirings) {
            Preconditions.checkNotNull(earlyFirings, "Must specify the trigger to use for early firings");
            return new AfterWatermarkEarlyAndLate(earlyFirings, null);
        }

        public AfterWatermarkEarlyAndLate withLateFirings(Trigger.OnceTrigger lateFirings) {
            Preconditions.checkNotNull(lateFirings, "Must specify the trigger to use for late firings");
            return new AfterWatermarkEarlyAndLate(Never.ever(), lateFirings);
        }

        @Override
        public Instant getWatermarkThatGuaranteesFiring(BoundedWindow window) {
            return window.maxTimestamp();
        }

        @Override
        protected FromEndOfWindow getContinuationTrigger(List<Trigger> continuationTriggers) {
            return this;
        }

        @Override
        public String toString() {
            return AfterWatermark.TO_STRING;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof FromEndOfWindow;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getClass());
        }
    }

    public static class AfterWatermarkEarlyAndLate
    extends Trigger {
        private final Trigger.OnceTrigger earlyTrigger;
        @Nullable
        private final Trigger.OnceTrigger lateTrigger;

        public Trigger.OnceTrigger getEarlyTrigger() {
            return this.earlyTrigger;
        }

        public Trigger.OnceTrigger getLateTrigger() {
            return this.lateTrigger;
        }

        private AfterWatermarkEarlyAndLate(Trigger.OnceTrigger earlyTrigger, Trigger.OnceTrigger lateTrigger) {
            super(lateTrigger == null ? ImmutableList.of(earlyTrigger) : ImmutableList.of(earlyTrigger, lateTrigger));
            this.earlyTrigger = Preconditions.checkNotNull(earlyTrigger, "earlyTrigger should not be null");
            this.lateTrigger = lateTrigger;
        }

        public AfterWatermarkEarlyAndLate withEarlyFirings(Trigger.OnceTrigger earlyTrigger) {
            return new AfterWatermarkEarlyAndLate(earlyTrigger, this.lateTrigger);
        }

        public AfterWatermarkEarlyAndLate withLateFirings(Trigger.OnceTrigger lateTrigger) {
            return new AfterWatermarkEarlyAndLate(this.earlyTrigger, lateTrigger);
        }

        @Override
        public Trigger getContinuationTrigger() {
            return new AfterWatermarkEarlyAndLate(this.earlyTrigger.getContinuationTrigger(), this.lateTrigger == null ? null : this.lateTrigger.getContinuationTrigger());
        }

        @Override
        protected Trigger getContinuationTrigger(List<Trigger> continuationTriggers) {
            throw new UnsupportedOperationException("Should not call getContinuationTrigger(List<Trigger>)");
        }

        @Override
        public Instant getWatermarkThatGuaranteesFiring(BoundedWindow window) {
            return window.maxTimestamp();
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(AfterWatermark.TO_STRING);
            if (!(this.earlyTrigger instanceof Never.NeverTrigger)) {
                builder.append(".withEarlyFirings(").append(this.earlyTrigger).append(")");
            }
            if (this.lateTrigger != null && !(this.lateTrigger instanceof Never.NeverTrigger)) {
                builder.append(".withLateFirings(").append(this.lateTrigger).append(")");
            }
            return builder.toString();
        }
    }
}

