/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.joda.time.Instant;

public abstract class BoundedWindow {
    public static final Instant TIMESTAMP_MIN_VALUE = BoundedWindow.extractTimestampFromProto(RunnerApi.BeamConstants.Constants.MIN_TIMESTAMP_MILLIS);
    public static final Instant TIMESTAMP_MAX_VALUE = BoundedWindow.extractTimestampFromProto(RunnerApi.BeamConstants.Constants.MAX_TIMESTAMP_MILLIS);

    public static String formatTimestamp(Instant timestamp) {
        if (timestamp.equals(TIMESTAMP_MIN_VALUE)) {
            return timestamp.toString() + " (TIMESTAMP_MIN_VALUE)";
        }
        if (timestamp.equals(TIMESTAMP_MAX_VALUE)) {
            return timestamp.toString() + " (TIMESTAMP_MAX_VALUE)";
        }
        if (timestamp.equals(GlobalWindow.INSTANCE.maxTimestamp())) {
            return timestamp.toString() + " (end of global window)";
        }
        return timestamp.toString();
    }

    public abstract Instant maxTimestamp();

    private static Instant extractTimestampFromProto(RunnerApi.BeamConstants.Constants constant) {
        return new Instant(Long.parseLong(constant.getValueDescriptor().getOptions().getExtension(RunnerApi.beamConstant)));
    }
}

