/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.joda.time.Instant;

public class GlobalWindow
extends BoundedWindow {
    public static final GlobalWindow INSTANCE = new GlobalWindow();
    private static final Instant END_OF_GLOBAL_WINDOW = GlobalWindow.extractMaxTimestampFromProto();

    @Override
    public Instant maxTimestamp() {
        return END_OF_GLOBAL_WINDOW;
    }

    public boolean equals(Object other) {
        return other instanceof GlobalWindow;
    }

    public int hashCode() {
        return GlobalWindow.class.hashCode();
    }

    private GlobalWindow() {
    }

    private static Instant extractMaxTimestampFromProto() {
        return new Instant(Long.parseLong(RunnerApi.BeamConstants.Constants.GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS.getValueDescriptor().getOptions().getExtension(RunnerApi.beamConstant)));
    }

    public static class Coder
    extends StructuredCoder<GlobalWindow> {
        public static final Coder INSTANCE = new Coder();

        @Override
        public void encode(GlobalWindow window, OutputStream outStream) {
        }

        @Override
        public GlobalWindow decode(InputStream inStream) {
            return INSTANCE;
        }

        @Override
        public void verifyDeterministic() {
        }

        @Override
        public boolean consistentWithEquals() {
            return true;
        }

        @Override
        public final List<org.apache.beam.sdk.coders.Coder<?>> getCoderArguments() {
            return Collections.emptyList();
        }

        private Coder() {
        }
    }
}

