/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.Collections;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Ordering;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.OUTPUT_TIME)
public enum TimestampCombiner {
    EARLIEST{

        @Override
        public Instant combine(Iterable<? extends Instant> timestamps) {
            return Ordering.natural().min(timestamps);
        }

        @Override
        public Instant merge(BoundedWindow intoWindow, Iterable<? extends Instant> mergingTimestamps) {
            return this.combine(mergingTimestamps);
        }

        @Override
        public boolean dependsOnlyOnEarliestTimestamp() {
            return true;
        }

        @Override
        public boolean dependsOnlyOnWindow() {
            return false;
        }
    }
    ,
    LATEST{

        @Override
        public Instant combine(Iterable<? extends Instant> timestamps) {
            return Ordering.natural().max(timestamps);
        }

        @Override
        public Instant merge(BoundedWindow intoWindow, Iterable<? extends Instant> mergingTimestamps) {
            return this.combine(mergingTimestamps);
        }

        @Override
        public boolean dependsOnlyOnEarliestTimestamp() {
            return false;
        }

        @Override
        public boolean dependsOnlyOnWindow() {
            return false;
        }
    }
    ,
    END_OF_WINDOW{

        @Override
        public Instant combine(Iterable<? extends Instant> timestamps) {
            Preconditions.checkArgument(Iterables.size(timestamps) > 0);
            return Iterables.get(timestamps, 0);
        }

        @Override
        public Instant merge(BoundedWindow intoWindow, Iterable<? extends Instant> mergingTimestamps) {
            return intoWindow.maxTimestamp();
        }

        @Override
        public boolean dependsOnlyOnEarliestTimestamp() {
            return false;
        }

        @Override
        public boolean dependsOnlyOnWindow() {
            return true;
        }
    };


    public abstract Instant combine(Iterable<? extends Instant> var1);

    public abstract Instant merge(BoundedWindow var1, Iterable<? extends Instant> var2);

    public final Instant assign(BoundedWindow intoWindow, Instant timestamp) {
        return this.merge(intoWindow, Collections.singleton(timestamp));
    }

    public final Instant combine(Instant ... timestamps) {
        return this.combine(Arrays.asList(timestamps));
    }

    public final Instant merge(BoundedWindow intoWindow, Instant ... timestamps) {
        return this.merge(intoWindow, Arrays.asList(timestamps));
    }

    public abstract boolean dependsOnlyOnEarliestTimestamp();

    public abstract boolean dependsOnlyOnWindow();
}

