/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.OrFinallyTrigger;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Joiner;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public abstract class Trigger
implements Serializable {
    @Nullable
    protected final List<Trigger> subTriggers;

    protected Trigger(@Nullable List<Trigger> subTriggers) {
        this.subTriggers = subTriggers;
    }

    protected Trigger() {
        this(Collections.emptyList());
    }

    public List<Trigger> subTriggers() {
        return this.subTriggers;
    }

    public Trigger getContinuationTrigger() {
        if (this.subTriggers == null) {
            return this.getContinuationTrigger(null);
        }
        ArrayList<Trigger> subTriggerContinuations = new ArrayList<Trigger>();
        for (Trigger subTrigger : this.subTriggers) {
            subTriggerContinuations.add(subTrigger.getContinuationTrigger());
        }
        return this.getContinuationTrigger(subTriggerContinuations);
    }

    @Nullable
    protected abstract Trigger getContinuationTrigger(@Nullable List<Trigger> var1);

    @Internal
    public abstract Instant getWatermarkThatGuaranteesFiring(BoundedWindow var1);

    @Internal
    public boolean isCompatible(Trigger other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        if (this.subTriggers == null) {
            return other.subTriggers == null;
        }
        if (other.subTriggers == null) {
            return false;
        }
        if (this.subTriggers.size() != other.subTriggers.size()) {
            return false;
        }
        for (int i = 0; i < this.subTriggers.size(); ++i) {
            if (this.subTriggers.get(i).isCompatible(other.subTriggers.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String simpleName = this.getClass().getSimpleName();
        if (this.getClass().getEnclosingClass() != null) {
            simpleName = this.getClass().getEnclosingClass().getSimpleName() + "." + simpleName;
        }
        if (this.subTriggers == null || this.subTriggers.isEmpty()) {
            return simpleName;
        }
        return simpleName + "(" + Joiner.on(", ").join(this.subTriggers) + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Trigger)) {
            return false;
        }
        Trigger that = (Trigger)obj;
        return Objects.equals(this.getClass(), that.getClass()) && Objects.equals(this.subTriggers, that.subTriggers);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.subTriggers);
    }

    public OrFinallyTrigger orFinally(OnceTrigger until) {
        return new OrFinallyTrigger(this, until);
    }

    @Internal
    public static abstract class OnceTrigger
    extends Trigger {
        protected OnceTrigger(@Nullable List<Trigger> subTriggers) {
            super(subTriggers);
        }

        @Override
        public final OnceTrigger getContinuationTrigger() {
            Trigger continuation = super.getContinuationTrigger();
            if (!(continuation instanceof OnceTrigger)) {
                throw new IllegalStateException("Continuation of a OnceTrigger must be a OnceTrigger");
            }
            return (OnceTrigger)continuation;
        }
    }
}

