/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.Serializable;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;

public class AppliedCombineFn<K, InputT, AccumT, OutputT>
implements Serializable {
    private final CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> fn;
    private final Coder<AccumT> accumulatorCoder;
    private final Iterable<PCollectionView<?>> sideInputViews;
    private final KvCoder<K, InputT> kvCoder;
    private final WindowingStrategy<?, ?> windowingStrategy;

    private AppliedCombineFn(CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> fn, Coder<AccumT> accumulatorCoder, Iterable<PCollectionView<?>> sideInputViews, KvCoder<K, InputT> kvCoder, WindowingStrategy<?, ?> windowingStrategy) {
        this.fn = fn;
        this.accumulatorCoder = accumulatorCoder;
        this.sideInputViews = sideInputViews;
        this.kvCoder = kvCoder;
        this.windowingStrategy = windowingStrategy;
    }

    public static <K, InputT, AccumT, OutputT> AppliedCombineFn<K, InputT, AccumT, OutputT> withAccumulatorCoder(CombineFnBase.GlobalCombineFn<? super InputT, AccumT, OutputT> fn, Coder<AccumT> accumCoder) {
        return AppliedCombineFn.withAccumulatorCoder(fn, accumCoder, null, null, null);
    }

    public static <K, InputT, AccumT, OutputT> AppliedCombineFn<K, InputT, AccumT, OutputT> withAccumulatorCoder(CombineFnBase.GlobalCombineFn<? super InputT, AccumT, OutputT> fn, Coder<AccumT> accumCoder, Iterable<PCollectionView<?>> sideInputViews, KvCoder<K, InputT> kvCoder, WindowingStrategy<?, ?> windowingStrategy) {
        CombineFnBase.GlobalCombineFn<? super InputT, AccumT, OutputT> clonedFn = SerializableUtils.clone(fn);
        return AppliedCombineFn.create(clonedFn, accumCoder, sideInputViews, kvCoder, windowingStrategy);
    }

    @VisibleForTesting
    public static <K, InputT, AccumT, OutputT> AppliedCombineFn<K, InputT, AccumT, OutputT> withInputCoder(CombineFnBase.GlobalCombineFn<? super InputT, AccumT, OutputT> fn, CoderRegistry registry, KvCoder<K, InputT> kvCoder) {
        return AppliedCombineFn.withInputCoder(fn, registry, kvCoder, null, null);
    }

    public static <K, InputT, AccumT, OutputT> AppliedCombineFn<K, InputT, AccumT, OutputT> withInputCoder(CombineFnBase.GlobalCombineFn<? super InputT, AccumT, OutputT> fn, CoderRegistry registry, KvCoder<K, InputT> kvCoder, Iterable<PCollectionView<?>> sideInputViews, WindowingStrategy<?, ?> windowingStrategy) {
        CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> clonedFn = SerializableUtils.clone(fn);
        try {
            Coder<AccumT> accumulatorCoder = clonedFn.getAccumulatorCoder(registry, kvCoder.getValueCoder());
            return AppliedCombineFn.create(clonedFn, accumulatorCoder, sideInputViews, kvCoder, windowingStrategy);
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalStateException("Could not determine coder for accumulator", e);
        }
    }

    private static <K, InputT, AccumT, OutputT> AppliedCombineFn<K, InputT, AccumT, OutputT> create(CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> fn, Coder<AccumT> accumulatorCoder, Iterable<PCollectionView<?>> sideInputViews, KvCoder<K, InputT> kvCoder, WindowingStrategy<?, ?> windowingStrategy) {
        return new AppliedCombineFn<K, InputT, AccumT, OutputT>(fn, accumulatorCoder, sideInputViews, kvCoder, windowingStrategy);
    }

    public CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> getFn() {
        return this.fn;
    }

    public Iterable<PCollectionView<?>> getSideInputViews() {
        return this.sideInputViews;
    }

    public Coder<AccumT> getAccumulatorCoder() {
        return this.accumulatorCoder;
    }

    public KvCoder<K, InputT> getKvCoder() {
        return this.kvCoder;
    }

    public WindowingStrategy<?, ?> getWindowingStrategy() {
        return this.windowingStrategy;
    }
}

