/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ExposedByteArrayOutputStream
extends ByteArrayOutputStream {
    private byte[] swappedBuffer;
    private boolean isFallback = false;

    private void fallback() {
        this.isFallback = true;
        if (this.swappedBuffer != null) {
            byte[] tempBuffer = this.buf;
            this.count = 0;
            this.buf = this.swappedBuffer;
            super.write(tempBuffer, 0, tempBuffer.length);
            this.swappedBuffer = null;
        }
    }

    public synchronized void writeAndOwn(byte[] b) throws IOException {
        if (b.length == 0) {
            return;
        }
        if (this.count == 0) {
            this.swappedBuffer = this.buf;
            this.buf = b;
            this.count = b.length;
        } else {
            this.fallback();
            super.write(b);
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.fallback();
        super.write(b, off, len);
    }

    @Override
    public synchronized void write(int b) {
        this.fallback();
        super.write(b);
    }

    @Override
    public synchronized byte[] toByteArray() {
        if (!this.isFallback && this.count > 0) {
            return this.buf;
        }
        return super.toByteArray();
    }

    @Override
    public synchronized void reset() {
        if (this.count == 0) {
            return;
        }
        this.count = 0;
        if (this.isFallback) {
            this.isFallback = false;
        } else {
            this.buf = this.swappedBuffer;
            this.swappedBuffer = null;
        }
    }
}

