/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.google.auto.value.AutoValue;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.util.AutoValue_MoreFutures_ExceptionOrResult;
import org.apache.beam.sdk.util.ThrowingRunnable;
import org.apache.beam.sdk.util.ThrowingSupplier;

public class MoreFutures {
    public static <T> T get(CompletionStage<T> future) throws InterruptedException, ExecutionException {
        return future.toCompletableFuture().get();
    }

    public static <T> T get(CompletionStage<T> future, long duration, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return future.toCompletableFuture().get(duration, unit);
    }

    public static boolean isDone(CompletionStage<?> future) {
        return future.toCompletableFuture().isDone();
    }

    public static boolean isCancelled(CompletionStage<?> future) {
        return future.toCompletableFuture().isCancelled();
    }

    public static <T> CompletionStage<T> supplyAsync(ThrowingSupplier<T> supplier, ExecutorService executorService) {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture<Void> wrapper = CompletableFuture.runAsync(() -> {
            try {
                result.complete(supplier.get());
            }
            catch (InterruptedException e) {
                result.completeExceptionally(e);
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        }, executorService);
        return wrapper.thenCompose(nothing -> result);
    }

    public static <T> CompletionStage<T> supplyAsync(ThrowingSupplier<T> supplier) {
        return MoreFutures.supplyAsync(supplier, ForkJoinPool.commonPool());
    }

    public static CompletionStage<Void> runAsync(ThrowingRunnable runnable, ExecutorService executorService) {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture<Void> wrapper = CompletableFuture.runAsync(() -> {
            try {
                runnable.run();
                result.complete(null);
            }
            catch (InterruptedException e) {
                result.completeExceptionally(e);
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        }, executorService);
        return wrapper.thenCompose(nothing -> result);
    }

    public static CompletionStage<Void> runAsync(ThrowingRunnable runnable) {
        return MoreFutures.runAsync(runnable, ForkJoinPool.commonPool());
    }

    public static <T> CompletionStage<List<T>> allAsList(Collection<? extends CompletionStage<? extends T>> futures) {
        CompletableFuture<Void> blockAndDiscard = CompletableFuture.allOf(MoreFutures.futuresToCompletableFutures(futures));
        return blockAndDiscard.thenApply(nothing -> futures.stream().map(future -> future.toCompletableFuture().join()).collect(Collectors.toList()));
    }

    public static <T> CompletionStage<List<ExceptionOrResult<T>>> allAsListWithExceptions(Collection<? extends CompletionStage<? extends T>> futures) {
        CompletionStage blockAndDiscard = CompletableFuture.allOf(MoreFutures.futuresToCompletableFutures(futures)).whenComplete((ignoredValues, arbitraryException) -> {});
        return blockAndDiscard.thenApply(nothing -> futures.stream().map(future -> {
            try {
                return ExceptionOrResult.result(future.toCompletableFuture().join());
            }
            catch (CompletionException exc) {
                return ExceptionOrResult.exception(exc);
            }
        }).collect(Collectors.toList()));
    }

    private static <T> CompletableFuture<? extends T>[] futuresToCompletableFutures(Collection<? extends CompletionStage<? extends T>> futures) {
        CompletableFuture[] completableFutures = new CompletableFuture[futures.size()];
        int i = 0;
        for (CompletionStage<T> future : futures) {
            completableFutures[i] = future.toCompletableFuture();
            ++i;
        }
        return completableFutures;
    }

    @SuppressWarnings(value={"NM_CLASS_NOT_EXCEPTION"}, justification="The class does hold an exception; its name is accurate.")
    @AutoValue
    public static abstract class ExceptionOrResult<T> {
        public abstract IsException isException();

        @Nullable
        public abstract T getResult();

        @Nullable
        public abstract Throwable getException();

        public static <T> ExceptionOrResult<T> exception(Throwable throwable) {
            return new AutoValue_MoreFutures_ExceptionOrResult<Object>(IsException.EXCEPTION, null, throwable);
        }

        public static <T> ExceptionOrResult<T> result(T result) {
            return new AutoValue_MoreFutures_ExceptionOrResult<T>(IsException.EXCEPTION, result, null);
        }

        public static enum IsException {
            EXCEPTION,
            RESULT;

        }
    }
}

