/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public class NameUtils {
    private static final String[] STANDARD_NAME_SUFFIXES = new String[]{"DoFn", "CombineFn", "Fn"};
    private static final Pattern NAMED_INNER_CLASS = Pattern.compile(".+\\$(?<INNER>[^0-9].*)");
    private static final String ANONYMOUS_CLASS_REGEX = "\\$[0-9]+\\$";

    private static String approximateSimpleName(Class<?> clazz, boolean dropOuterClassNames) {
        Preconditions.checkArgument(!clazz.isAnonymousClass(), "Attempted to get simple name of anonymous class");
        return NameUtils.approximateSimpleName(clazz.getName(), dropOuterClassNames);
    }

    @VisibleForTesting
    static String approximateSimpleName(String fullName, boolean dropOuterClassNames) {
        String shortName = fullName.substring(fullName.lastIndexOf(46) + 1);
        Object[] names = shortName.split("\\$");
        for (int i = 0; i < names.length; ++i) {
            names[i] = NameUtils.simplifyNameComponent((String)names[i]);
        }
        shortName = Joiner.on('$').join(names);
        if (dropOuterClassNames) {
            Matcher m = NAMED_INNER_CLASS.matcher(shortName);
            if (m.matches()) {
                shortName = m.group("INNER");
            }
        } else {
            shortName = shortName.replaceAll(ANONYMOUS_CLASS_REGEX, ".");
            shortName = shortName.replaceAll("\\$", ".");
        }
        return shortName;
    }

    private static String simplifyNameComponent(String name) {
        for (String suffix : STANDARD_NAME_SUFFIXES) {
            if (!name.endsWith(suffix) || name.length() <= suffix.length()) continue;
            return name.substring(0, name.length() - suffix.length());
        }
        return name;
    }

    public static String approximateSimpleName(Object object) {
        return NameUtils.approximateSimpleName(object, "Anonymous");
    }

    public static String approximateSimpleName(Object object, String anonymousValue) {
        if (object instanceof NameOverride) {
            return ((NameOverride)object).getNameOverride();
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        if (clazz.isAnonymousClass()) {
            return anonymousValue;
        }
        return NameUtils.approximateSimpleName(clazz, true);
    }

    public static String approximatePTransformName(Class<?> clazz) {
        Preconditions.checkArgument(PTransform.class.isAssignableFrom(clazz));
        if (clazz.getSimpleName().startsWith("AutoValue_")) {
            return NameUtils.approximatePTransformName(clazz.getSuperclass());
        }
        return NameUtils.approximateSimpleName(clazz, false).replaceFirst("\\.Bound$", "");
    }

    public static interface NameOverride {
        public String getNameOverride();
    }
}

