/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.beam.sdk.util.AutoValue_ReleaseInfo;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
public abstract class ReleaseInfo
implements Serializable {
    private static final String PROPERTIES_PATH = "/org/apache/beam/sdk/sdk.properties";
    private static final Logger LOG = LoggerFactory.getLogger(ReleaseInfo.class);
    private static final String DEFAULT_NAME = "Apache Beam SDK for Java";
    private static final String DEFAULT_VERSION = "Unknown";

    public static ReleaseInfo getReleaseInfo() {
        return LazyInit.INSTANCE;
    }

    public abstract Map<String, String> getProperties();

    public String getName() {
        return this.getProperties().get("name");
    }

    public String getVersion() {
        return this.getProperties().get("version");
    }

    private static class LazyInit {
        private static final ReleaseInfo INSTANCE;

        private LazyInit() {
        }

        static {
            Properties properties = new Properties();
            try (InputStream in = ReleaseInfo.class.getResourceAsStream(ReleaseInfo.PROPERTIES_PATH);){
                if (in == null) {
                    LOG.warn("Beam properties resource not found: {}", (Object)ReleaseInfo.PROPERTIES_PATH);
                } else {
                    properties.load(in);
                }
            }
            catch (IOException e) {
                LOG.warn("Error loading Beam properties resource: ", e);
            }
            if (!properties.containsKey("name")) {
                properties.setProperty("name", ReleaseInfo.DEFAULT_NAME);
            }
            if (!properties.containsKey("version")) {
                properties.setProperty("version", ReleaseInfo.DEFAULT_VERSION);
            }
            INSTANCE = new AutoValue_ReleaseInfo(ImmutableMap.copyOf(properties));
        }
    }
}

