/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.RowJsonDeserializer;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableSet;

class RowJsonValidation {
    private static final ImmutableSet<Schema.TypeName> SUPPORTED_TYPES = ImmutableSet.of(Schema.TypeName.BYTE, Schema.TypeName.INT16, Schema.TypeName.INT32, Schema.TypeName.INT64, Schema.TypeName.FLOAT, Schema.TypeName.DOUBLE, new Schema.TypeName[]{Schema.TypeName.BOOLEAN, Schema.TypeName.STRING, Schema.TypeName.DECIMAL});

    RowJsonValidation() {
    }

    static void verifyFieldTypeSupported(Schema.Field field) {
        Schema.FieldType fieldType = field.getType();
        RowJsonValidation.verifyFieldTypeSupported(fieldType);
    }

    static void verifyFieldTypeSupported(Schema.FieldType fieldType) {
        Schema.TypeName fieldTypeName = fieldType.getTypeName();
        if (fieldTypeName.isCompositeType()) {
            Schema rowFieldSchema = fieldType.getRowSchema();
            rowFieldSchema.getFields().forEach(RowJsonValidation::verifyFieldTypeSupported);
            return;
        }
        if (fieldTypeName.isCollectionType()) {
            RowJsonValidation.verifyFieldTypeSupported(fieldType.getCollectionElementType());
            return;
        }
        if (!SUPPORTED_TYPES.contains((Object)fieldTypeName)) {
            throw new RowJsonDeserializer.UnsupportedRowJsonException(fieldTypeName.name() + " is not supported when converting JSON objects to Rows. Supported types are: " + SUPPORTED_TYPES.toString());
        }
    }
}

