/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class SerializableThrowable
implements Serializable {
    @Nullable
    private final Throwable throwable;
    @Nullable
    private final StackTraceElement[] stackTrace;

    public SerializableThrowable(@Nullable Throwable t) {
        this.throwable = t;
        this.stackTrace = t == null ? null : t.getStackTrace();
    }

    @Nullable
    public Throwable getThrowable() {
        return this.throwable;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        if (this.throwable != null) {
            this.throwable.setStackTrace(this.stackTrace);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializableThrowable that = (SerializableThrowable)o;
        return Arrays.equals(this.stackTrace, that.stackTrace);
    }

    public int hashCode() {
        return Arrays.hashCode(this.stackTrace);
    }
}

