/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CollectionCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.joda.time.Instant;

public abstract class WindowedValue<T> {
    private static final Collection<? extends BoundedWindow> GLOBAL_WINDOWS = Collections.singletonList(GlobalWindow.INSTANCE);

    public static <T> WindowedValue<T> of(T value, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
        Preconditions.checkArgument(pane != null, "WindowedValue requires PaneInfo, but it was null");
        Preconditions.checkArgument(windows.size() > 0, "WindowedValue requires windows, but there were none");
        if (windows.size() == 1) {
            return WindowedValue.of(value, timestamp, windows.iterator().next(), pane);
        }
        return new TimestampedValueInMultipleWindows<T>(value, timestamp, windows, pane);
    }

    @Deprecated
    static <T> WindowedValue<T> createWithoutValidation(T value, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
        if (windows.size() == 1) {
            return WindowedValue.of(value, timestamp, windows.iterator().next(), pane);
        }
        return new TimestampedValueInMultipleWindows<T>(value, timestamp, windows, pane);
    }

    public static <T> WindowedValue<T> of(T value, Instant timestamp, BoundedWindow window, PaneInfo pane) {
        Preconditions.checkArgument(pane != null, "WindowedValue requires PaneInfo, but it was null");
        boolean isGlobal = GlobalWindow.INSTANCE.equals(window);
        if (isGlobal && BoundedWindow.TIMESTAMP_MIN_VALUE.equals(timestamp)) {
            return WindowedValue.valueInGlobalWindow(value, pane);
        }
        if (isGlobal) {
            return new TimestampedValueInGlobalWindow<T>(value, timestamp, pane);
        }
        return new TimestampedValueInSingleWindow<T>(value, timestamp, window, pane);
    }

    public static <T> WindowedValue<T> valueInGlobalWindow(T value) {
        return new ValueInGlobalWindow<T>(value, PaneInfo.NO_FIRING);
    }

    public static <T> WindowedValue<T> valueInGlobalWindow(T value, PaneInfo pane) {
        return new ValueInGlobalWindow<T>(value, pane);
    }

    public static <T> WindowedValue<T> timestampedValueInGlobalWindow(T value, Instant timestamp) {
        if (BoundedWindow.TIMESTAMP_MIN_VALUE.equals(timestamp)) {
            return WindowedValue.valueInGlobalWindow(value);
        }
        return new TimestampedValueInGlobalWindow<T>(value, timestamp, PaneInfo.NO_FIRING);
    }

    public abstract <NewT> WindowedValue<NewT> withValue(NewT var1);

    public abstract T getValue();

    public abstract Instant getTimestamp();

    public abstract Collection<? extends BoundedWindow> getWindows();

    public abstract PaneInfo getPane();

    public Iterable<WindowedValue<T>> explodeWindows() {
        ImmutableList.Builder windowedValues = ImmutableList.builder();
        for (BoundedWindow w : this.getWindows()) {
            windowedValues.add(WindowedValue.of(this.getValue(), this.getTimestamp(), w, this.getPane()));
        }
        return windowedValues.build();
    }

    public boolean equals(Object other) {
        if (!(other instanceof WindowedValue)) {
            return false;
        }
        WindowedValue that = (WindowedValue)other;
        return this.getTimestamp().isEqual(that.getTimestamp()) && Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getWindows(), that.getWindows()) && Objects.equals(this.getPane(), that.getPane());
    }

    public int hashCode() {
        return Objects.hash(this.getValue(), this.getTimestamp().getMillis(), this.getWindows(), this.getPane());
    }

    public abstract String toString();

    public static <T> FullWindowedValueCoder<T> getFullCoder(Coder<T> valueCoder, Coder<? extends BoundedWindow> windowCoder) {
        return FullWindowedValueCoder.of(valueCoder, windowCoder);
    }

    public static <T> ValueOnlyWindowedValueCoder<T> getValueOnlyCoder(Coder<T> valueCoder) {
        return ValueOnlyWindowedValueCoder.of(valueCoder);
    }

    public static class ValueOnlyWindowedValueCoder<T>
    extends WindowedValueCoder<T> {
        public static <T> ValueOnlyWindowedValueCoder<T> of(Coder<T> valueCoder) {
            return new ValueOnlyWindowedValueCoder<T>(valueCoder);
        }

        ValueOnlyWindowedValueCoder(Coder<T> valueCoder) {
            super(valueCoder);
        }

        @Override
        public <NewT> WindowedValueCoder<NewT> withValueCoder(Coder<NewT> valueCoder) {
            return new ValueOnlyWindowedValueCoder<NewT>(valueCoder);
        }

        @Override
        public void encode(WindowedValue<T> windowedElem, OutputStream outStream) throws CoderException, IOException {
            this.encode(windowedElem, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(WindowedValue<T> windowedElem, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            this.valueCoder.encode(windowedElem.getValue(), outStream, context);
        }

        @Override
        public WindowedValue<T> decode(InputStream inStream) throws CoderException, IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public WindowedValue<T> decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            Object value = this.valueCoder.decode(inStream, context);
            return WindowedValue.valueInGlobalWindow(value);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            ValueOnlyWindowedValueCoder.verifyDeterministic(this, "ValueOnlyWindowedValueCoder requires a deterministic valueCoder", this.valueCoder);
        }

        @Override
        public void registerByteSizeObserver(WindowedValue<T> value, ElementByteSizeObserver observer) throws Exception {
            this.valueCoder.registerByteSizeObserver(value.getValue(), observer);
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Collections.singletonList(this.valueCoder);
        }
    }

    public static class FullWindowedValueCoder<T>
    extends WindowedValueCoder<T> {
        private final Coder<? extends BoundedWindow> windowCoder;
        private final Coder<Collection<? extends BoundedWindow>> windowsCoder;

        public static <T> FullWindowedValueCoder<T> of(Coder<T> valueCoder, Coder<? extends BoundedWindow> windowCoder) {
            return new FullWindowedValueCoder<T>(valueCoder, windowCoder);
        }

        FullWindowedValueCoder(Coder<T> valueCoder, Coder<? extends BoundedWindow> windowCoder) {
            super(valueCoder);
            this.windowCoder = Preconditions.checkNotNull(windowCoder);
            CollectionCoder<? extends BoundedWindow> collectionCoder = CollectionCoder.of(this.windowCoder);
            this.windowsCoder = collectionCoder;
        }

        public Coder<? extends BoundedWindow> getWindowCoder() {
            return this.windowCoder;
        }

        public Coder<Collection<? extends BoundedWindow>> getWindowsCoder() {
            return this.windowsCoder;
        }

        @Override
        public <NewT> WindowedValueCoder<NewT> withValueCoder(Coder<NewT> valueCoder) {
            return new FullWindowedValueCoder<NewT>(valueCoder, this.windowCoder);
        }

        @Override
        public void encode(WindowedValue<T> windowedElem, OutputStream outStream) throws CoderException, IOException {
            this.encode(windowedElem, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(WindowedValue<T> windowedElem, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            InstantCoder.of().encode(windowedElem.getTimestamp(), outStream);
            this.windowsCoder.encode(windowedElem.getWindows(), outStream);
            PaneInfo.PaneInfoCoder.INSTANCE.encode(windowedElem.getPane(), outStream);
            this.valueCoder.encode(windowedElem.getValue(), outStream, context);
        }

        @Override
        public WindowedValue<T> decode(InputStream inStream) throws CoderException, IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public WindowedValue<T> decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            Instant timestamp = InstantCoder.of().decode(inStream);
            Collection<? extends BoundedWindow> windows = this.windowsCoder.decode(inStream);
            PaneInfo pane = PaneInfo.PaneInfoCoder.INSTANCE.decode(inStream);
            Object value = this.valueCoder.decode(inStream, context);
            return WindowedValue.createWithoutValidation(value, timestamp, windows, pane);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            FullWindowedValueCoder.verifyDeterministic(this, "FullWindowedValueCoder requires a deterministic valueCoder", this.valueCoder);
            FullWindowedValueCoder.verifyDeterministic(this, "FullWindowedValueCoder requires a deterministic windowCoder", this.windowCoder);
        }

        @Override
        public void registerByteSizeObserver(WindowedValue<T> value, ElementByteSizeObserver observer) throws Exception {
            InstantCoder.of().registerByteSizeObserver(value.getTimestamp(), observer);
            this.windowsCoder.registerByteSizeObserver(value.getWindows(), observer);
            PaneInfo.PaneInfoCoder.INSTANCE.registerByteSizeObserver(value.getPane(), observer);
            this.valueCoder.registerByteSizeObserver(value.getValue(), observer);
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Collections.singletonList(this.valueCoder);
        }

        @Override
        public List<? extends Coder<?>> getComponents() {
            return Arrays.asList(this.valueCoder, this.windowCoder);
        }
    }

    public static abstract class WindowedValueCoder<T>
    extends StructuredCoder<WindowedValue<T>> {
        final Coder<T> valueCoder;

        WindowedValueCoder(Coder<T> valueCoder) {
            this.valueCoder = Preconditions.checkNotNull(valueCoder);
        }

        public Coder<T> getValueCoder() {
            return this.valueCoder;
        }

        public abstract <NewT> WindowedValueCoder<NewT> withValueCoder(Coder<NewT> var1);
    }

    private static class TimestampedValueInMultipleWindows<T>
    extends TimestampedWindowedValue<T> {
        private Collection<? extends BoundedWindow> windows;

        public TimestampedValueInMultipleWindows(T value, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
            super(value, timestamp, pane);
            this.windows = Preconditions.checkNotNull(windows);
        }

        @Override
        public <NewT> WindowedValue<NewT> withValue(NewT newValue) {
            return new TimestampedValueInMultipleWindows<NewT>(newValue, this.getTimestamp(), this.windows, this.getPane());
        }

        @Override
        public Collection<? extends BoundedWindow> getWindows() {
            return this.windows;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof TimestampedValueInMultipleWindows) {
                TimestampedValueInMultipleWindows that = (TimestampedValueInMultipleWindows)o;
                if (this.getTimestamp().isEqual(that.getTimestamp()) && Objects.equals(that.getValue(), this.getValue()) && Objects.equals(that.getPane(), this.getPane())) {
                    this.ensureWindowsAreASet();
                    that.ensureWindowsAreASet();
                    return that.windows.equals(this.windows);
                }
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            this.ensureWindowsAreASet();
            return Objects.hash(this.getValue(), this.getTimestamp().getMillis(), this.getPane(), this.windows);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.getValue()).add("timestamp", this.getTimestamp()).add("windows", this.windows).add("pane", this.getPane()).toString();
        }

        private void ensureWindowsAreASet() {
            if (!(this.windows instanceof Set)) {
                this.windows = new LinkedHashSet<BoundedWindow>(this.windows);
            }
        }
    }

    private static class TimestampedValueInSingleWindow<T>
    extends TimestampedWindowedValue<T> {
        private final BoundedWindow window;

        public TimestampedValueInSingleWindow(T value, Instant timestamp, BoundedWindow window, PaneInfo pane) {
            super(value, timestamp, pane);
            this.window = Preconditions.checkNotNull(window);
        }

        @Override
        public <NewT> WindowedValue<NewT> withValue(NewT newValue) {
            return new TimestampedValueInSingleWindow<NewT>(newValue, this.getTimestamp(), this.window, this.getPane());
        }

        @Override
        public Collection<? extends BoundedWindow> getWindows() {
            return Collections.singletonList(this.window);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof TimestampedValueInSingleWindow) {
                TimestampedValueInSingleWindow that = (TimestampedValueInSingleWindow)o;
                return this.getTimestamp().isEqual(that.getTimestamp()) && Objects.equals(that.getValue(), this.getValue()) && Objects.equals(that.getPane(), this.getPane()) && Objects.equals(that.window, this.window);
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getValue(), this.getTimestamp().getMillis(), this.getPane(), this.window);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.getValue()).add("timestamp", this.getTimestamp()).add("window", this.window).add("pane", this.getPane()).toString();
        }
    }

    private static class TimestampedValueInGlobalWindow<T>
    extends TimestampedWindowedValue<T> {
        public TimestampedValueInGlobalWindow(T value, Instant timestamp, PaneInfo pane) {
            super(value, timestamp, pane);
        }

        @Override
        public <NewT> WindowedValue<NewT> withValue(NewT newValue) {
            return new TimestampedValueInGlobalWindow<NewT>(newValue, this.getTimestamp(), this.getPane());
        }

        @Override
        public Collection<? extends BoundedWindow> getWindows() {
            return GLOBAL_WINDOWS;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof TimestampedValueInGlobalWindow) {
                TimestampedValueInGlobalWindow that = (TimestampedValueInGlobalWindow)o;
                return this.getTimestamp().isEqual(that.getTimestamp()) && Objects.equals(that.getPane(), this.getPane()) && Objects.equals(that.getValue(), this.getValue());
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getValue(), this.getPane(), this.getTimestamp().getMillis());
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.getValue()).add("timestamp", this.getTimestamp()).add("pane", this.getPane()).toString();
        }
    }

    private static abstract class TimestampedWindowedValue<T>
    extends SimpleWindowedValue<T> {
        private final Instant timestamp;

        public TimestampedWindowedValue(T value, Instant timestamp, PaneInfo pane) {
            super(value, pane);
            this.timestamp = Preconditions.checkNotNull(timestamp);
        }

        @Override
        public Instant getTimestamp() {
            return this.timestamp;
        }
    }

    private static class ValueInGlobalWindow<T>
    extends MinTimestampWindowedValue<T> {
        public ValueInGlobalWindow(T value, PaneInfo pane) {
            super(value, pane);
        }

        @Override
        public <NewT> WindowedValue<NewT> withValue(NewT newValue) {
            return new ValueInGlobalWindow<NewT>(newValue, this.getPane());
        }

        @Override
        public Collection<? extends BoundedWindow> getWindows() {
            return GLOBAL_WINDOWS;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ValueInGlobalWindow) {
                ValueInGlobalWindow that = (ValueInGlobalWindow)o;
                return Objects.equals(that.getPane(), this.getPane()) && Objects.equals(that.getValue(), this.getValue());
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getValue(), this.getPane());
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.getValue()).add("pane", this.getPane()).toString();
        }
    }

    private static abstract class MinTimestampWindowedValue<T>
    extends SimpleWindowedValue<T> {
        public MinTimestampWindowedValue(T value, PaneInfo pane) {
            super(value, pane);
        }

        @Override
        public Instant getTimestamp() {
            return BoundedWindow.TIMESTAMP_MIN_VALUE;
        }
    }

    private static abstract class SimpleWindowedValue<T>
    extends WindowedValue<T> {
        private final T value;
        private final PaneInfo pane;

        protected SimpleWindowedValue(T value, PaneInfo pane) {
            this.value = value;
            this.pane = Preconditions.checkNotNull(pane);
        }

        @Override
        public PaneInfo getPane() {
            return this.pane;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }
}

