/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Queues;

public class ReflectHelpers {
    private static final Joiner COMMA_SEPARATOR = Joiner.on(", ");
    public static final Function<Method, String> METHOD_FORMATTER = new Function<Method, String>(){

        @Override
        public String apply(@Nonnull Method input) {
            String parameterTypes = FluentIterable.from(Arrays.asList(input.getParameterTypes())).transform(CLASS_SIMPLE_NAME).join(COMMA_SEPARATOR);
            return String.format("%s(%s)", input.getName(), parameterTypes);
        }
    };
    public static final Function<Method, String> CLASS_AND_METHOD_FORMATTER = new Function<Method, String>(){

        @Override
        public String apply(@Nonnull Method input) {
            return String.format("%s#%s", CLASS_NAME.apply(input.getDeclaringClass()), METHOD_FORMATTER.apply(input));
        }
    };
    public static final Function<Class<?>, String> CLASS_NAME = Class::getName;
    public static final Function<Class<?>, String> CLASS_SIMPLE_NAME = Class::getSimpleName;
    public static final Function<Annotation, String> ANNOTATION_FORMATTER = annotation -> {
        String annotationName = annotation.annotationType().getName();
        String annotationNameWithoutPackage = annotationName.substring(annotationName.lastIndexOf(46) + 1).replace('$', '.');
        String annotationToString = annotation.toString();
        String values = annotationToString.substring(annotationToString.indexOf(40));
        return String.format("%s%s", annotationNameWithoutPackage, values);
    };
    public static final Function<Type, String> TYPE_SIMPLE_DESCRIPTION = new Function<Type, String>(){

        @Override
        @Nullable
        public String apply(@Nonnull Type input) {
            StringBuilder builder = new StringBuilder();
            this.format(builder, input);
            return builder.toString();
        }

        private void format(StringBuilder builder, Type t) {
            if (t instanceof Class) {
                this.formatClass(builder, (Class)t);
            } else if (t instanceof TypeVariable) {
                this.formatTypeVariable(builder, (TypeVariable)t);
            } else if (t instanceof WildcardType) {
                this.formatWildcardType(builder, (WildcardType)t);
            } else if (t instanceof ParameterizedType) {
                this.formatParameterizedType(builder, (ParameterizedType)t);
            } else if (t instanceof GenericArrayType) {
                this.formatGenericArrayType(builder, (GenericArrayType)t);
            } else {
                builder.append(t.toString());
            }
        }

        private void formatClass(StringBuilder builder, Class<?> clazz) {
            builder.append(clazz.getSimpleName());
        }

        private void formatTypeVariable(StringBuilder builder, TypeVariable<?> t) {
            builder.append(t.getName());
        }

        private void formatWildcardType(StringBuilder builder, WildcardType t) {
            builder.append("?");
            for (Type lowerBound : t.getLowerBounds()) {
                builder.append(" super ");
                this.format(builder, lowerBound);
            }
            for (Type upperBound : t.getUpperBounds()) {
                if (Object.class.equals((Object)upperBound)) continue;
                builder.append(" extends ");
                this.format(builder, upperBound);
            }
        }

        private void formatParameterizedType(StringBuilder builder, ParameterizedType t) {
            if (t.getOwnerType() != null) {
                this.format(builder, t.getOwnerType());
                builder.append('.');
            }
            this.format(builder, t.getRawType());
            if (t.getActualTypeArguments().length > 0) {
                builder.append('<');
                COMMA_SEPARATOR.appendTo(builder, (Iterable<?>)FluentIterable.from(Arrays.asList(t.getActualTypeArguments())).transform(TYPE_SIMPLE_DESCRIPTION));
                builder.append('>');
            }
        }

        private void formatGenericArrayType(StringBuilder builder, GenericArrayType t) {
            this.format(builder, t.getGenericComponentType());
            builder.append("[]");
        }
    };

    public static Iterable<Method> getClosureOfMethodsOnInterfaces(Iterable<? extends Class<?>> interfaces) {
        return FluentIterable.from(interfaces).transformAndConcat(ReflectHelpers::getClosureOfMethodsOnInterface);
    }

    public static Iterable<Method> getClosureOfMethodsOnInterface(Class<?> iface) {
        Preconditions.checkNotNull(iface);
        Preconditions.checkArgument(iface.isInterface());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ArrayDeque<Class<?>> interfacesToProcess = Queues.newArrayDeque();
        interfacesToProcess.add(iface);
        while (!interfacesToProcess.isEmpty()) {
            Class current = (Class)interfacesToProcess.remove();
            builder.add(current.getMethods());
            interfacesToProcess.addAll(Arrays.asList(current.getInterfaces()));
        }
        return builder.build();
    }

    public static ClassLoader findClassLoader(ClassLoader proposed) {
        ClassLoader classLoader = proposed;
        if (classLoader == null) {
            classLoader = ReflectHelpers.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static ClassLoader findClassLoader(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            throw new IllegalArgumentException("set of classes can't be null");
        }
        ClassLoader current = null;
        for (Class<?> clazz : classes) {
            ClassLoader proposed = clazz.getClassLoader();
            if (proposed == null) continue;
            if (current == null) {
                current = proposed;
                continue;
            }
            if (proposed == current || !ReflectHelpers.isParent(current, proposed)) continue;
            current = proposed;
        }
        return current == null ? ClassLoader.getSystemClassLoader() : current;
    }

    public static ClassLoader findClassLoader() {
        return ReflectHelpers.findClassLoader(Thread.currentThread().getContextClassLoader());
    }

    private static boolean isParent(ClassLoader current, ClassLoader proposed) {
        ArrayList<ClassLoader> visited = new ArrayList<ClassLoader>();
        for (ClassLoader it = proposed.getParent(); it != null; it = it.getParent()) {
            if (it == current) {
                return true;
            }
            if (visited.contains(it)) {
                return false;
            }
            visited.add(it);
        }
        return false;
    }

    public static class ObjectsClassComparator
    implements Comparator<Object> {
        public static final ObjectsClassComparator INSTANCE = new ObjectsClassComparator();

        @Override
        public int compare(Object o1, Object o2) {
            return o1.getClass().getCanonicalName().compareTo(o2.getClass().getCanonicalName());
        }
    }
}

