/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.transforms.SerializableComparator;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;

public class KV<K, V>
implements Serializable {
    @Nullable
    final K key;
    @Nullable
    final V value;

    public static <K, V> KV<K, V> of(@Nullable K key, @Nullable V value) {
        return new KV<K, V>(key, value);
    }

    @Nullable
    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    private KV(@Nullable K key, @Nullable V value) {
        this.key = key;
        this.value = value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KV)) {
            return false;
        }
        KV otherKv = (KV)other;
        return Objects.deepEquals(this.key, otherKv.key) && Objects.deepEquals(this.value, otherKv.value);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.key, this.value});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.key).addValue(this.value).toString();
    }

    public static class OrderByValue<K, V extends Comparable<? super V>>
    implements SerializableComparator<KV<K, V>> {
        @Override
        public int compare(KV<K, V> a, KV<K, V> b) {
            if (a.value == null) {
                return b.value == null ? 0 : -1;
            }
            if (b.value == null) {
                return 1;
            }
            return ((Comparable)a.value).compareTo(b.value);
        }
    }

    public static class OrderByKey<K extends Comparable<? super K>, V>
    implements SerializableComparator<KV<K, V>> {
        @Override
        public int compare(KV<K, V> a, KV<K, V> b) {
            if (a.key == null) {
                return b.key == null ? 0 : -1;
            }
            if (b.key == null) {
                return 1;
            }
            return ((Comparable)a.key).compareTo(b.key);
        }
    }
}

