/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.Serializable;
import java.util.Random;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.HashMultiset;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Multiset;

public class TupleTag<V>
implements Serializable {
    static final Random RANDOM = new Random(0L);
    private static final Multiset<String> staticInits = HashMultiset.create();
    final String id;
    final boolean generated;

    public TupleTag() {
        this(TupleTag.genId(), true);
    }

    public TupleTag(String id) {
        this(id, false);
    }

    public String getId() {
        return this.id;
    }

    public String getOutName(int outIndex) {
        if (this.generated) {
            return "out" + outIndex;
        }
        return this.id;
    }

    public TypeDescriptor<V> getTypeDescriptor() {
        return new TypeDescriptor<V>(this.getClass()){};
    }

    static synchronized String genId() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement frame : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!"<clinit>".equals(frame.getMethodName())) continue;
            int counter = staticInits.add(frame.getClassName(), 1);
            return frame.getClassName() + "#" + counter;
        }
        String nonce = Long.toHexString(RANDOM.nextLong());
        String caller = stackTrace.length >= 4 ? stackTrace[3].getClassName() + "." + stackTrace[3].getMethodName() + ":" + stackTrace[3].getLineNumber() : "unknown";
        return caller + "#" + nonce;
    }

    private TupleTag(String id, boolean generated) {
        this.id = id;
        this.generated = generated;
    }

    public boolean equals(Object that) {
        if (that instanceof TupleTag) {
            return this.id.equals(((TupleTag)that).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Tag<" + this.id + ">";
    }
}

