/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;

@Internal
public class ValueWithRecordId<ValueT> {
    private final ValueT value;
    private final byte[] id;

    public ValueWithRecordId(ValueT value, byte[] id) {
        this.value = value;
        this.id = id;
    }

    public ValueT getValue() {
        return this.value;
    }

    public byte[] getId() {
        return this.id;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("value", this.value).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValueWithRecordId)) {
            return false;
        }
        ValueWithRecordId otherRecord = (ValueWithRecordId)other;
        return Objects.deepEquals(this.id, otherRecord.id) && Objects.deepEquals(this.value, otherRecord.value);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.id), this.value);
    }

    public static class StripIdsDoFn<T>
    extends DoFn<ValueWithRecordId<T>, T> {
        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output(((ValueWithRecordId)c.element()).getValue());
        }
    }

    public static class ValueWithRecordIdCoder<ValueT>
    extends StructuredCoder<ValueWithRecordId<ValueT>> {
        Coder<ValueT> valueCoder;
        ByteArrayCoder idCoder;

        public static <ValueT> ValueWithRecordIdCoder<ValueT> of(Coder<ValueT> valueCoder) {
            return new ValueWithRecordIdCoder<ValueT>(valueCoder);
        }

        protected ValueWithRecordIdCoder(Coder<ValueT> valueCoder) {
            this.valueCoder = valueCoder;
            this.idCoder = ByteArrayCoder.of();
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.valueCoder);
        }

        @Override
        public void encode(ValueWithRecordId<ValueT> value, OutputStream outStream) throws IOException {
            this.encode(value, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(ValueWithRecordId<ValueT> value, OutputStream outStream, Coder.Context context) throws IOException {
            this.valueCoder.encode(((ValueWithRecordId)value).value, outStream);
            this.idCoder.encode(((ValueWithRecordId)value).id, outStream, context);
        }

        @Override
        public ValueWithRecordId<ValueT> decode(InputStream inStream) throws IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public ValueWithRecordId<ValueT> decode(InputStream inStream, Coder.Context context) throws IOException {
            return new ValueWithRecordId<ValueT>(this.valueCoder.decode(inStream), this.idCoder.decode(inStream, context));
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.valueCoder.verifyDeterministic();
        }

        public Coder<ValueT> getValueCoder() {
            return this.valueCoder;
        }
    }
}

