/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.joda.time.Duration;

public class WindowingStrategy<T, W extends BoundedWindow>
implements Serializable {
    private static final Duration DEFAULT_ALLOWED_LATENESS = Duration.ZERO;
    private static final WindowingStrategy<Object, GlobalWindow> DEFAULT = WindowingStrategy.of(new GlobalWindows());
    private final WindowFn<T, W> windowFn;
    private final Trigger trigger;
    private final AccumulationMode mode;
    private final Duration allowedLateness;
    private final Window.ClosingBehavior closingBehavior;
    private final Window.OnTimeBehavior onTimeBehavior;
    private final TimestampCombiner timestampCombiner;
    private final boolean triggerSpecified;
    private final boolean modeSpecified;
    private final boolean allowedLatenessSpecified;
    private final boolean timestampCombinerSpecified;

    private WindowingStrategy(WindowFn<T, W> windowFn, Trigger trigger, boolean triggerSpecified, AccumulationMode mode, boolean modeSpecified, Duration allowedLateness, boolean allowedLatenessSpecified, TimestampCombiner timestampCombiner, boolean timestampCombinerSpecified, Window.ClosingBehavior closingBehavior, Window.OnTimeBehavior onTimeBehavior) {
        this.windowFn = windowFn;
        this.trigger = trigger;
        this.triggerSpecified = triggerSpecified;
        this.mode = mode;
        this.modeSpecified = modeSpecified;
        this.allowedLateness = allowedLateness;
        this.allowedLatenessSpecified = allowedLatenessSpecified;
        this.closingBehavior = closingBehavior;
        this.onTimeBehavior = onTimeBehavior;
        this.timestampCombiner = timestampCombiner;
        this.timestampCombinerSpecified = timestampCombinerSpecified;
    }

    public static WindowingStrategy<Object, GlobalWindow> globalDefault() {
        return DEFAULT;
    }

    public static <T, W extends BoundedWindow> WindowingStrategy<T, W> of(WindowFn<T, W> windowFn) {
        return new WindowingStrategy<T, W>(windowFn, DefaultTrigger.of(), false, AccumulationMode.DISCARDING_FIRED_PANES, false, DEFAULT_ALLOWED_LATENESS, false, TimestampCombiner.END_OF_WINDOW, false, Window.ClosingBehavior.FIRE_IF_NON_EMPTY, Window.OnTimeBehavior.FIRE_ALWAYS);
    }

    public WindowFn<T, W> getWindowFn() {
        return this.windowFn;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public boolean isTriggerSpecified() {
        return this.triggerSpecified;
    }

    public Duration getAllowedLateness() {
        return this.allowedLateness;
    }

    public boolean isAllowedLatenessSpecified() {
        return this.allowedLatenessSpecified;
    }

    public AccumulationMode getMode() {
        return this.mode;
    }

    public boolean isModeSpecified() {
        return this.modeSpecified;
    }

    public Window.ClosingBehavior getClosingBehavior() {
        return this.closingBehavior;
    }

    public Window.OnTimeBehavior getOnTimeBehavior() {
        return this.onTimeBehavior;
    }

    public TimestampCombiner getTimestampCombiner() {
        return this.timestampCombiner;
    }

    public boolean isTimestampCombinerSpecified() {
        return this.timestampCombinerSpecified;
    }

    public WindowingStrategy<T, W> withTrigger(Trigger trigger) {
        return new WindowingStrategy<T, W>(this.windowFn, trigger, true, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.timestampCombiner, this.timestampCombinerSpecified, this.closingBehavior, this.onTimeBehavior);
    }

    public WindowingStrategy<T, W> withMode(AccumulationMode mode) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, mode, true, this.allowedLateness, this.allowedLatenessSpecified, this.timestampCombiner, this.timestampCombinerSpecified, this.closingBehavior, this.onTimeBehavior);
    }

    public WindowingStrategy<T, W> withWindowFn(WindowFn<?, ?> wildcardWindowFn) {
        WindowFn<?, ?> typedWindowFn = wildcardWindowFn;
        return new WindowingStrategy(typedWindowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.timestampCombiner, this.timestampCombinerSpecified, this.closingBehavior, this.onTimeBehavior);
    }

    public WindowingStrategy<T, W> withAllowedLateness(Duration allowedLateness) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, allowedLateness, true, this.timestampCombiner, this.timestampCombinerSpecified, this.closingBehavior, this.onTimeBehavior);
    }

    public WindowingStrategy<T, W> withClosingBehavior(Window.ClosingBehavior closingBehavior) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.timestampCombiner, this.timestampCombinerSpecified, closingBehavior, this.onTimeBehavior);
    }

    public WindowingStrategy<T, W> withOnTimeBehavior(Window.OnTimeBehavior onTimeBehavior) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.timestampCombiner, this.timestampCombinerSpecified, this.closingBehavior, onTimeBehavior);
    }

    @Experimental(value=Experimental.Kind.OUTPUT_TIME)
    public WindowingStrategy<T, W> withTimestampCombiner(TimestampCombiner timestampCombiner) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, timestampCombiner, true, this.closingBehavior, this.onTimeBehavior);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("windowFn", this.windowFn).add("allowedLateness", this.allowedLateness).add("trigger", this.trigger).add("accumulationMode", (Object)this.mode).add("timestampCombiner", (Object)this.timestampCombiner).toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof WindowingStrategy)) {
            return false;
        }
        WindowingStrategy other = (WindowingStrategy)object;
        return this.isAllowedLatenessSpecified() == other.isAllowedLatenessSpecified() && this.isModeSpecified() == other.isModeSpecified() && this.isTimestampCombinerSpecified() == other.isTimestampCombinerSpecified() && this.getMode().equals((Object)other.getMode()) && this.getAllowedLateness().equals(other.getAllowedLateness()) && this.getClosingBehavior().equals((Object)other.getClosingBehavior()) && this.getOnTimeBehavior().equals((Object)other.getOnTimeBehavior()) && this.getTrigger().equals(other.getTrigger()) && this.getTimestampCombiner().equals((Object)other.getTimestampCombiner()) && this.getWindowFn().equals(other.getWindowFn());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowedLatenessSpecified, this.modeSpecified, this.timestampCombinerSpecified, this.mode, this.allowedLateness, this.closingBehavior, this.trigger, this.timestampCombiner, this.windowFn});
    }

    @VisibleForTesting
    public WindowingStrategy<T, W> fixDefaults() {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, true, this.mode, true, this.allowedLateness, true, this.timestampCombiner, true, this.closingBehavior, this.onTimeBehavior);
    }

    public static enum AccumulationMode {
        DISCARDING_FIRED_PANES,
        ACCUMULATING_FIRED_PANES;

    }
}

