/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p13p1.io.grpc.protobuf.lite;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.CodedInputStream;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.ExtensionRegistryLite;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.MessageLite;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.Parser;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.ExperimentalApi;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.KnownLength;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.Metadata;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.MethodDescriptor;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.protobuf.lite.ProtoInputStream;

@ExperimentalApi(value="Experimental until Lite is stable in protobuf")
public class ProtoLiteUtils {
    private static volatile ExtensionRegistryLite globalRegistry = ExtensionRegistryLite.getEmptyRegistry();
    private static final int BUF_SIZE = 8192;
    @VisibleForTesting
    static final int DEFAULT_MAX_MESSAGE_SIZE = 0x400000;
    private static final ThreadLocal<Reference<byte[]>> bufs = new ThreadLocal<Reference<byte[]>>(){

        @Override
        protected Reference<byte[]> initialValue() {
            return new WeakReference<byte[]>(new byte[4096]);
        }
    };

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1787")
    public static void setExtensionRegistry(ExtensionRegistryLite newRegistry) {
        globalRegistry = Preconditions.checkNotNull(newRegistry, "newRegistry");
    }

    public static <T extends MessageLite> MethodDescriptor.Marshaller<T> marshaller(final T defaultInstance) {
        final Parser<? extends MessageLite> parser = defaultInstance.getParserForType();
        return new MethodDescriptor.PrototypeMarshaller<T>(){

            @Override
            public Class<T> getMessageClass() {
                return defaultInstance.getClass();
            }

            @Override
            public T getMessagePrototype() {
                return defaultInstance;
            }

            @Override
            public InputStream stream(T value) {
                return new ProtoInputStream((MessageLite)value, parser);
            }

            @Override
            public T parse(InputStream stream) {
                ProtoInputStream protoStream;
                if (stream instanceof ProtoInputStream && (protoStream = (ProtoInputStream)stream).parser() == parser) {
                    try {
                        MessageLite message = ((ProtoInputStream)stream).message();
                        return message;
                    }
                    catch (IllegalStateException message) {
                        // empty catch block
                    }
                }
                CodedInputStream cis = null;
                try {
                    if (stream instanceof KnownLength) {
                        int size = stream.available();
                        if (size > 0 && size <= 0x400000) {
                            int position;
                            int remaining;
                            int count;
                            byte[] buf = (byte[])((Reference)bufs.get()).get();
                            if (buf == null || buf.length < size) {
                                buf = new byte[size];
                                bufs.set(new WeakReference<byte[]>(buf));
                            }
                            for (remaining = size; remaining > 0 && (count = stream.read(buf, position = size - remaining, remaining)) != -1; remaining -= count) {
                            }
                            if (remaining != 0) {
                                position = size - remaining;
                                throw new RuntimeException("size inaccurate: " + size + " != " + position);
                            }
                            cis = CodedInputStream.newInstance(buf, 0, size);
                        } else if (size == 0) {
                            return defaultInstance;
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (cis == null) {
                    cis = CodedInputStream.newInstance(stream);
                }
                cis.setSizeLimit(Integer.MAX_VALUE);
                try {
                    return this.parseFrom(cis);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause(ipbe).asRuntimeException();
                }
            }

            private T parseFrom(CodedInputStream stream) throws InvalidProtocolBufferException {
                MessageLite message = (MessageLite)parser.parseFrom(stream, globalRegistry);
                try {
                    stream.checkLastTagWas(0);
                    return message;
                }
                catch (InvalidProtocolBufferException e) {
                    e.setUnfinishedMessage(message);
                    throw e;
                }
            }
        };
    }

    public static <T extends MessageLite> Metadata.BinaryMarshaller<T> metadataMarshaller(final T instance) {
        return new Metadata.BinaryMarshaller<T>(){

            @Override
            public byte[] toBytes(T value) {
                return value.toByteArray();
            }

            @Override
            public T parseBytes(byte[] serialized) {
                try {
                    return instance.getParserForType().parseFrom(serialized, globalRegistry);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw new IllegalArgumentException(ipbe);
                }
            }
        };
    }

    static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        byte[] buf = new byte[8192];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    private ProtoLiteUtils() {
    }
}

