/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.PathCodec;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.net.URI;
import java.util.regex.Pattern;

public class GoogleCloudStorageFileSystemOptions {
    private final PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions;
    private final boolean performanceCacheEnabled;
    private final GoogleCloudStorageOptions cloudStorageOptions;
    private final TimestampUpdatePredicate shouldIncludeInTimestampUpdatesPredicate;
    private final PathCodec pathCodec;
    private final boolean enableBucketDelete;
    private final Pattern markerFilePattern;

    public static Builder newBuilder() {
        return new Builder();
    }

    public GoogleCloudStorageFileSystemOptions(PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions, boolean performanceCacheEnabled, GoogleCloudStorageOptions cloudStorageOptions, TimestampUpdatePredicate shouldIncludeInTimestampUpdatesPredicate, PathCodec pathCodec, boolean enableBucketDelete, String markerFilePattern) {
        this.performanceCacheOptions = performanceCacheOptions;
        this.performanceCacheEnabled = performanceCacheEnabled;
        this.cloudStorageOptions = cloudStorageOptions;
        this.shouldIncludeInTimestampUpdatesPredicate = shouldIncludeInTimestampUpdatesPredicate;
        this.pathCodec = pathCodec;
        this.enableBucketDelete = enableBucketDelete;
        this.markerFilePattern = Pattern.compile("^(.+/)?" + markerFilePattern + "$");
    }

    public PerformanceCachingGoogleCloudStorageOptions getPerformanceCacheOptions() {
        return this.performanceCacheOptions;
    }

    public boolean isPerformanceCacheEnabled() {
        return this.performanceCacheEnabled;
    }

    public GoogleCloudStorageOptions getCloudStorageOptions() {
        return this.cloudStorageOptions;
    }

    public TimestampUpdatePredicate getShouldIncludeInTimestampUpdatesPredicate() {
        return this.shouldIncludeInTimestampUpdatesPredicate;
    }

    public PathCodec getPathCodec() {
        return this.pathCodec;
    }

    public boolean enableBucketDelete() {
        return this.enableBucketDelete;
    }

    public Pattern getMarkerFilePattern() {
        return this.markerFilePattern;
    }

    public void throwIfNotValid() {
        Preconditions.checkNotNull(this.shouldIncludeInTimestampUpdatesPredicate, "Predicate for ignored directory updates should not be null. Consider Predicates.alwasyTrue");
        this.cloudStorageOptions.throwIfNotValid();
    }

    public static class Builder {
        private boolean performanceCacheEnabled = false;
        private PerformanceCachingGoogleCloudStorageOptions.Builder performanceCacheOptionsBuilder = PerformanceCachingGoogleCloudStorageOptions.builder();
        private PerformanceCachingGoogleCloudStorageOptions immutablePerformanceCacheOptions = null;
        protected TimestampUpdatePredicate shouldIncludeInTimestampUpdatesPredicate = new TimestampUpdatePredicate(){

            @Override
            public boolean shouldUpdateTimestamp(URI item) {
                return true;
            }
        };
        private GoogleCloudStorageOptions.Builder cloudStorageOptionsBuilder = GoogleCloudStorageOptions.newBuilder();
        private GoogleCloudStorageOptions immutableCloudStorageOptions = null;
        private PathCodec pathCodec = GoogleCloudStorageFileSystem.URI_ENCODED_PATH_CODEC;
        private boolean enableBucketDelete = false;
        private String markerFilePattern = null;

        public Builder setIsPerformanceCacheEnabled(boolean performanceCacheEnabled) {
            this.performanceCacheEnabled = performanceCacheEnabled;
            return this;
        }

        public PerformanceCachingGoogleCloudStorageOptions.Builder getPerformanceCachingOptionsBuilder() {
            return this.performanceCacheOptionsBuilder;
        }

        public Builder setPerformanceCachingOptionsBuilder(PerformanceCachingGoogleCloudStorageOptions.Builder performanceCacheOptionsBuilder) {
            this.performanceCacheOptionsBuilder = performanceCacheOptionsBuilder;
            this.immutablePerformanceCacheOptions = null;
            return this;
        }

        public Builder setImmutablePerformanceCachingOptions(PerformanceCachingGoogleCloudStorageOptions immutablePerformanceCacheOptions) {
            this.immutablePerformanceCacheOptions = immutablePerformanceCacheOptions;
            this.performanceCacheOptionsBuilder = PerformanceCachingGoogleCloudStorageOptions.builder();
            return this;
        }

        public GoogleCloudStorageOptions.Builder getCloudStorageOptionsBuilder() {
            return this.cloudStorageOptionsBuilder;
        }

        public Builder setCloudStorageOptionsBuilder(GoogleCloudStorageOptions.Builder cloudStorageOptionsBuilder) {
            this.cloudStorageOptionsBuilder = cloudStorageOptionsBuilder;
            this.immutableCloudStorageOptions = null;
            return this;
        }

        public Builder setImmutableCloudStorageOptions(GoogleCloudStorageOptions immutableCloudStorageOptions) {
            this.immutableCloudStorageOptions = immutableCloudStorageOptions;
            this.cloudStorageOptionsBuilder = GoogleCloudStorageOptions.newBuilder();
            return this;
        }

        public Builder setShouldIncludeInTimestampUpdatesPredicate(final Predicate<String> shouldIncludeInTimestampUpdatesPredicate) {
            this.shouldIncludeInTimestampUpdatesPredicate = new TimestampUpdatePredicate(){

                @Override
                public boolean shouldUpdateTimestamp(URI item) {
                    return shouldIncludeInTimestampUpdatesPredicate.apply(item.getPath());
                }
            };
            return this;
        }

        public Builder setShouldIncludeInTimestampUpdatesPredicate(TimestampUpdatePredicate shouldIncludeInTimestampUpdatesPredicate) {
            this.shouldIncludeInTimestampUpdatesPredicate = shouldIncludeInTimestampUpdatesPredicate;
            return this;
        }

        public Builder setPathCodec(PathCodec pathCodec) {
            this.pathCodec = pathCodec;
            return this;
        }

        public Builder setEnableBucketDelete(boolean enableBucketDelete) {
            this.enableBucketDelete = enableBucketDelete;
            return this;
        }

        public Builder setMarkerFilePattern(String markerFilePattern) {
            this.markerFilePattern = markerFilePattern;
            return this;
        }

        public GoogleCloudStorageFileSystemOptions build() {
            return new GoogleCloudStorageFileSystemOptions(this.immutablePerformanceCacheOptions != null ? this.immutablePerformanceCacheOptions : this.performanceCacheOptionsBuilder.build(), this.performanceCacheEnabled, this.immutableCloudStorageOptions != null ? this.immutableCloudStorageOptions : this.cloudStorageOptionsBuilder.build(), this.shouldIncludeInTimestampUpdatesPredicate, this.pathCodec, this.enableBucketDelete, this.markerFilePattern);
        }
    }

    public static interface TimestampUpdatePredicate {
        public boolean shouldUpdateTimestamp(URI var1);
    }
}

