/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.testing;

import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.testing.InMemoryObjectEntry;
import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InMemoryBucketEntry {
    private Map<String, InMemoryObjectEntry> objectLookup = new HashMap<String, InMemoryObjectEntry>();
    private GoogleCloudStorageItemInfo info;

    public InMemoryBucketEntry(String bucketName, long createTimeMillis, CreateBucketOptions options) {
        this.info = new GoogleCloudStorageItemInfo(new StorageResourceId(bucketName), createTimeMillis, 0L, MoreObjects.firstNonNull(options.getLocation(), "us-central"), MoreObjects.firstNonNull(options.getStorageClass(), "inmemory-class"));
    }

    public synchronized void add(InMemoryObjectEntry obj) {
        assert (obj.getBucketName().equals(this.info.getBucketName()));
        this.objectLookup.put(obj.getObjectName(), obj);
    }

    public synchronized InMemoryObjectEntry get(String objectName) {
        return this.objectLookup.get(objectName);
    }

    public synchronized InMemoryObjectEntry remove(String objectName) {
        return this.objectLookup.remove(objectName);
    }

    public synchronized GoogleCloudStorageItemInfo getInfo() {
        return this.info;
    }

    public synchronized Set<String> getObjectNames() {
        return this.objectLookup.keySet();
    }

    public synchronized int size() {
        return this.objectLookup.size();
    }
}

