/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpTransport;
import com.google.cloud.hadoop.util.CredentialFactory;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;

public class CredentialConfiguration {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private boolean serviceAccountEnabled = true;
    private String serviceAccountPrivateKeyId = null;
    private String serviceAccountPrivateKey = null;
    private String serviceAccountEmail = null;
    private String serviceAccountKeyFile = null;
    private String serviceAccountJsonKeyFile = null;
    private String clientId = null;
    private String clientSecret = null;
    private String oAuthCredentialFile = null;
    private boolean nullCredentialEnabled = false;
    private CredentialFactory credentialFactory = new CredentialFactory();
    private HttpTransportFactory.HttpTransportType transportType = HttpTransportFactory.HttpTransportType.JAVA_NET;
    private String proxyAddress = null;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private HttpTransport transport;

    public Credential getCredential(List<String> scopes) throws IOException, GeneralSecurityException {
        if (this.isServiceAccountEnabled()) {
            ((GoogleLogger.Api)logger.atFine()).log("Using service account credentials");
            if (this.shouldUseMetadataService()) {
                ((GoogleLogger.Api)logger.atFine()).log("Getting service account credentials from meta data service.");
                return this.credentialFactory.getCredentialFromMetadataServiceAccount();
            }
            if (!Strings.isNullOrEmpty(this.serviceAccountPrivateKeyId)) {
                ((GoogleLogger.Api)logger.atFine()).log("Attempting to get credentials from Configuration");
                Preconditions.checkState(!Strings.isNullOrEmpty(this.serviceAccountPrivateKey), "privateKeyId must be set if using credentials configured directly in configuration");
                Preconditions.checkState(!Strings.isNullOrEmpty(this.serviceAccountEmail), "clientEmail must be set if using credentials configured directly in configuration");
                Preconditions.checkArgument(Strings.isNullOrEmpty(this.serviceAccountKeyFile), "A P12 key file may not be specified at the same time as credentials via configuration.");
                Preconditions.checkArgument(Strings.isNullOrEmpty(this.serviceAccountJsonKeyFile), "A JSON key file may not be specified at the same time as credentials via configuration.");
                return this.credentialFactory.getCredentialsFromSAParameters(this.serviceAccountPrivateKeyId, this.serviceAccountPrivateKey, this.serviceAccountEmail, scopes, this.getTransport());
            }
            if (!Strings.isNullOrEmpty(this.serviceAccountJsonKeyFile)) {
                ((GoogleLogger.Api)logger.atFine()).log("Using JSON keyfile %s", this.serviceAccountJsonKeyFile);
                Preconditions.checkArgument(Strings.isNullOrEmpty(this.serviceAccountKeyFile), "A P12 key file may not be specified at the same time as a JSON key file.");
                Preconditions.checkArgument(Strings.isNullOrEmpty(this.serviceAccountEmail), "Service account email may not be specified at the same time as a JSON key file.");
                return this.credentialFactory.getCredentialFromJsonKeyFile(this.serviceAccountJsonKeyFile, scopes, this.getTransport());
            }
            if (!Strings.isNullOrEmpty(this.serviceAccountKeyFile)) {
                Preconditions.checkState(!Strings.isNullOrEmpty(this.serviceAccountEmail), "Email must be set if using service account auth and a key file is specified.");
                ((GoogleLogger.Api)logger.atFine()).log("Using service account email %s and private key file %s", (Object)this.serviceAccountEmail, (Object)this.serviceAccountKeyFile);
                return this.credentialFactory.getCredentialFromPrivateKeyServiceAccount(this.serviceAccountEmail, this.serviceAccountKeyFile, scopes, this.getTransport());
            }
            if (this.shouldUseApplicationDefaultCredentials()) {
                ((GoogleLogger.Api)logger.atFine()).log("Getting Application Default Credentials");
                return this.credentialFactory.getApplicationDefaultCredentials(scopes, this.getTransport());
            }
        } else {
            if (this.oAuthCredentialFile != null && this.clientId != null && this.clientSecret != null) {
                ((GoogleLogger.Api)logger.atFine()).log("Using installed app credentials in file %s", this.oAuthCredentialFile);
                return this.credentialFactory.getCredentialFromFileCredentialStoreForInstalledApp(this.clientId, this.clientSecret, this.oAuthCredentialFile, scopes, this.getTransport());
            }
            if (this.nullCredentialEnabled) {
                ((GoogleLogger.Api)logger.atWarning()).log("Allowing null credentials for unit testing. This should not be used in production");
                return null;
            }
        }
        ((GoogleLogger.Api)logger.atSevere()).log("Credential configuration is not valid. Configuration: %s", this);
        throw new IllegalStateException("No valid credential configuration discovered.");
    }

    private boolean shouldUseApplicationDefaultCredentials() {
        return this.credentialFactory.hasApplicationDefaultCredentialsConfigured();
    }

    public boolean shouldUseMetadataService() {
        return Strings.isNullOrEmpty(this.serviceAccountKeyFile) && Strings.isNullOrEmpty(this.serviceAccountJsonKeyFile) && Strings.isNullOrEmpty(this.serviceAccountPrivateKey) && !this.shouldUseApplicationDefaultCredentials();
    }

    public String getOAuthCredentialFile() {
        return this.oAuthCredentialFile;
    }

    public void setOAuthCredentialFile(String oAuthCredentialFile) {
        this.oAuthCredentialFile = oAuthCredentialFile;
    }

    public boolean isNullCredentialEnabled() {
        return this.nullCredentialEnabled;
    }

    public void setNullCredentialEnabled(boolean nullCredentialEnabled) {
        this.nullCredentialEnabled = nullCredentialEnabled;
    }

    public boolean isServiceAccountEnabled() {
        return this.serviceAccountEnabled;
    }

    public String getServiceAccountPrivateKeyId() {
        return this.serviceAccountPrivateKeyId;
    }

    public void setServiceAccountPrivateKeyId(String serviceAccountPrivateKeyId) {
        this.serviceAccountPrivateKeyId = serviceAccountPrivateKeyId;
    }

    public String getServiceAccountPrivateKey() {
        return this.serviceAccountPrivateKey;
    }

    public void setServiceAccountPrivateKey(String serviceAccountPrivateKey) {
        this.serviceAccountPrivateKey = serviceAccountPrivateKey.replace("\\n", System.lineSeparator());
    }

    public void setEnableServiceAccounts(boolean enableServiceAccounts) {
        this.serviceAccountEnabled = enableServiceAccounts;
    }

    public String getServiceAccountEmail() {
        return this.serviceAccountEmail;
    }

    public void setServiceAccountEmail(String serviceAccountEmail) {
        this.serviceAccountEmail = serviceAccountEmail;
    }

    public String getServiceAccountKeyFile() {
        return this.serviceAccountKeyFile;
    }

    public void setServiceAccountKeyFile(String serviceAccountKeyFile) {
        this.serviceAccountKeyFile = serviceAccountKeyFile;
    }

    public String getServiceAccountJsonKeyFile() {
        return this.serviceAccountJsonKeyFile;
    }

    public void setServiceAccountJsonKeyFile(String serviceAccountJsonKeyFile) {
        this.serviceAccountJsonKeyFile = serviceAccountJsonKeyFile;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public HttpTransportFactory.HttpTransportType getTransportType() {
        return this.transportType;
    }

    public void setTransportType(HttpTransportFactory.HttpTransportType transportType) {
        this.transportType = transportType;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public void setProxyAddress(String proxyAddress) {
        this.proxyAddress = proxyAddress;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    void setCredentialFactory(CredentialFactory factory) {
        this.credentialFactory = factory;
    }

    public String toString() {
        return "CredentialConfiguration{\n" + "serviceAccountEnabled: " + this.isServiceAccountEnabled() + '\n' + "serviceAccountPrivateKeyId: " + HttpTransportFactory.toSecretString(this.getServiceAccountPrivateKeyId()) + '\n' + "serviceAccountPrivateKey: " + HttpTransportFactory.toSecretString(this.getServiceAccountPrivateKey()) + '\n' + "serviceAccountEmail: " + this.getServiceAccountEmail() + '\n' + "serviceAccountKeyfile: " + this.getServiceAccountKeyFile() + '\n' + "serviceAccountJsonKeyFile: " + this.getServiceAccountJsonKeyFile() + '\n' + "clientId: " + HttpTransportFactory.toSecretString(this.getClientId()) + '\n' + "clientSecret: " + HttpTransportFactory.toSecretString(this.getClientSecret()) + '\n' + "oAuthCredentialFile: " + this.getOAuthCredentialFile() + '\n' + "isNullCredentialEnabled: " + this.isNullCredentialEnabled() + '\n' + "transportType: " + (Object)((Object)this.getTransportType()) + '\n' + "proxyAddress: " + this.getProxyAddress() + '\n' + "proxyUsername: " + HttpTransportFactory.toSecretString(this.getProxyUsername()) + '\n' + "proxyPassword: " + HttpTransportFactory.toSecretString(this.getProxyPassword()) + '\n' + "}";
    }

    private HttpTransport getTransport() throws IOException {
        if (this.transport == null) {
            this.transport = HttpTransportFactory.createHttpTransport(this.getTransportType(), this.getProxyAddress(), this.getProxyUsername(), this.getProxyPassword());
        }
        return this.transport;
    }

    @VisibleForTesting
    void setTransport(HttpTransport transport) {
        this.transport = transport;
    }
}

