/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.fn.harness.control.BundleSplitListener;
import org.apache.beam.fn.harness.data.BeamFnDataClient;
import org.apache.beam.fn.harness.data.PCollectionConsumerRegistry;
import org.apache.beam.fn.harness.data.PTransformFunctionRegistry;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.function.ThrowingFunction;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

public abstract class MapFnRunners {
    public static <InputT, OutputT> PTransformRunnerFactory<?> forValueMapFnFactory(ValueMapFnFactory<InputT, OutputT> fnFactory) {
        return new Factory(new CompressedValueOnlyMapperFactory(fnFactory));
    }

    public static <InputT, OutputT> PTransformRunnerFactory<?> forWindowedValueMapFnFactory(WindowedValueMapFnFactory<InputT, OutputT> fnFactory) {
        return new Factory(new ExplodedWindowedValueMapperFactory(fnFactory));
    }

    private static class CompressedValueOnlyMapperFactory<InputT, OutputT>
    implements MapperFactory<InputT, OutputT> {
        private final ValueMapFnFactory<InputT, OutputT> fnFactory;

        private CompressedValueOnlyMapperFactory(ValueMapFnFactory<InputT, OutputT> fnFactory) {
            this.fnFactory = fnFactory;
        }

        @Override
        public Mapper<InputT, OutputT> create(String ptransformId, RunnerApi.PTransform ptransform, FnDataReceiver<WindowedValue<OutputT>> outputs) throws IOException {
            ThrowingFunction fn = this.fnFactory.forPTransform(ptransformId, ptransform);
            return input -> outputs.accept(input.withValue(fn.apply(input.getValue())));
        }
    }

    private static class ExplodedWindowedValueMapperFactory<InputT, OutputT>
    implements MapperFactory<InputT, OutputT> {
        private final WindowedValueMapFnFactory<InputT, OutputT> fnFactory;

        private ExplodedWindowedValueMapperFactory(WindowedValueMapFnFactory<InputT, OutputT> fnFactory) {
            this.fnFactory = fnFactory;
        }

        @Override
        public Mapper<InputT, OutputT> create(String ptransformId, RunnerApi.PTransform ptransform, FnDataReceiver<WindowedValue<OutputT>> outputs) throws IOException {
            ThrowingFunction fn = this.fnFactory.forPTransform(ptransformId, ptransform);
            return input -> {
                for (WindowedValue exploded : input.explodeWindows()) {
                    outputs.accept((WindowedValue)fn.apply(exploded));
                }
            };
        }
    }

    private static interface Mapper<InputT, OutputT> {
        public void map(WindowedValue<InputT> var1) throws Exception;
    }

    @FunctionalInterface
    private static interface MapperFactory<InputT, OutputT> {
        public Mapper<InputT, OutputT> create(String var1, RunnerApi.PTransform var2, FnDataReceiver<WindowedValue<OutputT>> var3) throws IOException;
    }

    private static class Factory<InputT, OutputT>
    implements PTransformRunnerFactory<Mapper<InputT, OutputT>> {
        private final MapperFactory mapperFactory;

        private Factory(MapperFactory<InputT, OutputT> mapperFactory) {
            this.mapperFactory = mapperFactory;
        }

        @Override
        public Mapper<InputT, OutputT> createRunnerForPTransform(PipelineOptions pipelineOptions, BeamFnDataClient beamFnDataClient, BeamFnStateClient beamFnStateClient, String pTransformId, RunnerApi.PTransform pTransform, Supplier<String> processBundleInstructionId, Map<String, RunnerApi.PCollection> pCollections, Map<String, RunnerApi.Coder> coders, Map<String, RunnerApi.WindowingStrategy> windowingStrategies, PCollectionConsumerRegistry pCollectionConsumerRegistry, PTransformFunctionRegistry startFunctionRegistry, PTransformFunctionRegistry finishFunctionRegistry, BundleSplitListener splitListener) throws IOException {
            FnDataReceiver consumer = pCollectionConsumerRegistry.getMultiplexingConsumer(Iterables.getOnlyElement(pTransform.getOutputsMap().values()));
            Mapper mapper = this.mapperFactory.create(pTransformId, pTransform, consumer);
            pCollectionConsumerRegistry.register(Iterables.getOnlyElement(pTransform.getInputsMap().values()), pTransformId, mapper::map);
            return mapper;
        }
    }

    public static interface WindowedValueMapFnFactory<InputT, OutputT> {
        public ThrowingFunction<WindowedValue<InputT>, WindowedValue<OutputT>> forPTransform(String var1, RunnerApi.PTransform var2) throws IOException;
    }

    public static interface ValueMapFnFactory<InputT, OutputT> {
        public ThrowingFunction<InputT, OutputT> forPTransform(String var1, RunnerApi.PTransform var2) throws IOException;
    }
}

