/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.data;

import java.util.Collection;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

public class MultiplexingFnDataReceiver<T>
implements FnDataReceiver<T> {
    private final Collection<FnDataReceiver<T>> consumers;

    public static <T> FnDataReceiver<T> forConsumers(Collection<FnDataReceiver<T>> consumers) {
        if (consumers.size() == 1) {
            return Iterables.getOnlyElement(consumers);
        }
        return new MultiplexingFnDataReceiver<T>(consumers);
    }

    private MultiplexingFnDataReceiver(Collection<FnDataReceiver<T>> consumers) {
        this.consumers = consumers;
    }

    @Override
    public void accept(T input) throws Exception {
        for (FnDataReceiver<T> consumer : this.consumers) {
            consumer.accept(input);
        }
    }
}

