/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.data;

import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.fn.harness.data.ElementCountFnDataReceiver;
import org.apache.beam.fn.harness.data.MultiplexingFnDataReceiver;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.ExecutionStateTracker;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.SimpleExecutionState;
import org.apache.beam.runners.core.metrics.SimpleStateRegistry;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ListMultimap;

public class PCollectionConsumerRegistry {
    private ListMultimap<String, FnDataReceiver<WindowedValue<?>>> pCollectionIdsToConsumers;
    private Map<String, ElementCountFnDataReceiver> pCollectionIdsToWrappedConsumer;
    private MetricsContainerStepMap metricsContainerRegistry;
    private ExecutionStateTracker stateTracker;
    private SimpleStateRegistry executionStates = new SimpleStateRegistry();

    public PCollectionConsumerRegistry(MetricsContainerStepMap metricsContainerRegistry, ExecutionStateTracker stateTracker) {
        this.metricsContainerRegistry = metricsContainerRegistry;
        this.stateTracker = stateTracker;
        this.pCollectionIdsToConsumers = ArrayListMultimap.create();
        this.pCollectionIdsToWrappedConsumer = new HashMap<String, ElementCountFnDataReceiver>();
    }

    public <T> void register(String pCollectionId, String pTransformId, FnDataReceiver<WindowedValue<T>> consumer) {
        ElementCountFnDataReceiver wrappedConsumer = this.pCollectionIdsToWrappedConsumer.getOrDefault(pCollectionId, null);
        if (wrappedConsumer != null) {
            throw new RuntimeException("New consumers for a pCollectionId cannot be register()-d after calling getMultiplexingConsumer.");
        }
        HashMap<String, String> labelsMetadata = new HashMap<String, String>();
        labelsMetadata.put(MonitoringInfoConstants.Labels.PTRANSFORM, pTransformId);
        SimpleExecutionState state = new SimpleExecutionState("process", MonitoringInfoConstants.Urns.PROCESS_BUNDLE_MSECS, labelsMetadata);
        this.executionStates.register(state);
        FnDataReceiver<WindowedValue> wrapAndEnableMetricContainer = input -> {
            MetricsContainerImpl container = this.metricsContainerRegistry.getContainer(pTransformId);
            Closeable closeable = MetricsEnvironment.scopedMetricsContainer(container);
            Throwable throwable = null;
            try {
                Closeable trackerCloseable = this.stateTracker.enterState(state);
                Throwable throwable2 = null;
                try {
                    consumer.accept((WindowedValue)input);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (trackerCloseable != null) {
                        PCollectionConsumerRegistry.$closeResource(throwable2, trackerCloseable);
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (closeable != null) {
                    PCollectionConsumerRegistry.$closeResource(throwable, closeable);
                }
            }
        };
        this.pCollectionIdsToConsumers.put(pCollectionId, wrapAndEnableMetricContainer);
    }

    public Set<String> keySet() {
        return this.pCollectionIdsToConsumers.keySet();
    }

    public FnDataReceiver<WindowedValue<?>> getMultiplexingConsumer(String pCollectionId) {
        ElementCountFnDataReceiver wrappedConsumer = this.pCollectionIdsToWrappedConsumer.getOrDefault(pCollectionId, null);
        if (wrappedConsumer == null) {
            List consumers = this.pCollectionIdsToConsumers.get(pCollectionId);
            FnDataReceiver consumer = MultiplexingFnDataReceiver.forConsumers(consumers);
            wrappedConsumer = new ElementCountFnDataReceiver(consumer, pCollectionId, this.metricsContainerRegistry);
            this.pCollectionIdsToWrappedConsumer.put(pCollectionId, wrappedConsumer);
        }
        return wrappedConsumer;
    }

    public List<MetricsApi.MonitoringInfo> getExecutionTimeMonitoringInfos() {
        return this.executionStates.getExecutionTimeMonitoringInfos();
    }

    public List<FnDataReceiver<WindowedValue<?>>> getUnderlyingConsumers(String pCollectionId) {
        return this.pCollectionIdsToConsumers.get(pCollectionId);
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

