/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.LazyCachingIteratorToIterable;
import org.apache.beam.fn.harness.state.StateFetchingIterators;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.stream.DataStreams;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

public class BagUserState<T> {
    private final BeamFnStateClient beamFnStateClient;
    private final BeamFnApi.StateRequest request;
    private final Coder<T> valueCoder;
    private Iterable<T> oldValues;
    private ArrayList<T> newValues;
    private boolean isClosed;

    public BagUserState(BeamFnStateClient beamFnStateClient, String instructionId, String ptransformId, String stateId, ByteString encodedWindow, ByteString encodedKey, Coder<T> valueCoder) {
        this.beamFnStateClient = beamFnStateClient;
        this.valueCoder = valueCoder;
        BeamFnApi.StateRequest.Builder requestBuilder = BeamFnApi.StateRequest.newBuilder();
        requestBuilder.setInstructionReference(instructionId).getStateKeyBuilder().getBagUserStateBuilder().setPtransformId(ptransformId).setUserStateId(stateId).setWindow(encodedWindow).setKey(encodedKey);
        this.request = requestBuilder.build();
        this.oldValues = new LazyCachingIteratorToIterable<T>(new DataStreams.DataStreamDecoder<T>(valueCoder, DataStreams.inbound(StateFetchingIterators.forFirstChunk(beamFnStateClient, this.request))));
        this.newValues = new ArrayList();
    }

    public Iterable<T> get() {
        Preconditions.checkState(!this.isClosed, "Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        if (this.oldValues == null) {
            return Iterables.limit(Collections.unmodifiableList(this.newValues), this.newValues.size());
        }
        if (this.newValues.isEmpty()) {
            return this.oldValues;
        }
        return Iterables.concat(this.oldValues, Iterables.limit(Collections.unmodifiableList(this.newValues), this.newValues.size()));
    }

    public void append(T t) {
        Preconditions.checkState(!this.isClosed, "Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        this.newValues.add(t);
    }

    public void clear() {
        Preconditions.checkState(!this.isClosed, "Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        this.oldValues = null;
        this.newValues = new ArrayList();
    }

    public void asyncClose() throws Exception {
        Preconditions.checkState(!this.isClosed, "Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        if (this.oldValues == null) {
            this.beamFnStateClient.handle(this.request.toBuilder().setClear(BeamFnApi.StateClearRequest.getDefaultInstance()), new CompletableFuture<BeamFnApi.StateResponse>());
        }
        if (!this.newValues.isEmpty()) {
            ByteString.Output out = ByteString.newOutput();
            for (T newValue : this.newValues) {
                this.valueCoder.encode(newValue, out);
            }
            this.beamFnStateClient.handle(this.request.toBuilder().setAppend(BeamFnApi.StateAppendRequest.newBuilder().setData(out.toByteString())), new CompletableFuture<BeamFnApi.StateResponse>());
        }
        this.isClosed = true;
    }
}

