/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

class LazyCachingIteratorToIterable<T>
implements Iterable<T> {
    private final List<T> cachedElements = new ArrayList<T>();
    private final Iterator<T> iterator;

    public LazyCachingIteratorToIterable(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public Iterator<T> iterator() {
        return new CachingIterator();
    }

    public int hashCode() {
        return this.iterator.hasNext() ? this.iterator.next().hashCode() : -1789023489;
    }

    public boolean equals(Object obj) {
        return obj instanceof Iterable && Iterables.elementsEqual(this, (Iterable)obj);
    }

    public String toString() {
        return Iterables.toString(this);
    }

    private class CachingIterator
    implements Iterator<T> {
        private int position = 0;

        private CachingIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < LazyCachingIteratorToIterable.this.cachedElements.size() || LazyCachingIteratorToIterable.this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (this.position < LazyCachingIteratorToIterable.this.cachedElements.size()) {
                return LazyCachingIteratorToIterable.this.cachedElements.get(this.position++);
            }
            if (!LazyCachingIteratorToIterable.this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Object rval = LazyCachingIteratorToIterable.this.iterator.next();
            LazyCachingIteratorToIterable.this.cachedElements.add(rval);
            ++this.position;
            return rval;
        }
    }
}

