/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.Collection;
import org.apache.beam.runners.core.GlobalCombineFnRunner;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

public class GlobalCombineFnRunners {
    public static <InputT, AccumT, OutputT> GlobalCombineFnRunner<InputT, AccumT, OutputT> create(CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> globalCombineFn) {
        if (globalCombineFn instanceof CombineWithContext.CombineFnWithContext) {
            return new CombineFnWithContextRunner((CombineWithContext.CombineFnWithContext)globalCombineFn);
        }
        if (globalCombineFn instanceof Combine.CombineFn) {
            return new CombineFnRunner((Combine.CombineFn)globalCombineFn);
        }
        throw new IllegalStateException(String.format("Unknown type of CombineFn: %s", globalCombineFn.getClass()));
    }

    private static CombineWithContext.Context createFromComponents(final PipelineOptions options, final SideInputReader sideInputReader, final BoundedWindow mainInputWindow) {
        return new CombineWithContext.Context(){

            @Override
            public PipelineOptions getPipelineOptions() {
                return options;
            }

            @Override
            public <T> T sideInput(PCollectionView<T> view) {
                if (!sideInputReader.contains(view)) {
                    throw new IllegalArgumentException("calling sideInput() with unknown view");
                }
                Object sideInputWindow = view.getWindowMappingFn().getSideInputWindow(mainInputWindow);
                return sideInputReader.get(view, (BoundedWindow)sideInputWindow);
            }
        };
    }

    private static class CombineFnWithContextRunner<InputT, AccumT, OutputT>
    implements GlobalCombineFnRunner<InputT, AccumT, OutputT> {
        private final CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFnWithContext;

        private CombineFnWithContextRunner(CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFnWithContext) {
            this.combineFnWithContext = combineFnWithContext;
        }

        public String toString() {
            return this.combineFnWithContext.toString();
        }

        @Override
        public AccumT createAccumulator(PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.combineFnWithContext.createAccumulator(GlobalCombineFnRunners.createFromComponents(options, sideInputReader, Iterables.getOnlyElement(windows)));
        }

        @Override
        public AccumT addInput(AccumT accumulator, InputT input, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.combineFnWithContext.addInput(accumulator, input, GlobalCombineFnRunners.createFromComponents(options, sideInputReader, Iterables.getOnlyElement(windows)));
        }

        @Override
        public AccumT mergeAccumulators(Iterable<AccumT> accumulators, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.combineFnWithContext.mergeAccumulators(accumulators, GlobalCombineFnRunners.createFromComponents(options, sideInputReader, Iterables.getOnlyElement(windows)));
        }

        @Override
        public OutputT extractOutput(AccumT accumulator, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.combineFnWithContext.extractOutput(accumulator, GlobalCombineFnRunners.createFromComponents(options, sideInputReader, Iterables.getOnlyElement(windows)));
        }

        @Override
        public AccumT compact(AccumT accumulator, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.combineFnWithContext.compact(accumulator, GlobalCombineFnRunners.createFromComponents(options, sideInputReader, Iterables.getOnlyElement(windows)));
        }
    }

    private static class CombineFnRunner<InputT, AccumT, OutputT>
    implements GlobalCombineFnRunner<InputT, AccumT, OutputT> {
        private final Combine.CombineFn<InputT, AccumT, OutputT> combineFn;

        private CombineFnRunner(Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            this.combineFn = combineFn;
        }

        public String toString() {
            return this.combineFn.toString();
        }

        @Override
        public AccumT createAccumulator(PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.combineFn.createAccumulator();
        }

        @Override
        public AccumT addInput(AccumT accumulator, InputT input, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.combineFn.addInput(accumulator, input);
        }

        @Override
        public AccumT mergeAccumulators(Iterable<AccumT> accumulators, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.combineFn.mergeAccumulators(accumulators);
        }

        @Override
        public OutputT extractOutput(AccumT accumulator, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.combineFn.extractOutput(accumulator);
        }

        @Override
        public AccumT compact(AccumT accumulator, PipelineOptions options, SideInputReader sideInputReader, Collection<? extends BoundedWindow> windows) {
            return this.combineFn.compact(accumulator);
        }
    }
}

