/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.metrics.CounterCell;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowTracing;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class LateDataUtils {
    private LateDataUtils() {
    }

    public static Instant garbageCollectionTime(BoundedWindow window, WindowingStrategy windowingStrategy) {
        return LateDataUtils.garbageCollectionTime(window, windowingStrategy.getAllowedLateness());
    }

    public static Instant garbageCollectionTime(BoundedWindow window, Duration allowedLateness) {
        if (GlobalWindow.INSTANCE.maxTimestamp().minus(allowedLateness).isBefore(window.maxTimestamp())) {
            return GlobalWindow.INSTANCE.maxTimestamp();
        }
        return window.maxTimestamp().plus(allowedLateness);
    }

    public static <K, V> Iterable<WindowedValue<V>> dropExpiredWindows(K key, Iterable<WindowedValue<V>> elements, TimerInternals timerInternals, WindowingStrategy<?, ?> windowingStrategy, CounterCell droppedDueToLateness) {
        return FluentIterable.from(elements).transformAndConcat(input -> {
            if (input == null) {
                return null;
            }
            return input.explodeWindows();
        }).filter(input -> {
            if (input == null) {
                return false;
            }
            BoundedWindow window = Iterables.getOnlyElement(input.getWindows());
            boolean expired = window.maxTimestamp().plus(windowingStrategy.getAllowedLateness()).isBefore(timerInternals.currentInputWatermarkTime());
            if (expired) {
                droppedDueToLateness.inc();
                WindowTracing.debug("GroupAlsoByWindow: Dropping element at {} for key: {}; window: {} since it is too far behind inputWatermark: {}", input.getTimestamp(), key, window, timerInternals.currentInputWatermarkTime());
            }
            return !expired;
        });
    }
}

