/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.util.Map;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public class EmptyFlattenAsCreateFactory<T>
implements PTransformOverrideFactory<PCollectionList<T>, PCollection<T>, Flatten.PCollections<T>> {
    private static final EmptyFlattenAsCreateFactory<Object> INSTANCE = new EmptyFlattenAsCreateFactory();

    public static <T> EmptyFlattenAsCreateFactory<T> instance() {
        return INSTANCE;
    }

    private EmptyFlattenAsCreateFactory() {
    }

    @Override
    public PTransformOverrideFactory.PTransformReplacement<PCollectionList<T>, PCollection<T>> getReplacementTransform(AppliedPTransform<PCollectionList<T>, PCollection<T>, Flatten.PCollections<T>> transform) {
        Preconditions.checkArgument(transform.getInputs().isEmpty(), "Unexpected nonempty input %s for %s", transform.getInputs(), (Object)this.getClass().getSimpleName());
        return PTransformOverrideFactory.PTransformReplacement.of(PCollectionList.empty(transform.getPipeline()), new CreateEmptyFromList());
    }

    @Override
    public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<T> newOutput) {
        return ReplacementOutputs.singleton(outputs, newOutput);
    }

    private static class CreateEmptyFromList<T>
    extends PTransform<PCollectionList<T>, PCollection<T>> {
        private CreateEmptyFromList() {
        }

        @Override
        public PCollection<T> expand(PCollectionList<T> input) {
            return (PCollection)input.getPipeline().apply(Create.empty(VoidCoder.of()));
        }
    }
}

