/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.External;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.GeneratedMessageV3;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;

public class ExternalTranslation {
    public static final String EXTERNAL_TRANSFORM_URN = "beam:transform:external:v1";

    public static class ExternalTranslator
    implements PTransformTranslation.TransformTranslator<External.ExpandableTransform<?>> {
        public static PTransformTranslation.TransformTranslator create() {
            return new ExternalTranslator();
        }

        @Override
        @Nullable
        public String getUrn(External.ExpandableTransform transform) {
            return ExternalTranslation.EXTERNAL_TRANSFORM_URN;
        }

        @Override
        public boolean canTranslate(PTransform<?, ?> pTransform) {
            return pTransform instanceof External.ExpandableTransform;
        }

        @Override
        public RunnerApi.PTransform translate(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
            Preconditions.checkArgument(this.canTranslate((PTransform<?, ?>)appliedPTransform.getTransform()), "can only translate ExpandableTransform");
            External.ExpandableTransform expandableTransform = (External.ExpandableTransform)appliedPTransform.getTransform();
            String nameSpace = expandableTransform.getNamespace();
            String impulsePrefix = expandableTransform.getImpulsePrefix();
            ImmutableMap.Builder<String, String> pColRenameMapBuilder = ImmutableMap.builder();
            RunnerApi.PTransform expandedTransform = expandableTransform.getExpandedTransform();
            RunnerApi.Components expandedComponents = expandableTransform.getExpandedComponents();
            Map<PCollection, String> externalPCollectionIdMap = expandableTransform.getExternalPCollectionIdMap();
            for (PValue pcol : appliedPTransform.getInputs().values()) {
                if (!(pcol instanceof PCollection)) {
                    throw new RuntimeException("unknown input type.");
                }
                pColRenameMapBuilder.put(externalPCollectionIdMap.get(pcol), components.registerPCollection((PCollection)pcol));
            }
            for (PValue pcol : appliedPTransform.getOutputs().values()) {
                if (!(pcol instanceof PCollection)) {
                    throw new RuntimeException("unknown input type.");
                }
                pColRenameMapBuilder.put(externalPCollectionIdMap.get(pcol), components.registerPCollection((PCollection)pcol));
            }
            ImmutableMap pColRenameMap = pColRenameMapBuilder.build();
            RunnerApi.Components.Builder mergingComponentsBuilder = RunnerApi.Components.newBuilder();
            for (Map.Entry<String, RunnerApi.Coder> entry : expandedComponents.getCodersMap().entrySet()) {
                if (!entry.getKey().startsWith(nameSpace)) continue;
                mergingComponentsBuilder.putCoders(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, GeneratedMessageV3> entry : expandedComponents.getWindowingStrategiesMap().entrySet()) {
                if (!entry.getKey().startsWith(nameSpace)) continue;
                mergingComponentsBuilder.putWindowingStrategies(entry.getKey(), (RunnerApi.WindowingStrategy)entry.getValue());
            }
            for (Map.Entry<String, GeneratedMessageV3> entry : expandedComponents.getEnvironmentsMap().entrySet()) {
                if (!entry.getKey().startsWith(nameSpace)) continue;
                mergingComponentsBuilder.putEnvironments(entry.getKey(), (RunnerApi.Environment)entry.getValue());
            }
            for (Map.Entry<String, GeneratedMessageV3> entry : expandedComponents.getPcollectionsMap().entrySet()) {
                if (!entry.getKey().startsWith(nameSpace)) continue;
                mergingComponentsBuilder.putPcollections(entry.getKey(), (RunnerApi.PCollection)entry.getValue());
            }
            for (Map.Entry<String, GeneratedMessageV3> entry : expandedComponents.getTransformsMap().entrySet()) {
                if (entry.getKey().startsWith(impulsePrefix)) continue;
                Preconditions.checkState(entry.getKey().startsWith(nameSpace), "unknown transform found");
                RunnerApi.PTransform proto = (RunnerApi.PTransform)entry.getValue();
                RunnerApi.PTransform.Builder transformBuilder = RunnerApi.PTransform.newBuilder();
                transformBuilder.setUniqueName(proto.getUniqueName()).setSpec(proto.getSpec()).addAllSubtransforms(proto.getSubtransformsList());
                for (Map.Entry<String, String> inputEntry : proto.getInputsMap().entrySet()) {
                    transformBuilder.putInputs(inputEntry.getKey(), pColRenameMap.getOrDefault(inputEntry.getValue(), inputEntry.getValue()));
                }
                for (Map.Entry<String, String> outputEntry : proto.getOutputsMap().entrySet()) {
                    transformBuilder.putOutputs(outputEntry.getKey(), pColRenameMap.getOrDefault(outputEntry.getValue(), outputEntry.getValue()));
                }
                mergingComponentsBuilder.putTransforms(entry.getKey(), transformBuilder.build());
            }
            RunnerApi.PTransform.Builder rootTransformBuilder = RunnerApi.PTransform.newBuilder();
            rootTransformBuilder.setUniqueName(expandedTransform.getUniqueName()).setSpec(expandedTransform.getSpec()).addAllSubtransforms(expandedTransform.getSubtransformsList()).putAllInputs(expandedTransform.getInputsMap());
            for (Map.Entry<String, String> outputEntry : expandedTransform.getOutputsMap().entrySet()) {
                rootTransformBuilder.putOutputs(outputEntry.getKey(), pColRenameMap.getOrDefault(outputEntry.getValue(), outputEntry.getValue()));
            }
            components.mergeFrom(mergingComponentsBuilder.build());
            return rootTransformBuilder.build();
        }
    }
}

