/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.util.Map;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

public class PrimitiveCreate<T>
extends PTransform<PBegin, PCollection<T>> {
    private final Create.Values<T> transform;
    private final Coder<T> coder;

    private PrimitiveCreate(Create.Values<T> transform, Coder<T> coder) {
        this.transform = transform;
        this.coder = coder;
    }

    @Override
    public PCollection<T> expand(PBegin input) {
        return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.BOUNDED, this.coder);
    }

    public Iterable<T> getElements() {
        return this.transform.getElements();
    }

    public static class Factory<T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Create.Values<T>> {
        @Override
        public PTransformOverrideFactory.PTransformReplacement<PBegin, PCollection<T>> getReplacementTransform(AppliedPTransform<PBegin, PCollection<T>, Create.Values<T>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of(transform.getPipeline().begin(), new PrimitiveCreate(transform.getTransform(), ((PCollection)Iterables.getOnlyElement(transform.getOutputs().values())).getCoder()));
        }

        @Override
        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }
}

