/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PCollectionTranslation;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;

public class ReadTranslation {
    private static final String JAVA_SERIALIZED_BOUNDED_SOURCE = "beam:java:boundedsource:v1";
    private static final String JAVA_SERIALIZED_UNBOUNDED_SOURCE = "beam:java:unboundedsource:v1";

    public static RunnerApi.ReadPayload toProto(Read.Bounded<?> read, SdkComponents components) {
        return RunnerApi.ReadPayload.newBuilder().setIsBounded(RunnerApi.IsBounded.Enum.BOUNDED).setSource(ReadTranslation.toProto(read.getSource(), components)).build();
    }

    public static RunnerApi.ReadPayload toProto(Read.Unbounded<?> read, SdkComponents components) {
        return RunnerApi.ReadPayload.newBuilder().setIsBounded(RunnerApi.IsBounded.Enum.UNBOUNDED).setSource(ReadTranslation.toProto(read.getSource(), components)).build();
    }

    public static RunnerApi.SdkFunctionSpec toProto(Source<?> source, SdkComponents components) {
        if (source instanceof BoundedSource) {
            return ReadTranslation.toProto((BoundedSource)source, components);
        }
        if (source instanceof UnboundedSource) {
            return ReadTranslation.toProto((UnboundedSource)source, components);
        }
        throw new IllegalArgumentException(String.format("Unknown %s type %s", Source.class.getSimpleName(), source.getClass()));
    }

    private static RunnerApi.SdkFunctionSpec toProto(BoundedSource<?> source, SdkComponents components) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.getOnlyEnvironmentId()).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_BOUNDED_SOURCE).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray(source))).build()).build();
    }

    public static BoundedSource<?> boundedSourceFromProto(RunnerApi.ReadPayload payload) throws InvalidProtocolBufferException {
        Preconditions.checkArgument(payload.getIsBounded().equals(RunnerApi.IsBounded.Enum.BOUNDED));
        return (BoundedSource)SerializableUtils.deserializeFromByteArray(payload.getSource().getSpec().getPayload().toByteArray(), "BoundedSource");
    }

    public static <T> BoundedSource<T> boundedSourceFromTransform(AppliedPTransform<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> transform) throws IOException {
        return ReadTranslation.boundedSourceFromProto(ReadTranslation.getReadPayload(transform));
    }

    public static <T, CheckpointT extends UnboundedSource.CheckpointMark> UnboundedSource<T, CheckpointT> unboundedSourceFromTransform(AppliedPTransform<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> transform) throws IOException {
        return ReadTranslation.unboundedSourceFromProto(ReadTranslation.getReadPayload(transform));
    }

    private static <T> RunnerApi.ReadPayload getReadPayload(AppliedPTransform<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> transform) throws IOException {
        SdkComponents components = SdkComponents.create(transform.getPipeline().getOptions());
        return RunnerApi.ReadPayload.parseFrom(PTransformTranslation.toProto(transform, Collections.emptyList(), components).getSpec().getPayload());
    }

    private static RunnerApi.SdkFunctionSpec toProto(UnboundedSource<?, ?> source, SdkComponents components) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.getOnlyEnvironmentId()).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_UNBOUNDED_SOURCE).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray(source))).build()).build();
    }

    public static UnboundedSource<?, ?> unboundedSourceFromProto(RunnerApi.ReadPayload payload) throws InvalidProtocolBufferException {
        Preconditions.checkArgument(payload.getIsBounded().equals(RunnerApi.IsBounded.Enum.UNBOUNDED));
        return (UnboundedSource)SerializableUtils.deserializeFromByteArray(payload.getSource().getSpec().getPayload().toByteArray(), "UnboundedSource");
    }

    public static PCollection.IsBounded sourceIsBounded(AppliedPTransform<?, ?, ?> transform) {
        try {
            SdkComponents components = SdkComponents.create(transform.getPipeline().getOptions());
            return PCollectionTranslation.fromProto(RunnerApi.ReadPayload.parseFrom(PTransformTranslation.toProto(transform, Collections.emptyList(), components).getSpec().getPayload()).getIsBounded());
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error determining boundedness of Read", e);
        }
    }

    @AutoService(value=TransformPayloadTranslatorRegistrar.class)
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(Read.Unbounded.class, new UnboundedReadPayloadTranslator()).put(Read.Bounded.class, (UnboundedReadPayloadTranslator)((Object)new BoundedReadPayloadTranslator())).build();
        }
    }

    public static class BoundedReadPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Read.Bounded<?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new BoundedReadPayloadTranslator();
        }

        private BoundedReadPayloadTranslator() {
        }

        @Override
        public String getUrn(Read.Bounded<?> transform) {
            return PTransformTranslation.READ_TRANSFORM_URN;
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Read.Bounded<?>> transform, SdkComponents components) {
            RunnerApi.ReadPayload payload = ReadTranslation.toProto(transform.getTransform(), components);
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(payload.toByteString()).build();
        }
    }

    public static class UnboundedReadPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Read.Unbounded<?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new UnboundedReadPayloadTranslator();
        }

        private UnboundedReadPayloadTranslator() {
        }

        @Override
        public String getUrn(Read.Unbounded<?> transform) {
            return PTransformTranslation.READ_TRANSFORM_URN;
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Read.Unbounded<?>> transform, SdkComponents components) {
            RunnerApi.ReadPayload payload = ReadTranslation.toProto(transform.getTransform(), components);
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(payload.toByteString()).build();
        }
    }
}

