/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TaggedPValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

public class ReplacementOutputs {
    private ReplacementOutputs() {
    }

    public static Map<PValue, PTransformOverrideFactory.ReplacementOutput> singleton(Map<TupleTag<?>, PValue> original, PValue replacement) {
        Map.Entry<TupleTag<?>, PValue> originalElement = Iterables.getOnlyElement(original.entrySet());
        TupleTag<?> replacementTag = Iterables.getOnlyElement(replacement.expand().entrySet()).getKey();
        return Collections.singletonMap(replacement, PTransformOverrideFactory.ReplacementOutput.of(TaggedPValue.of(originalElement.getKey(), originalElement.getValue()), TaggedPValue.of(replacementTag, replacement)));
    }

    public static Map<PValue, PTransformOverrideFactory.ReplacementOutput> tagged(Map<TupleTag<?>, PValue> original, POutput replacement) {
        HashMap originalTags = new HashMap();
        for (Map.Entry<TupleTag<?>, PValue> originalValue : original.entrySet()) {
            originalTags.put(originalValue.getKey(), TaggedPValue.of(originalValue.getKey(), originalValue.getValue()));
        }
        ImmutableMap.Builder<PValue, PTransformOverrideFactory.ReplacementOutput> resultBuilder = ImmutableMap.builder();
        HashSet missingTags = new HashSet(originalTags.keySet());
        for (Map.Entry<TupleTag<?>, PValue> replacementValue : replacement.expand().entrySet()) {
            TaggedPValue mapped = (TaggedPValue)originalTags.get(replacementValue.getKey());
            Preconditions.checkArgument(mapped != null, "Missing original output for Tag %s and Value %s Between original %s and replacement %s", replacementValue.getKey(), (Object)replacementValue.getValue(), original, replacement.expand());
            resultBuilder.put(replacementValue.getValue(), PTransformOverrideFactory.ReplacementOutput.of(mapped, TaggedPValue.of(replacementValue.getKey(), replacementValue.getValue())));
            missingTags.remove(replacementValue.getKey());
        }
        ImmutableMap<PValue, PTransformOverrideFactory.ReplacementOutput> result = resultBuilder.build();
        Preconditions.checkArgument(missingTags.isEmpty(), "Missing replacement for tags %s. Encountered tags: %s", missingTags, (Object)result.keySet());
        return result;
    }
}

